/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *		Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/

package com.atmel.avr32.sf.core;

import org.eclipse.core.resources.IResource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


/**
 * Utility type for reading the framework data XML file and populate a
 * FrameworkData instance using the file contents.
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.0
 */
public class FrameworkDataReader extends DefaultHandler {

    private static final String CHANGED = "changed"; //$NON-NLS-1$
    private static final String VERSION = "version"; //$NON-NLS-1$
    private static final String SOURCE = "source"; //$NON-NLS-1$
    private static final String FRAMEWORK = "framework"; //$NON-NLS-1$
    private static final String PATH = "path"; //$NON-NLS-1$
    private static final String FILE = "file"; //$NON-NLS-1$
    private static final String VALUE = "value"; //$NON-NLS-1$
    private static final String ID = "id"; //$NON-NLS-1$
    private static final String OPTION = "option"; //$NON-NLS-1$
    private FrameworkProjectData data;

    public FrameworkDataReader(FrameworkProjectData data) {
        super();
        this.data = data;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xml.sax.helpers.DefaultHandler#startElement(java.lang.String,
     *      java.lang.String, java.lang.String, org.xml.sax.Attributes)
     */
    @Override
    public void startElement(String uri, String localName, String qName,
            Attributes atts) throws SAXException {
        if (qName.equals(OPTION)) {
            String id = atts.getValue(ID);
            String value = atts.getValue(VALUE);
            data.setValue(id, value);
        }
        if (qName.equals(FILE)) {
            String path = atts.getValue(PATH);
            IResource file = data.getProject().getFile(path);
            FrameworkFileDescriptor descriptor = new FrameworkFileDescriptor(
                    file);
            descriptor.setFramework(atts.getValue(FRAMEWORK));
            descriptor.setSource(atts.getValue(SOURCE));
            descriptor.setVersion(atts.getValue(VERSION));
            descriptor.setChanged(Boolean.parseBoolean(atts.getValue(CHANGED)));
            data.addFrameworkDescriptor(descriptor);
        }
    }

}
