/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.search;

import com.atmel.avr32.debug.trace.data.ITraceFrame;
import com.atmel.avr32.debug.trace.ui.TraceUIPlugin;
import com.atmel.avr32.debug.trace.ui.internal.search.Messages;
import com.atmel.avr32.debug.trace.ui.internal.search.TraceSearchQuery;
import com.atmel.avr32.debug.trace.ui.internal.search.TraceSearchResultEvent;
import com.atmel.avr32.debug.trace.ui.internal.search.TraceSearchSettings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

public class TraceSearchResult
implements ISearchResult {
    private final TraceSearchQuery query;
    private final List<ITraceFrame> fResult;
    private final List<ISearchResultListener> fListeners;
    private final TraceSearchResultEvent fEvent;

    public TraceSearchResult(TraceSearchQuery query) {
        this.query = query;
        this.fListeners = new ArrayList<ISearchResultListener>();
        this.fResult = new ArrayList<ITraceFrame>();
        this.fEvent = new TraceSearchResultEvent(this);
    }

    public int size() {
        return this.fResult.size();
    }

    public ITraceFrame get(int index) {
        return this.fResult.get(index);
    }

    public void addResult(ITraceFrame frame) {
        this.fResult.add(frame);
        for (ISearchResultListener listener : this.fListeners) {
            this.fEvent.item = frame;
            listener.searchResultChanged((SearchResultEvent)this.fEvent);
        }
    }

    public ITraceFrame[] getResult() {
        return this.fResult.toArray(new ITraceFrame[this.fResult.size()]);
    }

    public ImageDescriptor getImageDescriptor() {
        return TraceUIPlugin.getViewImageDescriptor("icons/obj16/watchpoint_obj.gif");
    }

    public String getLabel() {
        TraceSearchSettings settings = ((TraceSearchQuery)this.getQuery()).getSettings();
        StringBuffer sb = new StringBuffer();
        if (settings.isDataTrace()) {
            sb.append(Messages.TraceSearchResult_DataTraceSearch);
        }
        if (settings.isError()) {
            sb.append(Messages.TraceSearchResult_ErrorSearch);
        }
        if (settings.isDebugStatus()) {
            sb.append(Messages.TraceSearchResult_DebsSearch);
        } else if (settings.isProgramTrace()) {
            sb.append(Messages.TraceSearchResult_ProgramTraceSearch);
            if (!settings.isDisregardPtName()) {
                sb.append("for function \"");
                sb.append(settings.getFunctionName());
                sb.append("\"");
            } else {
                sb.append("for functions between ");
                sb.append(settings.getPtStartAddress());
                sb.append(" and ");
                sb.append(settings.getPtEndAddress());
            }
        }
        sb.append(" - ");
        sb.append(this.fResult.size());
        sb.append(" matches in ");
        sb.append(settings.getSessionName());
        return sb.toString();
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }
}

