/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.search;

import com.atmel.avr32.debug.trace.TracePlugin;
import com.atmel.avr32.debug.trace.client.TraceClient;
import com.atmel.avr32.debug.trace.client.TraceException;
import com.atmel.avr32.debug.trace.data.DataTraceFrame;
import com.atmel.avr32.debug.trace.data.DebugStatusFrame;
import com.atmel.avr32.debug.trace.data.ErrorFrame;
import com.atmel.avr32.debug.trace.data.ITraceFrame;
import com.atmel.avr32.debug.trace.data.ProgramTraceFrame;
import com.atmel.avr32.debug.trace.ui.internal.search.Messages;
import com.atmel.avr32.debug.trace.ui.internal.search.TraceSearchResult;
import com.atmel.avr32.debug.trace.ui.internal.search.TraceSearchSettings;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class TraceSearchQuery
implements ISearchQuery {
    private static final int BATCH_SIZE = 500;
    TraceSearchSettings settings;
    TraceClient client;
    TraceSearchResult fResult;

    public TraceSearchQuery(TraceSearchSettings settings) {
        this.settings = settings;
        this.fResult = new TraceSearchResult(this);
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return Messages.TraceSearchQuery_Label;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    private boolean testProgramTrace(ITraceFrame frame) {
        ProgramTraceFrame ptFrame = (ProgramTraceFrame)frame;
        switch (ptFrame.getBranch()) {
            case CALL: {
                if (this.settings.isBtCall()) break;
                return false;
            }
            case DIRECT_BRANCH: {
                if (this.settings.isBtDirect()) break;
                return false;
            }
            case EXCEPTION: {
                if (this.settings.isBtException()) break;
                return false;
            }
            case PC_MODIFIED: {
                if (this.settings.isBtModifiedPC()) break;
                return false;
            }
            case RETURN: {
                if (this.settings.isBtReturn()) break;
                return false;
            }
        }
        if (!this.settings.isDisregardPtName() && !this.settings.getFunctionName().equals(frame.getText())) {
            return false;
        }
        if (!this.settings.isDisregardPtAddress()) {
            if (Long.decode(frame.getAddress()) < Long.decode(this.settings.getPtStartAddress())) {
                return false;
            }
            if (Long.decode(frame.getAddress()) > Long.decode(this.settings.getPtEndAddress())) {
                return false;
            }
        }
        return true;
    }

    private boolean testDataTrace(ITraceFrame frame) {
        DataTraceFrame dtFrame = (DataTraceFrame)frame;
        if (dtFrame.isWrite() && !this.settings.isDtAccessWrite()) {
            return false;
        }
        if (!dtFrame.isWrite() && !this.settings.isDtAccessRead()) {
            return false;
        }
        if (!this.settings.isDisregardDtValue() && Long.decode(dtFrame.getValue()) != Long.decode(this.settings.getDtValue())) {
            return false;
        }
        if (!this.settings.isDisregardDtAddress()) {
            if (Long.decode(frame.getAddress()) < Long.decode(this.settings.getPtStartAddress())) {
                return false;
            }
            if (Long.decode(frame.getAddress()) > Long.decode(this.settings.getPtEndAddress())) {
                return false;
            }
        }
        return true;
    }

    private boolean testDebugStatus(ITraceFrame frame) {
        return true;
    }

    private boolean testError(ITraceFrame frame) {
        return true;
    }

    private IStatus test(int position, int length) {
        try {
            ITraceFrame[] frames;
            ITraceFrame[] iTraceFrameArray = frames = this.client.getData(position, length);
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                ITraceFrame frame = iTraceFrameArray[n2];
                if (frame instanceof DataTraceFrame && this.settings.isDataTrace() && this.testDataTrace(frame)) {
                    this.fResult.addResult(frame);
                }
                if (frame instanceof ProgramTraceFrame && this.settings.isProgramTrace() && this.testProgramTrace(frame)) {
                    this.fResult.addResult(frame);
                }
                if (frame instanceof DebugStatusFrame && this.settings.isDebugStatus() && this.testDebugStatus(frame)) {
                    this.fResult.addResult(frame);
                }
                if (frame instanceof ErrorFrame && this.settings.isError() && this.testError(frame)) {
                    this.fResult.addResult(frame);
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
        catch (TraceException e) {
            return new Status(4, "com.atmel.avr32.debug.trace.ui", Messages.TraceSearchQuery_NoDataError, (Throwable)e);
        }
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        TraceClient[] clients;
        TraceClient[] traceClientArray = clients = TracePlugin.getDefault().getTraceSessions();
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            TraceClient traceClient = traceClientArray[n2];
            if (traceClient.getName().equals(this.settings.getSessionName())) {
                this.client = traceClient;
            }
            ++n2;
        }
        int length = this.client.getDataLength();
        monitor.beginTask(this.settings.getSessionName(), length);
        int position = 0;
        while (position < length) {
            monitor.subTask(MessageFormat.format(Messages.TraceSearchQuery_Examining, position, length));
            monitor.worked(500);
            IStatus status = this.test(position, 500);
            if (!status.isOK()) {
                return status;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            position += 500;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public TraceSearchSettings getSettings() {
        return this.settings;
    }
}

