/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.search;

import com.atmel.avr32.debug.trace.data.ITraceFrame;
import com.atmel.avr32.debug.trace.data.ProgramTraceFrame;
import com.atmel.avr32.debug.trace.ui.TraceUIPlugin;
import com.atmel.avr32.debug.trace.ui.internal.Messages;
import com.atmel.avr32.debug.trace.ui.internal.TraceColumnLabelProvider;
import com.atmel.avr32.debug.trace.ui.internal.TraceDataViewer;
import com.atmel.avr32.debug.trace.ui.internal.TraceFrameDoubleClickListener;
import com.atmel.avr32.debug.trace.ui.internal.search.TraceSearchResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;

public class SearchResultPage
extends Page
implements ISearchResultPage {
    private boolean fIsBusyShown;
    private TraceDataViewer fViewer;
    private String fId;
    private TraceSearchContentProvider fContentProvider;
    private static final String EMPTY_STRING = "";
    private TraceSearchResult fInput;
    private volatile boolean fIsUIUpdateScheduled = false;
    private volatile boolean fScheduleEnsureSelection = false;
    private ISearchResultViewPart fViewPart;

    private boolean isQueryRunning() {
        if (this.fInput != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)this.fInput.getQuery());
        }
        return false;
    }

    private void turnOffDecoration() {
        IBaseLabelProvider lp = this.fViewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(null);
        }
    }

    private void turnOnDecoration() {
        IBaseLabelProvider lp = this.fViewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        }
    }

    private void configureTableViewer(TableViewer viewer) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0x1000000);
        column.getColumn().setText(EMPTY_STRING);
        column.getColumn().setWidth(25);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(viewer){

            public Image getImage(Object element) {
                if (element instanceof ProgramTraceFrame) {
                    ProgramTraceFrame td = (ProgramTraceFrame)element;
                    switch (td.getBranch()) {
                        case CALL: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_CALL");
                        }
                        case DIRECT_BRANCH: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_DIRECT");
                        }
                        case EXCEPTION: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_EXEPTION");
                        }
                        case PC_MODIFIED: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_REGISTER");
                        }
                        case RETURN: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_RETURN");
                        }
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return SearchResultPage.EMPTY_STRING;
            }

            public String getToolTipText(Object element) {
                if (element instanceof ProgramTraceFrame) {
                    return ((ProgramTraceFrame)element).getTooltip();
                }
                return null;
            }
        });
        column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText("Frame #");
        column.getColumn().setWidth(125);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(viewer){

            public String getText(Object element) {
                if (element instanceof ITraceFrame) {
                    return ((ITraceFrame)element).getSequence();
                }
                return SearchResultPage.EMPTY_STRING;
            }
        });
        column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(Messages.TraceView_Address);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(viewer){

            public String getText(Object element) {
                if (element instanceof ITraceFrame) {
                    return ((ITraceFrame)element).getAddress();
                }
                return SearchResultPage.EMPTY_STRING;
            }
        });
        column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(Messages.TraceView_Trace);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(viewer){

            public String getText(Object element) {
                if (element instanceof ITraceFrame) {
                    return ((ITraceFrame)element).getText();
                }
                return SearchResultPage.EMPTY_STRING;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        viewer.getTable().setHeaderVisible(true);
        viewer.setUseHashlookup(false);
        this.fContentProvider = new TraceSearchContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.addDoubleClickListener((IDoubleClickListener)new TraceFrameDoubleClickListener());
    }

    public void createControl(Composite parent) {
        this.fViewer = new TraceDataViewer(null, parent, 268501764, false);
        this.configureTableViewer(this.fViewer);
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    public void setFocus() {
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        if (this.fInput == null) {
            return EMPTY_STRING;
        }
        return this.fInput.getLabel();
    }

    public Object getUIState() {
        return null;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.fId = id;
    }

    private synchronized void scheduleUIUpdate() {
        if (!this.fIsUIUpdateScheduled) {
            this.fIsUIUpdateScheduled = true;
            new UpdateUIJob().schedule();
        }
    }

    private void updateBusyLabel() {
        boolean shouldShowBusy;
        boolean bl = shouldShowBusy = this.fInput != null && NewSearchUI.isQueryRunning((ISearchQuery)this.fInput.getQuery()) && this.fInput.size() == 0;
        if (shouldShowBusy == this.fIsBusyShown) {
            return;
        }
        this.fIsBusyShown = shouldShowBusy;
    }

    public void setInput(ISearchResult search, Object uiState) {
        this.fInput = (TraceSearchResult)search;
        this.fViewer.setInput(search);
        this.updateBusyLabel();
        this.turnOffDecoration();
        this.scheduleUIUpdate();
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    private class TraceSearchContentProvider
    implements ILazyContentProvider,
    ISearchResultListener {
        private TraceSearchResult input;

        private TraceSearchContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof TraceSearchResult) {
                ((TraceSearchResult)newInput).addListener(this);
                this.input = (TraceSearchResult)newInput;
            }
        }

        public void searchResultChanged(SearchResultEvent e) {
        }

        public void updateElement(int index) {
            if (index < this.input.size()) {
                SearchResultPage.this.fViewer.replace(this.input.get(index), index);
            }
        }
    }

    private class UpdateUIJob
    extends UIJob {
        public UpdateUIJob() {
            super(Messages.SearchResultPage_0);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = SearchResultPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return Status.OK_STATUS;
            }
            this.doUpdate();
            if (SearchResultPage.this.isQueryRunning()) {
                this.schedule(500L);
            } else {
                SearchResultPage.this.fIsUIUpdateScheduled = false;
                SearchResultPage.this.turnOnDecoration();
                SearchResultPage.this.updateBusyLabel();
                if (SearchResultPage.this.fScheduleEnsureSelection) {
                    SearchResultPage.this.fScheduleEnsureSelection = false;
                }
            }
            SearchResultPage.this.fViewPart.updateLabel();
            return Status.OK_STATUS;
        }

        private void doUpdate() {
            Runnable update = new Runnable(){

                @Override
                public void run() {
                    if (SearchResultPage.this.fViewer != null) {
                        SearchResultPage.this.fViewer.setItemCount(SearchResultPage.this.fInput.size());
                    }
                }
            };
            SearchResultPage.this.fViewer.getControl().getDisplay().asyncExec(update);
        }
    }
}

