/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.search;

import com.atmel.avr32.debug.AVR32NM;
import com.atmel.avr32.debug.trace.TracePlugin;
import com.atmel.avr32.debug.trace.client.TraceClient;
import com.atmel.avr32.debug.trace.ui.internal.search.Messages;
import com.atmel.avr32.debug.trace.ui.internal.search.TraceSearchSettings;
import com.atmel.avr32.debug.ui.SymbolSelectionDialog;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SearchPageComposite
extends Composite {
    private static final String HEX_ZERO = "0x0";
    private Button errorButton;
    private CLabel statusLabel;
    private Group traceTypeGroup;
    private Group branchTypeGroup;
    private Group dataTraceOptionsGroup;
    private Group programTraceOptionsGroup;
    private Button writesButton;
    private Button readButton;
    private Button ignorePtAddress;
    private Button ignorePtName;
    private Button ignoreDtValue;
    private Button ignoreDtAddress;
    private Text text_5;
    private Text text_4;
    private Text text_3;
    private Text text_1;
    private Text text;
    private Button functionReturnButton;
    private Button modifiedPcButton;
    private Button exceptionButton;
    private Button directBranchButton;
    private Button functionCallButton;
    private Combo combo_1;
    private Button debugButton;
    private Button dataTraceButton;
    private Text text_2;
    private Button programTraceButton;
    private TraceSearchSettings settings;

    private void setEnabled(Composite group, boolean enabled) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
        group.setEnabled(enabled);
    }

    public SearchPageComposite(Composite parent, int style, TraceSearchSettings settings) {
        super(parent, style);
        TraceClient[] sessions;
        this.settings = settings;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label debugSessionToLabel = new Label((Composite)this, 0);
        debugSessionToLabel.setText(Messages.SearchPageComposite_0);
        this.combo_1 = new Combo((Composite)this, 8);
        this.combo_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusLabel = new CLabel((Composite)this, 0);
        GridData gd_statusLabel = new GridData();
        this.statusLabel.setLayoutData((Object)gd_statusLabel);
        this.traceTypeGroup = new Group((Composite)this, 0);
        this.traceTypeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.traceTypeGroup.setLayout((Layout)new GridLayout());
        this.traceTypeGroup.setText(Messages.SearchPageComposite_1);
        this.programTraceButton = new Button((Composite)this.traceTypeGroup, 16);
        this.programTraceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageComposite.this.updateEnablement();
            }
        });
        this.programTraceButton.setText(Messages.SearchPageComposite_2);
        this.dataTraceButton = new Button((Composite)this.traceTypeGroup, 16);
        this.dataTraceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageComposite.this.updateEnablement();
            }
        });
        this.dataTraceButton.setText(Messages.SearchPageComposite_3);
        this.debugButton = new Button((Composite)this.traceTypeGroup, 16);
        this.debugButton.setText(Messages.SearchPageComposite_4);
        this.errorButton = new Button((Composite)this.traceTypeGroup, 16);
        this.errorButton.setText(Messages.SearchPageComposite_5);
        this.dataTraceOptionsGroup = new Group((Composite)this, 0);
        this.dataTraceOptionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 7;
        this.dataTraceOptionsGroup.setLayout((Layout)gridLayout_1);
        this.dataTraceOptionsGroup.setText(Messages.SearchPageComposite_6);
        Label locationLabel = new Label((Composite)this.dataTraceOptionsGroup, 0);
        locationLabel.setText(Messages.SearchPageComposite_7);
        this.text = new Text((Composite)this.dataTraceOptionsGroup, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Button dtStartBrowseButton = new Button((Composite)this.dataTraceOptionsGroup, 0);
        dtStartBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVR32NM.AddressNamePair address = SearchPageComposite.this.browse(SymbolSelectionDialog.SymbolType.ALL);
                if (address != null) {
                    SearchPageComposite.this.text.setText(SearchPageComposite.HEX_ZERO + Long.toHexString(address.address));
                }
            }
        });
        dtStartBrowseButton.setText(Messages.SearchPageComposite_Ellipsis);
        Label label_1 = new Label((Composite)this.dataTraceOptionsGroup, 0);
        label_1.setAlignment(0x1000000);
        label_1.setText("-");
        this.text_5 = new Text((Composite)this.dataTraceOptionsGroup, 2048);
        this.text_5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button dtEndBrowseButton = new Button((Composite)this.dataTraceOptionsGroup, 0);
        dtEndBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVR32NM.AddressNamePair address = SearchPageComposite.this.browse(SymbolSelectionDialog.SymbolType.ALL);
                if (address != null) {
                    SearchPageComposite.this.text_5.setText(SearchPageComposite.HEX_ZERO + Long.toHexString(address.address));
                }
            }
        });
        dtEndBrowseButton.setText(Messages.SearchPageComposite_Ellipsis);
        this.ignoreDtAddress = new Button((Composite)this.dataTraceOptionsGroup, 32);
        this.ignoreDtAddress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageComposite.this.updateEnablement();
            }
        });
        this.ignoreDtAddress.setText(Messages.SearchPageComposite_11);
        Label valueLabel = new Label((Composite)this.dataTraceOptionsGroup, 0);
        GridData gd_valueLabel = new GridData();
        valueLabel.setLayoutData((Object)gd_valueLabel);
        valueLabel.setText(Messages.SearchPageComposite_12);
        this.text_1 = new Text((Composite)this.dataTraceOptionsGroup, 2048);
        this.text_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        this.ignoreDtValue = new Button((Composite)this.dataTraceOptionsGroup, 32);
        this.ignoreDtValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageComposite.this.updateEnablement();
            }
        });
        this.ignoreDtValue.setText(Messages.SearchPageComposite_13);
        Label accessTypeLabel = new Label((Composite)this.dataTraceOptionsGroup, 0);
        accessTypeLabel.setText(Messages.SearchPageComposite_14);
        Composite composite = new Composite((Composite)this.dataTraceOptionsGroup, 0);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 5, 1));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.makeColumnsEqualWidth = true;
        gridLayout_3.marginWidth = 0;
        gridLayout_3.marginHeight = 0;
        gridLayout_3.numColumns = 2;
        composite.setLayout((Layout)gridLayout_3);
        this.readButton = new Button(composite, 32);
        this.readButton.setLayoutData((Object)new GridData());
        this.readButton.setText(Messages.SearchPageComposite_15);
        this.writesButton = new Button(composite, 32);
        GridData gd_writesButton = new GridData();
        this.writesButton.setLayoutData((Object)gd_writesButton);
        this.writesButton.setText(Messages.SearchPageComposite_16);
        new Label((Composite)this.dataTraceOptionsGroup, 0);
        this.branchTypeGroup = new Group((Composite)this, 0);
        GridData gd_branchTypeGroup = new GridData(4, 4, false, false);
        this.branchTypeGroup.setLayoutData((Object)gd_branchTypeGroup);
        this.branchTypeGroup.setText(Messages.SearchPageComposite_17);
        this.branchTypeGroup.setLayout((Layout)new GridLayout());
        this.functionCallButton = new Button((Composite)this.branchTypeGroup, 32);
        this.functionCallButton.setText(Messages.SearchPageComposite_18);
        this.directBranchButton = new Button((Composite)this.branchTypeGroup, 32);
        this.directBranchButton.setText(Messages.SearchPageComposite_19);
        this.exceptionButton = new Button((Composite)this.branchTypeGroup, 32);
        this.exceptionButton.setText(Messages.SearchPageComposite_20);
        this.modifiedPcButton = new Button((Composite)this.branchTypeGroup, 32);
        this.modifiedPcButton.setText(Messages.SearchPageComposite_21);
        this.functionReturnButton = new Button((Composite)this.branchTypeGroup, 32);
        this.functionReturnButton.setText(Messages.SearchPageComposite_22);
        this.programTraceOptionsGroup = new Group((Composite)this, 0);
        this.programTraceOptionsGroup.setText(Messages.SearchPageComposite_23);
        GridData gd_programTraceOptionsGroup = new GridData(4, 128, false, false, 2, 1);
        this.programTraceOptionsGroup.setLayoutData((Object)gd_programTraceOptionsGroup);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 7;
        this.programTraceOptionsGroup.setLayout((Layout)gridLayout_2);
        Label functionNameLabel = new Label((Composite)this.programTraceOptionsGroup, 0);
        functionNameLabel.setText(Messages.SearchPageComposite_24);
        this.text_2 = new Text((Composite)this.programTraceOptionsGroup, 2048);
        this.text_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Button ptNameBrowseButton = new Button((Composite)this.programTraceOptionsGroup, 0);
        GridData gd_ptNameBrowseButton = new GridData();
        ptNameBrowseButton.setLayoutData((Object)gd_ptNameBrowseButton);
        ptNameBrowseButton.setToolTipText(Messages.SearchPageComposite_25);
        ptNameBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVR32NM.AddressNamePair address = SearchPageComposite.this.browse(SymbolSelectionDialog.SymbolType.TEXT);
                if (address != null) {
                    SearchPageComposite.this.text_2.setText(String.valueOf(address.name) + "()");
                }
            }
        });
        ptNameBrowseButton.setText(Messages.SearchPageComposite_Ellipsis);
        this.ignorePtName = new Button((Composite)this.programTraceOptionsGroup, 32);
        this.ignorePtName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageComposite.this.updateEnablement();
            }
        });
        GridData gd_ignorePtName = new GridData();
        this.ignorePtName.setLayoutData((Object)gd_ignorePtName);
        this.ignorePtName.setText(Messages.SearchPageComposite_28);
        Label addressLabel = new Label((Composite)this.programTraceOptionsGroup, 0);
        addressLabel.setText(Messages.SearchPageComposite_29);
        this.text_3 = new Text((Composite)this.programTraceOptionsGroup, 2048);
        this.text_3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button ptStartBrowseButton = new Button((Composite)this.programTraceOptionsGroup, 0);
        ptStartBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVR32NM.AddressNamePair address = SearchPageComposite.this.browse(SymbolSelectionDialog.SymbolType.TEXT);
                if (address != null) {
                    SearchPageComposite.this.text_3.setText(SearchPageComposite.HEX_ZERO + Long.toHexString(address.address));
                }
            }
        });
        ptStartBrowseButton.setText(Messages.SearchPageComposite_Ellipsis);
        Label label = new Label((Composite)this.programTraceOptionsGroup, 0);
        label.setText("-");
        this.text_4 = new Text((Composite)this.programTraceOptionsGroup, 2048);
        this.text_4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button ptEndBrowseButton = new Button((Composite)this.programTraceOptionsGroup, 0);
        ptEndBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVR32NM.AddressNamePair address = SearchPageComposite.this.browse(SymbolSelectionDialog.SymbolType.TEXT);
                if (address != null) {
                    SearchPageComposite.this.text_4.setText(SearchPageComposite.HEX_ZERO + Long.toHexString(address.address));
                }
            }
        });
        ptEndBrowseButton.setText(Messages.SearchPageComposite_Ellipsis);
        this.ignorePtAddress = new Button((Composite)this.programTraceOptionsGroup, 32);
        this.ignorePtAddress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageComposite.this.updateEnablement();
            }
        });
        this.ignorePtAddress.setText(Messages.SearchPageComposite_33);
        this.initDataBindings();
        this.updateEnablement();
        TraceClient[] traceClientArray = sessions = TracePlugin.getDefault().getTraceSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            TraceClient traceClient = traceClientArray[n2];
            this.combo_1.add(traceClient.getName());
            ++n2;
        }
        if (sessions.length > 0) {
            this.combo_1.select(0);
            settings.setSessionName(sessions[0].getName());
        } else {
            this.setEnabled((Composite)this.getBranchTypeGroup(), false);
            this.setEnabled((Composite)this.getDataTraceOptionsGroup(), false);
            this.setEnabled((Composite)this.getProgramTraceOptionsGroup(), false);
            this.setEnabled((Composite)this.getTraceTypeGroup(), false);
            this.getStatusLabel().setText(Messages.SearchPageComposite_34);
            this.getStatusLabel().setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        }
    }

    private IResource getResource() {
        TraceClient[] sessions;
        TraceClient[] traceClientArray = sessions = TracePlugin.getDefault().getTraceSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            TraceClient traceClient = traceClientArray[n2];
            if (traceClient.getName().equals(this.settings.getSessionName())) {
                ILaunchConfiguration configuration = traceClient.getLaunch().getLaunchConfiguration();
                try {
                    IPath objectfile = Path.fromPortableString((String)configuration.getAttribute("AVR32_ATTR_EXEPATH", ""));
                    return ResourcesPlugin.getWorkspace().getRoot().getFile(objectfile);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    private AVR32NM.AddressNamePair browse(SymbolSelectionDialog.SymbolType type) {
        IResource r = this.getResource();
        SymbolSelectionDialog dialog = new SymbolSelectionDialog(this.getShell(), type, r.getFullPath().toOSString());
        if (dialog.open() == 0 && dialog.getResult().length == 1) {
            return (AVR32NM.AddressNamePair)dialog.getResult()[0];
        }
        return null;
    }

    protected void checkSubclass() {
    }

    public TraceSearchSettings getSettings() {
        return this.settings;
    }

    protected Group getProgramTraceOptionsGroup() {
        return this.programTraceOptionsGroup;
    }

    protected Group getDataTraceOptionsGroup() {
        return this.dataTraceOptionsGroup;
    }

    protected Group getBranchTypeGroup() {
        return this.branchTypeGroup;
    }

    protected Group getTraceTypeGroup() {
        return this.traceTypeGroup;
    }

    private void updateEnablement() {
        this.setEnabled((Composite)this.getProgramTraceOptionsGroup(), this.programTraceButton.getSelection());
        this.setEnabled((Composite)this.getBranchTypeGroup(), this.programTraceButton.getSelection());
        this.setEnabled((Composite)this.getDataTraceOptionsGroup(), this.dataTraceButton.getSelection());
    }

    protected CLabel getStatusLabel() {
        return this.statusLabel;
    }

    protected DataBindingContext initDataBindings() {
        ISWTObservableValue functionReturnButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.functionReturnButton);
        ISWTObservableValue dataTraceButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.dataTraceButton);
        ISWTObservableValue readButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.readButton);
        IObservableValue settingsBtModifiedPCObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"btModifiedPC");
        IObservableValue settingsBtCallObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"btCall");
        ISWTObservableValue text_1TextObserveWidget = SWTObservables.observeText((Control)this.text_1, (int)24);
        IObservableValue settingsAddressObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"dtStartAddress");
        IObservableValue settingsDisregardPtNameObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"disregardPtName");
        IObservableValue settingsDtAccessReadObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"dtAccessRead");
        IObservableValue settingsPtEndAddressObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"ptEndAddress");
        ISWTObservableValue ignoreButton_1SelectionObserveWidget = SWTObservables.observeSelection((Control)this.ignorePtAddress);
        ISWTObservableValue text_3TextObserveWidget = SWTObservables.observeText((Control)this.text_3, (int)24);
        IObservableValue settingsSesionNameObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"sessionName");
        ISWTObservableValue interruptButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.debugButton);
        IObservableValue settingsProgramTraceObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"programTrace");
        IObservableValue settingsBtExceptionObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"btException");
        ISWTObservableValue ignoreButton_2SelectionObserveWidget = SWTObservables.observeSelection((Control)this.ignoreDtAddress);
        IObservableValue settingsDisregardDtValueObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"disregardDtValue");
        IObservableValue settingsDtEndAddressObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"dtEndAddress");
        IObservableValue settingsDisregardDtAddressObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"disregardDtAddress");
        IObservableValue settingsBtDirectObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"btDirect");
        IObservableValue settingsInterruptObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"debugStatus");
        IObservableValue settingsErrorObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"error");
        ISWTObservableValue text_5TextObserveWidget = SWTObservables.observeText((Control)this.text_5, (int)24);
        ISWTObservableValue text_4TextObserveWidget = SWTObservables.observeText((Control)this.text_4, (int)24);
        ISWTObservableValue errorButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.errorButton);
        ISWTObservableValue writesButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.writesButton);
        ISWTObservableValue combo_1TextObserveWidget = SWTObservables.observeText((Control)this.combo_1);
        IObservableValue settingsValueObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"dtValue");
        ISWTObservableValue programTraceButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.programTraceButton);
        ISWTObservableValue ignoreButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.ignorePtName);
        ISWTObservableValue text_2TextObserveWidget = SWTObservables.observeText((Control)this.text_2, (int)24);
        IObservableValue settingsDataTraceObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"dataTrace");
        IObservableValue settingsDisregardPtAddressObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"disregardPtAddress");
        ISWTObservableValue textTextObserveWidget = SWTObservables.observeText((Control)this.text, (int)24);
        ISWTObservableValue exceptionButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.exceptionButton);
        IObservableValue settingsBtReturnObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"btReturn");
        ISWTObservableValue modifiedPcButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.modifiedPcButton);
        IObservableValue settingsDtAccessWriteObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"dtAccessWrite");
        IObservableValue settingsPtStartAddressObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"ptStartAddress");
        ISWTObservableValue directBranchButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.directBranchButton);
        IObservableValue settingsFunctionNameObserveValue = BeansObservables.observeValue((Object)this.settings, (String)"functionName");
        ISWTObservableValue ignoreButton_3SelectionObserveWidget = SWTObservables.observeSelection((Control)this.ignoreDtValue);
        ISWTObservableValue functionCallButtonSelectionObserveWidget = SWTObservables.observeSelection((Control)this.functionCallButton);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)programTraceButtonSelectionObserveWidget, settingsProgramTraceObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)dataTraceButtonSelectionObserveWidget, settingsDataTraceObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)interruptButtonSelectionObserveWidget, settingsInterruptObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)text_2TextObserveWidget, settingsFunctionNameObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)combo_1TextObserveWidget, settingsSesionNameObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)functionCallButtonSelectionObserveWidget, settingsBtCallObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)directBranchButtonSelectionObserveWidget, settingsBtDirectObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)exceptionButtonSelectionObserveWidget, settingsBtExceptionObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)modifiedPcButtonSelectionObserveWidget, settingsBtModifiedPCObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)functionReturnButtonSelectionObserveWidget, settingsBtReturnObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)textTextObserveWidget, settingsAddressObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)text_1TextObserveWidget, settingsValueObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)ignoreButton_2SelectionObserveWidget, settingsDisregardDtAddressObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)ignoreButton_3SelectionObserveWidget, settingsDisregardDtValueObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)ignoreButtonSelectionObserveWidget, settingsDisregardPtNameObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)ignoreButton_1SelectionObserveWidget, settingsDisregardPtAddressObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)text_5TextObserveWidget, settingsDtEndAddressObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)text_3TextObserveWidget, settingsPtStartAddressObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)text_4TextObserveWidget, settingsPtEndAddressObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)readButtonSelectionObserveWidget, settingsDtAccessReadObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)writesButtonSelectionObserveWidget, settingsDtAccessWriteObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)errorButtonSelectionObserveWidget, settingsErrorObserveValue, null, null);
        return bindingContext;
    }
}

