/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.export;

import com.atmel.avr32.debug.trace.client.TraceClient;
import com.atmel.avr32.debug.trace.client.TraceException;
import com.atmel.avr32.debug.trace.client.commands.TFCommand;
import com.atmel.avr32.debug.trace.ui.TraceUIPlugin;
import com.atmel.avr32.debug.trace.ui.internal.export.ExportSettings;
import com.atmel.avr32.debug.trace.ui.internal.export.ExportTraceDataPage;
import com.atmel.avr32.debug.trace.ui.internal.export.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class ExportTraceDataWizard
extends Wizard {
    private static final String FORMAT = "format";
    private static final String FILE_PATH = "filePath";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    TraceClient client;
    ExportTraceDataPage page;

    public ExportTraceDataWizard(TraceClient client) {
        this.client = client;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        ExportSettings settings = this.page.getExportSettings();
        TFCommand.Format format = TFCommand.Format.values()[settings.getFormat()];
        File file = new File(settings.getPath());
        IDialogSettings ds = TraceUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = ds.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = ds.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        section.put(FILE_PATH, settings.path);
        section.put(FORMAT, settings.format);
        return this.invokeRunnable(this.getRunnable(file, format, settings.getFrom(), settings.getTo()));
    }

    private boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    private IRunnableWithProgress getRunnable(final File file, final TFCommand.Format format, final int from, final int to) {
        return new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.ExportTraceDataWizard_TaskName, to);
                try {
                    TFCommand.Format old = ExportTraceDataWizard.this.client.getSelectedCodeFormat();
                    FileWriter fw = new FileWriter(file);
                    InputStream is = ExportTraceDataWizard.class.getResourceAsStream("export-header.txt");
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String in = null;
                    while ((in = br.readLine()) != null) {
                        fw.write(in);
                        fw.write(LINE_SEPARATOR);
                    }
                    is.close();
                    ExportTraceDataWizard.this.client.setSelectedCodeFormat(format, false);
                    int position = from;
                    while (position <= to) {
                        fw.write(ExportTraceDataWizard.this.client.getRaw(position));
                        monitor.worked(1);
                        if (monitor.isCanceled()) break;
                        ++position;
                    }
                    fw.close();
                    ExportTraceDataWizard.this.client.setSelectedCodeFormat(old, false);
                }
                catch (TraceException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                monitor.done();
            }
        });
    }

    public void addPages() {
        Assert.isNotNull((Object)this.client);
        ExportSettings settings = new ExportSettings();
        IDialogSettings ds = TraceUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = ds.getSection(((Object)((Object)this)).getClass().getName());
        if (section != null) {
            settings.path = section.get(FILE_PATH);
            settings.format = section.getInt(FORMAT);
        }
        this.page = new ExportTraceDataPage(this.client, settings);
        this.addPage((IWizardPage)this.page);
    }
}

