/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.export;

import com.atmel.avr32.debug.trace.client.TraceClient;
import com.atmel.avr32.debug.trace.ui.internal.export.ExportSettings;
import com.atmel.avr32.debug.trace.ui.internal.export.Messages;
import java.io.File;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExportTraceDataPage
extends WizardPage {
    private TraceClient client;
    private Text filePathText;
    private Combo formatCombo;
    private Spinner toFrameText;
    private Spinner fromFrameText;
    private ExportSettings exportSettings;

    public ExportTraceDataPage(TraceClient client, ExportSettings settings) {
        super(Messages.ExportTraceDataPage_Title);
        this.setTitle(Messages.ExportTraceDataPage_Title);
        this.setDescription(Messages.ExportTraceDataPage_Description);
        this.client = client;
        this.exportSettings = settings;
        this.exportSettings.from = 0;
        this.exportSettings.to = client.getDataLength();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label fromFrameLabel = new Label(container, 0);
        fromFrameLabel.setText(Messages.ExportTraceDataPage_FromLabel);
        this.fromFrameText = new Spinner(container, 2048);
        this.fromFrameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fromFrameText.setMaximum(this.client.getDataLength());
        Label toFrameLabel = new Label(container, 0);
        toFrameLabel.setLayoutData((Object)new GridData());
        toFrameLabel.setText(Messages.ExportTraceDataPage_ToLabel);
        this.toFrameText = new Spinner(container, 2048);
        this.toFrameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.toFrameText.setMaximum(this.client.getDataLength());
        Label formatLabel = new Label(container, 0);
        formatLabel.setText(Messages.ExportTraceDataPage_FormatLabel);
        this.formatCombo = new Combo(container, 8);
        this.formatCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.formatCombo.add(Messages.ExportTraceDataPage_SourceOnly);
        this.formatCombo.add(Messages.ExportTraceDataPage_DisassemblyOnly);
        this.formatCombo.add(Messages.ExportTraceDataPage_Interleaved);
        this.formatCombo.add(Messages.ExportTraceDataPage_Raw);
        this.formatCombo.add(Messages.ExportTraceDataPage_Addresses);
        this.formatCombo.add(Messages.ExportTraceDataPage_SourceFromTo);
        Label exportFileLabel = new Label(container, 0);
        exportFileLabel.setText(Messages.ExportTraceDataPage_ExportPathLabel);
        this.filePathText = new Text(container, 2048);
        this.filePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filePathText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ExportTraceDataPage.this.setPageComplete(ExportTraceDataPage.this.isPageComplete());
            }
        });
        Button browseButton = new Button(container, 0);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                Shell shell = window.getShell();
                FileDialog fd = new FileDialog(shell, 8192);
                fd.setFilterPath(null);
                try {
                    File f = new File(ExportTraceDataPage.this.filePathText.getText());
                    if (f.getParentFile() != null && f.getParentFile().exists()) {
                        fd.setFilterPath(f.getParent());
                        ExportTraceDataPage.this.setErrorMessage(null);
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                if ((selection = fd.open()) != null) {
                    ExportTraceDataPage.this.filePathText.setText(selection);
                }
                ExportTraceDataPage.this.setPageComplete(ExportTraceDataPage.this.isPageComplete());
            }
        });
        browseButton.setLayoutData((Object)new GridData());
        browseButton.setText(Messages.ExportTraceDataPage_Browse);
        this.initDataBindings();
    }

    public boolean isPageComplete() {
        this.setMessage(null);
        File f = new File(this.filePathText.getText());
        if (f.getParentFile() == null || !f.getParentFile().exists()) {
            this.setErrorMessage(Messages.ExportTraceDataPage_IllegalPath);
            return false;
        }
        if (f.isDirectory()) {
            this.setErrorMessage(Messages.ExportTraceDataPage_MissingFile);
            return false;
        }
        if (this.fromFrameText.getSelection() >= this.toFrameText.getSelection()) {
            this.setErrorMessage(Messages.ExportTraceDataPage_LowNumber);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public ExportSettings getExportSettings() {
        return this.exportSettings;
    }

    protected DataBindingContext initDataBindings() {
        IObservableValue exportSettingsToObserveValue = BeansObservables.observeValue((Object)this.exportSettings, (String)"to");
        IObservableValue exportSettingsFromObserveValue = BeansObservables.observeValue((Object)this.exportSettings, (String)"from");
        ISWTObservableValue filePathTextTextObserveWidget = SWTObservables.observeText((Control)this.filePathText, (int)24);
        ISWTObservableValue formatComboSelectionIndexObserveWidget = SWTObservables.observeSingleSelectionIndex((Control)this.formatCombo);
        ISWTObservableValue toFrameTextSelectionObserveWidget = SWTObservables.observeSelection((Control)this.toFrameText);
        IObservableValue exportSettingsPathObserveValue = BeansObservables.observeValue((Object)this.exportSettings, (String)"path");
        ISWTObservableValue fromFrameTextSelectionObserveWidget = SWTObservables.observeSelection((Control)this.fromFrameText);
        IObservableValue exportSettingsFormatObserveValue = BeansObservables.observeValue((Object)this.exportSettings, (String)"format");
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)fromFrameTextSelectionObserveWidget, exportSettingsFromObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)toFrameTextSelectionObserveWidget, exportSettingsToObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)formatComboSelectionIndexObserveWidget, exportSettingsFormatObserveValue, null, null);
        bindingContext.bindValue((IObservableValue)filePathTextTextObserveWidget, exportSettingsPathObserveValue, null, null);
        return bindingContext;
    }
}

