/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.commands;

import com.atmel.avr32.debug.trace.AddressTracepoint;
import com.atmel.avr32.debug.trace.Tracepoint;
import com.atmel.avr32.debug.trace.ui.AbstractTracepointHandler;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class ToggleTracepointHandler
extends AbstractTracepointHandler
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        this.setTargetPart(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        Tracepoint wp = this.determineTracepoint();
        try {
            if (wp == null) {
                IVariable element = this.getModelElement(this.getOffset());
                if (element == null) {
                    if (this.getLine() != -1) {
                        this.createLineTracepoint(this.getResource(), this.getLine(), this.getColumn());
                    } else {
                        this.createAddressTracepoint(this.getResource(), this.getAddress());
                    }
                } else {
                    this.createTracepoint(this.getResource(), element);
                }
            } else {
                wp.delete();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void init(IWorkbenchWindow window) {
    }

    private void createLineTracepoint(IResource file, int line, int column) throws CoreException {
        final Tracepoint tracepoint = Tracepoint.createInstance((IResource)file, (int)line, (int)column, (boolean)true);
        if (tracepoint != null) {
            PropertyDialogAction action = new PropertyDialogAction((IShellProvider)this.getTargetPart().getSite(), new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)tracepoint);
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
            action.run();
        }
    }

    private void createTracepoint(IResource file, IVariable variable) throws CoreException {
        final Tracepoint tracepoint = Tracepoint.createInstance((IResource)file, (IVariable)variable, (boolean)true, (boolean)false);
        if (tracepoint != null) {
            PropertyDialogAction action = new PropertyDialogAction((IShellProvider)this.getTargetPart().getSite(), new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)tracepoint);
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
            action.run();
        }
    }

    private void createAddressTracepoint(IResource file, IAddress address) throws CoreException {
        final AddressTracepoint tracepoint = Tracepoint.createAddressTracepoint((IResource)file, (IAddress)address, (boolean)true, (boolean)false);
        if (tracepoint != null) {
            PropertyDialogAction action = new PropertyDialogAction((IShellProvider)this.getTargetPart().getSite(), new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)tracepoint);
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
            action.run();
        }
    }

    public void run(IAction action) {
        this.setTargetPart(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        Tracepoint wp = this.determineTracepoint();
        try {
            if (wp == null) {
                IVariable element = this.getModelElement(this.getOffset());
                if (element == null) {
                    if (this.getLine() != -1) {
                        this.createLineTracepoint(this.getResource(), this.getLine(), this.getColumn());
                    } else {
                        this.createAddressTracepoint(this.getResource(), this.getAddress());
                    }
                } else {
                    this.createTracepoint(this.getResource(), element);
                }
            } else {
                wp.delete();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
    }
}

