/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.commands;

import com.atmel.avr32.debug.trace.client.commands.TFCommand;
import com.atmel.avr32.debug.trace.ui.AbstractTraceHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class SetDataFormatTraceHandler
extends AbstractTraceHandler {
    private static final String DISASSEMBLY_FORMAT_ID = "com.atmel.avr32.debug.trace.format.disassembly";
    private static final String INTERLEAVED_FORMAT_ID = "com.atmel.avr32.debug.trace.format.mixed";
    private static final String SOURCE_FORMAT_ID = "com.atmel.avr32.debug.trace.format.source";

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        if (this.getTraceSession(executionEvent) == null) {
            return null;
        }
        TFCommand.Format format = TFCommand.Format.SOURCE;
        String id = executionEvent.getCommand().getId();
        if (id.equals(SOURCE_FORMAT_ID)) {
            format = TFCommand.Format.SOURCE;
        }
        if (id.equals(INTERLEAVED_FORMAT_ID)) {
            format = TFCommand.Format.INTERLEAVED;
        }
        if (id.equals(DISASSEMBLY_FORMAT_ID)) {
            format = TFCommand.Format.DIS_ASM;
        }
        this.getTraceSession(executionEvent).setSelectedCodeFormat(format, true);
        return null;
    }
}

