/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.actions;

import com.atmel.avr32.debug.trace.TracePlugin;
import com.atmel.avr32.debug.trace.Tracepoint;
import com.atmel.avr32.debug.trace.ui.internal.actions.AbstractTracepointAction;
import com.atmel.avr32.debug.trace.ui.internal.actions.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IWorkbenchPart;

public class DisableTracepointAction
extends AbstractTracepointAction {
    public DisableTracepointAction(IWorkbenchPart part, IVerticalRulerInfo rulerInfo) {
        super(part, rulerInfo);
    }

    public void update() {
        IResource resource = this.getResource();
        if (resource == null || !TracePlugin.supportsWatchpoints((IProject)resource.getProject())) {
            this.setText(Messages.DisableTracepointAction_Disable_Label);
            this.setEnabled(false);
            return;
        }
        Tracepoint wp = this.determineLineBreakpoint();
        try {
            if (wp != null) {
                this.setEnabled(true);
                if (wp.isEnabled()) {
                    this.setText(Messages.DisableTracepointAction_Disable_Label);
                } else {
                    this.setText(Messages.DisableTracepointAction_Enable_Label);
                }
            } else {
                this.setText(Messages.DisableTracepointAction_Disable_Label);
                this.setEnabled(false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        Tracepoint bp = this.determineLineBreakpoint();
        if (bp != null) {
            try {
                bp.setEnabled(!bp.isEnabled());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

