/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.actions;

import com.atmel.avr32.debug.trace.TracePlugin;
import com.atmel.avr32.debug.trace.Tracepoint;
import com.atmel.avr32.debug.trace.ui.internal.actions.AbstractTracepointAction;
import com.atmel.avr32.debug.trace.ui.internal.actions.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AddTracepointAction
extends AbstractTracepointAction {
    public AddTracepointAction(IWorkbenchPart part, IVerticalRulerInfo rulerInfo) {
        super(part, rulerInfo);
    }

    public void update() {
        Tracepoint watchpoint = this.determineLineBreakpoint();
        if (this.getResource() == null) {
            this.setText(Messages.AddTracepointAction_Label);
            this.setEnabled(false);
            return;
        }
        if (watchpoint != null || !TracePlugin.supportsWatchpoints((IProject)this.getResource().getProject())) {
            this.setText(Messages.AddTracepointAction_Label);
            this.setEnabled(false);
        } else {
            this.setText(Messages.AddTracepointAction_Label);
            this.setEnabled(true);
        }
    }

    public void run() {
        int pos = this.fRulerInfo.getLineOfLastMouseButtonActivity() + 1;
        int column = -1;
        IResource file = this.getResource();
        if (file == null) {
            return;
        }
        try {
            IDocumentProvider docProvider = this.fTextEditor.getDocumentProvider();
            IEditorInput input = this.fTextEditor.getEditorInput();
            if (docProvider == null || input == null) {
                return;
            }
            IDocument document = docProvider.getDocument((Object)input);
            if (document == null) {
                return;
            }
            column = document.getLineOffset(pos) - 1;
            final Tracepoint watchpoint = Tracepoint.createInstance((IResource)file, (int)pos, (int)column, (boolean)true);
            if (watchpoint != null) {
                PropertyDialogAction action = new PropertyDialogAction((IShellProvider)this.fTextEditor.getSite(), new ISelectionProvider(){

                    public void addSelectionChangedListener(ISelectionChangedListener listener) {
                    }

                    public ISelection getSelection() {
                        return new StructuredSelection((Object)watchpoint);
                    }

                    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                    }

                    public void setSelection(ISelection selection) {
                    }
                });
                action.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

