/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal.actions;

import com.atmel.avr32.debug.trace.Tracepoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractTracepointAction
extends Action
implements IUpdate {
    ITextEditor fTextEditor = null;
    IVerticalRulerInfo fRulerInfo = null;

    public AbstractTracepointAction(IWorkbenchPart part, IVerticalRulerInfo rulerInfo) {
        this.fTextEditor = (ITextEditor)part;
        this.fRulerInfo = rulerInfo;
    }

    protected Tracepoint determineLineBreakpoint() {
        int pos;
        block7: {
            if (this.fRulerInfo == null) {
                return null;
            }
            pos = this.fRulerInfo.getLineOfLastMouseButtonActivity() + 1;
            if (this.getResource() != null) break block7;
            return null;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.getResource().findMarkers("com.atmel.avr32.debug.trace.LineTracepointMarker", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                int line = (Integer)marker.getAttribute("lineNumber");
                if (line == pos) {
                    IBreakpoint bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
                    if (bp != null && bp instanceof Tracepoint) {
                        return (Tracepoint)bp;
                    }
                    marker.delete();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fRulerInfo = null;
    }
}

