/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.AddressTracepoint;
import com.atmel.avr32.debug.trace.LineTracepoint;
import com.atmel.avr32.debug.trace.Tracepoint;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class TracepointWorkingCopy
extends Tracepoint {
    private static final String ZERO = "0";
    private static final String COMMA = ",";
    private boolean dirty;
    private Tracepoint watchpoint;
    private Map workingAttributes;

    public TracepointWorkingCopy(Tracepoint wp) {
        try {
            this.dirty = false;
            this.workingAttributes = wp.getMarker().getAttributes();
            this.watchpoint = wp;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IResource getResource() {
        return this.watchpoint.getMarker().getResource();
    }

    public Tracepoint getWatchpoint() {
        return this.watchpoint;
    }

    public void apply() {
        try {
            if (this.dirty) {
                this.setAttributes(this.workingAttributes);
                this.setAttribute("message", this.getMarkerMessage());
                this.dirty = false;
            }
            this.watchpoint.setRegistered(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Tracepoint.Compare getComparison() {
        String value = this.getWorkingAttribute("tracepoint.comparison", Tracepoint.Compare.NO_COMPARISON.toString());
        return Tracepoint.Compare.valueOf((String)value);
    }

    public EnumSet<Tracepoint.Mask> getComparisonMask() {
        String values = this.getWorkingAttribute("tracepoint.comparison.mask", "");
        EnumSet<Tracepoint.Mask> mask = EnumSet.noneOf(Tracepoint.Mask.class);
        try {
            String[] stringArray = values.split(COMMA);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                mask.add(Tracepoint.Mask.valueOf((String)value));
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return mask;
    }

    public Tracepoint.Size getComparisonSize() {
        String value = this.getWorkingAttribute("tracepoint.comparison.size", Tracepoint.Size.DISREGARD.toString());
        return Tracepoint.Size.valueOf((String)value);
    }

    public String getComparisonValue() {
        return this.getWorkingAttribute("tracepoint.comparison.value", ZERO);
    }

    public String getEndLocation() {
        Assert.isTrue((boolean)(this.watchpoint instanceof LineTracepoint), (String)"End location can only be obtained from a LineTracepoint");
        return ((LineTracepoint)this.watchpoint).getEndLocation();
    }

    public Tracepoint.Event getEvent() {
        String value = this.getWorkingAttribute("tracepoint.event", Tracepoint.Event.PROGRAM_COUNTER.toString());
        return Tracepoint.Event.valueOf((String)value);
    }

    public Tracepoint.Location getLocationType() {
        String value = this.getWorkingAttribute("tracepoint.location.type", Tracepoint.Location.LOCATION.toString());
        return Tracepoint.Location.valueOf((String)value);
    }

    public IMarker getMarker() {
        return this.watchpoint.getMarker();
    }

    public Tracepoint.Operation getOperation() {
        String value = this.getWorkingAttribute("tracepoint.operation", Tracepoint.Operation.START.toString());
        return Tracepoint.Operation.valueOf((String)value);
    }

    public Tracepoint.Range getRangeType() {
        String value = this.getWorkingAttribute("tracepoint.location.range", Tracepoint.Range.INCLUSIVE.toString());
        return Tracepoint.Range.valueOf((String)value);
    }

    public String getStartLocation() {
        Assert.isTrue((boolean)(this.watchpoint instanceof LineTracepoint), (String)"Start location can only be obtained from a LineTracepoint");
        return ((LineTracepoint)this.watchpoint).getStartLocation();
    }

    public IAddress getStartAddress() {
        Assert.isTrue((boolean)(this.watchpoint instanceof AddressTracepoint), (String)"Start address can only be obtained from a AddressTracepoint");
        return new Addr32(this.getWorkingAttribute("tracepoint.start.address", ((AddressTracepoint)this.watchpoint).getStartAddress().toHexAddressString()));
    }

    public IAddress getEndAddress() {
        Assert.isTrue((boolean)(this.watchpoint instanceof AddressTracepoint), (String)"End address can only be obtained from a AddressTracepoint");
        return new Addr32(this.getWorkingAttribute("tracepoint.end.address", ((AddressTracepoint)this.watchpoint).getEndAddress().toHexAddressString()));
    }

    private boolean getWorkingAttribute(String key, boolean defaultValue) {
        Object value;
        Assert.isNotNull((Object)key);
        if (this.workingAttributes.containsKey(key) && (value = this.workingAttributes.get(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    private String getWorkingAttribute(String key, String defaultValue) {
        Assert.isNotNull((Object)key);
        if (this.workingAttributes.containsKey(key)) {
            Object value = this.workingAttributes.get(key);
            if (value instanceof String) {
                return (String)value;
            }
            return value.toString();
        }
        return defaultValue;
    }

    public boolean isDataTrace() {
        return this.getWorkingAttribute("tracepoint.data_trace", false);
    }

    public boolean isEnabled() {
        return this.getWorkingAttribute("org.eclipse.debug.core.enabled", false);
    }

    public boolean isProgramTrace() {
        return this.getWorkingAttribute("tracepoint.program_trace", true);
    }

    public void setComparison(Tracepoint.Compare compare) {
        this.setWorkingAttribute("tracepoint.comparison", compare.toString());
    }

    public void setComparisonMask(EnumSet<Tracepoint.Mask> mask) {
        StringBuffer values = new StringBuffer();
        for (Tracepoint.Mask value : mask) {
            if (values.length() > 0) {
                values.append(',');
            }
            values.append(value.toString());
        }
        this.setWorkingAttribute("tracepoint.comparison.mask", values.toString());
    }

    public void setComparisonSize(Tracepoint.Size size) {
        this.setWorkingAttribute("tracepoint.comparison.size", size.toString());
    }

    public void setComparisonValue(String value) {
        this.setWorkingAttribute("tracepoint.comparison.value", value);
    }

    public void setDataTrace(boolean dataTrace) {
        this.setWorkingAttribute("tracepoint.data_trace", dataTrace);
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.setWorkingAttribute("org.eclipse.debug.core.enabled", enabled);
        }
    }

    public void setEndAddress(IAddress address) {
        Assert.isTrue((boolean)(this.watchpoint instanceof AddressTracepoint));
        this.setWorkingAttribute("tracepoint.end.address", address.toHexAddressString());
    }

    public boolean isValidLocation(String location) {
        Pattern pattern = Pattern.compile("(([^:@]+)@)?([^,]+)(,(\\d+))?");
        Matcher matcher = pattern.matcher(location.trim());
        boolean matchFound = matcher.find();
        if (matchFound) {
            if (this.getEvent() != Tracepoint.Event.PROGRAM_COUNTER && matcher.group(2) == null) {
                return false;
            }
            if (this.getEvent() == Tracepoint.Event.PROGRAM_COUNTER && matcher.group(2) != null) {
                return false;
            }
            if (matcher.group(3) == null) {
                return false;
            }
            if (matcher.group(5) == null) {
                return false;
            }
            try {
                Integer.parseInt(matcher.group(5));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isValidAddress(String address) {
        Pattern pattern = Pattern.compile("(([^:@]+)@)?([^,]+)(,(\\d+))?");
        Matcher matcher = pattern.matcher(address.trim());
        return matcher.find();
    }

    public void setEndLocation(String location) {
        Assert.isTrue((boolean)(this.watchpoint instanceof LineTracepoint), (String)"End location can only be set on LineTracepoint");
        try {
            Pattern pattern = Pattern.compile("(([^:@]+)@)?([^,]+)(,(\\d+))?");
            Matcher matcher = pattern.matcher(location.trim());
            boolean matchFound = matcher.find();
            StringBuffer newLocation = new StringBuffer();
            String variable = "";
            if (matchFound) {
                if (matcher.group(2) != null) {
                    newLocation.append(matcher.group(2));
                    newLocation.append("@");
                }
                if (matcher.group(3) != null) {
                    newLocation.append(this.getMarker().getResource().getLocation().toOSString());
                    IPath existingPath = this.getMarker().getResource().getFullPath();
                    IPath newPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(matcher.group(3));
                    existingPath.equals((Object)newPath);
                }
                if (matcher.group(5) != null) {
                    newLocation.append(COMMA);
                    newLocation.append(matcher.group(5));
                }
                this.setWorkingAttribute("tracepoint.end.location", String.valueOf(variable) + newLocation.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEvent(Tracepoint.Event event) {
        this.setWorkingAttribute("tracepoint.event", event.toString());
    }

    public void setLocationType(Tracepoint.Location type) {
        this.setWorkingAttribute("tracepoint.location.type", type.toString());
    }

    public void setOperation(Tracepoint.Operation operation) {
        this.setWorkingAttribute("tracepoint.operation", operation.toString());
    }

    public void setProgramTrace(boolean programTrace) {
        this.setWorkingAttribute("tracepoint.program_trace", programTrace);
    }

    public void setRangeType(Tracepoint.Range range) {
        this.setWorkingAttribute("tracepoint.location.range", range.toString());
    }

    public void setStartAddress(IAddress address) {
        Assert.isTrue((boolean)(this.watchpoint instanceof AddressTracepoint));
        this.setWorkingAttribute("tracepoint.start.address", address.toHexAddressString());
    }

    public void setStartLocation(String location) throws IllegalArgumentException {
        Assert.isTrue((boolean)(this.watchpoint instanceof LineTracepoint));
        try {
            Pattern pattern = Pattern.compile("(([^:@]+)@)?([^,]+)(,(\\d+))?");
            Matcher matcher = pattern.matcher(location.trim());
            boolean matchFound = matcher.find();
            StringBuffer newLocation = new StringBuffer();
            if (matchFound) {
                if (matcher.group(2) != null) {
                    newLocation.append(matcher.group(2));
                    newLocation.append("@");
                }
                if (matcher.group(3) != null) {
                    newLocation.append(this.getMarker().getResource().getLocation().toOSString());
                    IPath existingPath = this.getMarker().getResource().getFullPath();
                    IPath newPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(matcher.group(3));
                    existingPath.equals((Object)newPath);
                }
                if (matcher.group(5) != null) {
                    this.setWorkingAttribute("lineNumber", new Integer(matcher.group(5)));
                    newLocation.append(COMMA);
                    newLocation.append(matcher.group(5));
                }
                this.setWorkingAttribute("tracepoint.start.location", newLocation.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setWorkingAttribute(String key, boolean value) {
        this.dirty = true;
        this.workingAttributes.put(key, new Boolean(value));
    }

    private void setWorkingAttribute(String key, Object value) {
        this.dirty = true;
        this.workingAttributes.put(key, value);
    }

    public String getMarkerMessage() {
        return this.watchpoint.getMarkerMessage();
    }

    public String getMarkerId() {
        return this.watchpoint.getMarkerId();
    }

    public String getText(boolean showFullPath) {
        return this.watchpoint.getText(showFullPath);
    }
}

