/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.AddressTracepoint;
import com.atmel.avr32.debug.trace.LineTracepoint;
import com.atmel.avr32.debug.trace.ui.TraceUIPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.BreakpointTypeCategory;
import org.eclipse.debug.ui.IBreakpointTypeCategory;

public class TracepointTypeAdapterFactory
implements IAdapterFactory {
    private Map<String, IBreakpointTypeCategory> fOtherTypes = new HashMap<String, IBreakpointTypeCategory>();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType.equals(IBreakpointTypeCategory.class) && adaptableObject instanceof IBreakpoint) {
            IBreakpoint breakpoint = (IBreakpoint)adaptableObject;
            String type = DebugPlugin.getDefault().getBreakpointManager().getTypeName(breakpoint);
            IBreakpointTypeCategory category = this.fOtherTypes.get(type);
            if (category == null) {
                if (breakpoint instanceof AddressTracepoint) {
                    category = new BreakpointTypeCategory(type, TraceUIPlugin.getDefault().getImageRegistry().getDescriptor("IMAGE_TRACEPOINT_GROUP"));
                } else if (breakpoint instanceof LineTracepoint) {
                    category = new BreakpointTypeCategory(type, TraceUIPlugin.getDefault().getImageRegistry().getDescriptor("IMAGE_TRACEPOINT_GROUP"));
                }
                if (category != null) {
                    this.fOtherTypes.put(type, category);
                }
            }
            return category;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IBreakpointTypeCategory.class};
    }
}

