/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.AddressTracepoint;
import com.atmel.avr32.debug.trace.LineTracepoint;
import com.atmel.avr32.debug.trace.Tracepoint;
import com.atmel.avr32.debug.trace.ui.internal.CModelContentProvider;
import com.atmel.avr32.debug.trace.ui.internal.Messages;
import com.atmel.avr32.debug.trace.ui.internal.TracepointPropertyPage;
import com.atmel.avr32.debug.trace.ui.internal.TracepointWorkingCopy;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.part.model.DebugSystem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.ui.cview.CViewLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class TracepointPropertiesComposite
extends Composite
implements ModifyListener,
SelectionListener {
    private static final String EMPTY_STRING = "";
    private Button addressRadio = null;
    private Button boundariesButton = null;
    private Button browseStartLocationButton = null;
    private Button browseStopLocationButton = null;
    private Group compareGroup = null;
    private Composite composite = null;
    private Group conditionGroup = null;
    private Button dataAccessRadioButton = null;
    private Button dataReadRadioButton = null;
    private Button dataTraceCheckBox = null;
    private Button dataWriteRadioButton = null;
    private boolean doRefresh = false;
    private Button enabledCheckBox = null;
    private Text endLocationText = null;
    private Group group2 = null;
    private Label locationLabel1 = null;
    private Label locationLabel2 = null;
    private Group locationGroup1 = null;
    private Group locationGroup2 = null;
    private Button messageRadio = null;
    private Button noValueRadioButton = null;
    private Group operationGroup = null;
    private TracepointPropertyPage page;
    private Button pcRadioButton = null;
    private Button programTraceCheckBox = null;
    private Combo rangeCombo = null;
    private Button rangeRadio = null;
    private Text startLocationText = null;
    private Button startRadio = null;
    private Button stopRadio = null;
    private Group typeGroup = null;
    private Combo valueCompareCombo = null;
    private Button valueCompareRadioButton = null;
    private Text valueCompareText = null;
    private Button valueMask_0 = null;
    private Button valueMask_1 = null;
    private Button valueMask_2 = null;
    private Button valueMask_3 = null;
    private Composite valueMaskBytesGroup = null;
    private Button valueMaskRadioButton = null;
    private TracepointWorkingCopy watchpoint;

    public TracepointPropertiesComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private ICElement browseForICEElement() {
        CModelContentProvider provider = new CModelContentProvider(this.pcRadioButton.getSelection());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)this.createLabelProvider(), (ITreeContentProvider)provider);
        dialog.setTitle(Messages.WatchpointPropertiesComposite_1);
        dialog.setMessage(Messages.WatchpointPropertiesComposite_2);
        dialog.setInput((Object)this.watchpoint.getMarker().getResource());
        if (dialog.open() == 0) {
            return (ICElement)dialog.getFirstResult();
        }
        return null;
    }

    private int countProgramModulesUsed(TracepointWorkingCopy tracepoint) throws CoreException {
        Tracepoint[] watchpoints;
        int count = 0;
        Tracepoint[] tracepointArray = watchpoints = this.getTracepoints(tracepoint.getMarker().getResource().getProject());
        int n = watchpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Tracepoint watchpoint2 = tracepointArray[n2];
            if (!tracepoint.getWatchpoint().equals((Object)watchpoint2) && watchpoint2.isEnabled() && Tracepoint.Event.PROGRAM_COUNTER.equals((Object)watchpoint2.getEvent())) {
                ++count;
            }
            ++n2;
        }
        if (tracepoint.isEnabled() && tracepoint.getEvent().equals((Object)Tracepoint.Event.PROGRAM_COUNTER)) {
            ++count;
        }
        return count;
    }

    private int countDataModulesUsed(TracepointWorkingCopy tracepoint) throws CoreException {
        Tracepoint[] watchpoints;
        int count = 0;
        Tracepoint[] tracepointArray = watchpoints = this.getTracepoints(tracepoint.getMarker().getResource().getProject());
        int n = watchpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Tracepoint watchpoint2 = tracepointArray[n2];
            if (!tracepoint.getWatchpoint().equals((Object)watchpoint2) && watchpoint2.isEnabled() && !Tracepoint.Event.PROGRAM_COUNTER.equals((Object)watchpoint2.getEvent())) {
                ++count;
            }
            ++n2;
        }
        if (tracepoint.isEnabled() && !tracepoint.getEvent().equals((Object)Tracepoint.Event.PROGRAM_COUNTER)) {
            ++count;
        }
        return count;
    }

    private void createCompareGroup() {
        GridData gridData27 = new GridData();
        gridData27.horizontalSpan = 3;
        GridData gridData25 = new GridData();
        gridData25.grabExcessHorizontalSpace = true;
        gridData25.widthHint = 40;
        gridData25.horizontalAlignment = 4;
        GridLayout gridLayout9 = new GridLayout();
        gridLayout9.numColumns = 3;
        GridData gridData24 = new GridData();
        gridData24.grabExcessHorizontalSpace = true;
        gridData24.horizontalAlignment = 4;
        this.compareGroup = new Group(this.composite, 0);
        this.compareGroup.setLayoutData((Object)gridData24);
        this.compareGroup.setLayout((Layout)gridLayout9);
        this.compareGroup.setText(Messages.WatchpointPropertiesComposite_3);
        this.noValueRadioButton = new Button((Composite)this.compareGroup, 16);
        this.noValueRadioButton.setText(Messages.WatchpointPropertiesComposite_4);
        this.noValueRadioButton.setLayoutData((Object)gridData27);
        this.noValueRadioButton.addSelectionListener((SelectionListener)this);
        this.noValueRadioButton.setToolTipText(Messages.TracepointPropertiesComposite_0);
        this.valueMaskRadioButton = new Button((Composite)this.compareGroup, 16);
        this.valueMaskRadioButton.setText(Messages.WatchpointPropertiesComposite_5);
        this.valueMaskRadioButton.addSelectionListener((SelectionListener)this);
        this.createValueMaskBytesGroup();
        this.valueCompareRadioButton = new Button((Composite)this.compareGroup, 16);
        this.valueCompareRadioButton.setText(Messages.WatchpointPropertiesComposite_6);
        this.valueCompareRadioButton.addSelectionListener((SelectionListener)this);
        this.valueCompareText = new Text((Composite)this.compareGroup, 2048);
        this.valueCompareText.setLayoutData((Object)gridData25);
        this.valueCompareText.addModifyListener((ModifyListener)this);
        this.createValueCompareCombo();
    }

    private void createComposite() {
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.heightHint = 430;
        gridData2.widthHint = 460;
        gridData2.grabExcessVerticalSpace = true;
        GridData gridData10 = new GridData();
        gridData10.horizontalSpan = 2;
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 2;
        this.composite = new Composite((Composite)this, 0);
        this.enabledCheckBox = new Button(this.composite, 32);
        this.enabledCheckBox.setText(Messages.WatchpointPropertiesComposite_7);
        this.enabledCheckBox.setLayoutData((Object)gridData10);
        this.enabledCheckBox.addSelectionListener((SelectionListener)this);
        this.createTypeGroup();
        this.composite.setLayoutData((Object)gridData2);
        this.composite.setLayout((Layout)gridLayout3);
        this.createConditionGroup();
        this.createCompareGroup();
        this.createTraceTypeGroup();
        this.createOperationGroup();
        this.createLocationGroup1();
        this.createLocationGroup2();
    }

    private void createConditionGroup() {
        GridData gridData34 = new GridData();
        gridData34.horizontalAlignment = 4;
        GridData gridData12 = new GridData();
        gridData12.horizontalAlignment = 4;
        gridData12.verticalAlignment = 4;
        GridData gridData1 = new GridData();
        GridLayout gridLayout6 = new GridLayout();
        gridLayout6.numColumns = 2;
        GridData conditionGroupGD = new GridData();
        conditionGroupGD.grabExcessHorizontalSpace = true;
        conditionGroupGD.verticalAlignment = 4;
        conditionGroupGD.grabExcessVerticalSpace = false;
        conditionGroupGD.horizontalIndent = 0;
        conditionGroupGD.horizontalAlignment = 4;
        this.conditionGroup = new Group(this.composite, 0);
        this.conditionGroup.setText(Messages.WatchpointPropertiesComposite_8);
        this.conditionGroup.setLayoutData((Object)gridData34);
        this.conditionGroup.setLayoutData((Object)gridData12);
        this.conditionGroup.setLayout((Layout)gridLayout6);
        this.conditionGroup.setLayoutData((Object)conditionGroupGD);
        this.addressRadio = new Button((Composite)this.conditionGroup, 16);
        this.addressRadio.setText(Messages.WatchpointPropertiesComposite_9);
        this.addressRadio.setToolTipText(Messages.TracepointPropertiesComposite_6);
        this.addressRadio.setLayoutData((Object)gridData1);
        this.addressRadio.addSelectionListener((SelectionListener)this);
        new Label((Composite)this.conditionGroup, 0);
        this.createLocationMaskComposite();
        this.rangeRadio = new Button((Composite)this.conditionGroup, 16);
        this.rangeRadio.setText(Messages.WatchpointPropertiesComposite_10);
        this.rangeRadio.addSelectionListener((SelectionListener)this);
        this.rangeRadio.setToolTipText(Messages.TracepointPropertiesComposite_7);
        this.createRangeCombo();
    }

    private void createTraceTypeGroup() {
        GridLayout gridLayout10 = new GridLayout();
        gridLayout10.numColumns = 1;
        GridData gridData22 = new GridData();
        gridData22.grabExcessHorizontalSpace = true;
        gridData22.verticalAlignment = 1;
        gridData22.horizontalAlignment = 4;
        this.group2 = new Group(this.composite, 0);
        this.group2.setLayout((Layout)gridLayout10);
        this.group2.setLayoutData((Object)gridData22);
        this.group2.setText(Messages.WatchpointPropertiesComposite_11);
        this.programTraceCheckBox = new Button((Composite)this.group2, 32);
        this.programTraceCheckBox.setText(Messages.WatchpointPropertiesComposite_13);
        this.programTraceCheckBox.addSelectionListener((SelectionListener)this);
        this.programTraceCheckBox.setToolTipText(Messages.TracepointPropertiesComposite_1);
        this.dataTraceCheckBox = new Button((Composite)this.group2, 32);
        this.dataTraceCheckBox.setText(Messages.WatchpointPropertiesComposite_14);
        this.dataTraceCheckBox.addSelectionListener((SelectionListener)this);
        this.dataTraceCheckBox.setToolTipText(Messages.TracepointPropertiesComposite_2);
        this.boundariesButton = new Button((Composite)this.group2, 0);
        this.boundariesButton.setToolTipText(Messages.WatchpointPropertiesComposite_15);
        this.boundariesButton.setText(Messages.WatchpointPropertiesComposite_16);
        this.boundariesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(Messages.WatchpointPropertiesComposite_17);
                boolean found = false;
                try {
                    ILaunchConfiguration[] launches;
                    ILaunchConfiguration[] iLaunchConfigurationArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
                        if (launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", TracepointPropertiesComposite.EMPTY_STRING).equals(TracepointPropertiesComposite.this.watchpoint.getResource().getProject().getName())) {
                            found = true;
                            StructuredSelection selection = new StructuredSelection((Object)launchConfiguration);
                            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)TracepointPropertiesComposite.this.getShell(), (IStructuredSelection)selection, (String)"org.eclipse.debug.ui.launchGroup.debug");
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                if (!found) {
                    TracepointPropertiesComposite.this.page.setMessage(Messages.TracepointPropertiesComposite_NoLaunchConfig, 2);
                }
            }
        });
    }

    protected CUILabelProvider createLabelProvider() {
        return new CViewLabelProvider(0x40000001, 3);
    }

    private void createLocationGroup1() {
        GridData gridData32 = new GridData();
        gridData32.horizontalSpan = 2;
        gridData32.horizontalAlignment = 4;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.horizontalSpan = 2;
        GridData locationGroup1GD = new GridData();
        locationGroup1GD.horizontalSpan = 2;
        locationGroup1GD.horizontalAlignment = 4;
        locationGroup1GD.verticalAlignment = 1;
        locationGroup1GD.grabExcessHorizontalSpace = true;
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.horizontalSpan = 2;
        gridData5.verticalAlignment = 4;
        GridData gridData4 = new GridData();
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalAlignment = 4;
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.numColumns = 3;
        this.locationGroup1 = new Group(this.composite, 0);
        this.locationGroup1.setText(Messages.WatchpointPropertiesComposite_18);
        this.locationGroup1.setLayoutData((Object)gridData32);
        this.locationGroup1.setLayoutData((Object)gridData3);
        this.locationGroup1.setLayoutData((Object)locationGroup1GD);
        this.locationGroup1.setLayoutData((Object)gridData5);
        this.locationGroup1.setLayout((Layout)gridLayout4);
        this.locationLabel1 = new Label((Composite)this.locationGroup1, 0);
        this.locationLabel1.setText(Messages.WatchpointPropertiesComposite_19);
        this.startLocationText = new Text((Composite)this.locationGroup1, 2048);
        this.startLocationText.setLayoutData((Object)gridData4);
        this.startLocationText.addModifyListener((ModifyListener)this);
        this.browseStartLocationButton = new Button((Composite)this.locationGroup1, 0);
        this.browseStartLocationButton.setText(Messages.WatchpointPropertiesComposite_20);
        this.browseStartLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ICElement selected = TracepointPropertiesComposite.this.browseForICEElement();
                    if (selected instanceof SourceManipulation) {
                        int start = ((SourceManipulation)selected).getSourceRange().getStartLine();
                        if (selected instanceof IVariable) {
                            TracepointPropertiesComposite.this.startLocationText.setText(String.valueOf(selected.getElementName()) + "@" + selected.getPath().toOSString() + "," + start);
                        } else {
                            TracepointPropertiesComposite.this.startLocationText.setText(String.valueOf(selected.getPath().toOSString()) + "," + start);
                        }
                    }
                }
                catch (CModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void createLocationGroup2() {
        GridData gridData33 = new GridData();
        gridData33.horizontalSpan = 2;
        gridData33.horizontalAlignment = 4;
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 4;
        gridData7.horizontalSpan = 2;
        GridData gridData8 = new GridData();
        gridData8.horizontalAlignment = 4;
        gridData8.grabExcessHorizontalSpace = true;
        GridData locationGroup2GD = new GridData();
        locationGroup2GD.horizontalSpan = 2;
        locationGroup2GD.horizontalAlignment = 4;
        locationGroup2GD.verticalAlignment = 1;
        locationGroup2GD.grabExcessHorizontalSpace = true;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        this.locationGroup2 = new Group(this.composite, 0);
        this.locationGroup2.setText(Messages.WatchpointPropertiesComposite_22);
        this.locationGroup2.setLayoutData((Object)gridData33);
        this.locationGroup2.setLayoutData((Object)gridData7);
        this.locationGroup2.setLayout((Layout)gridLayout1);
        this.locationGroup2.setLayoutData((Object)locationGroup2GD);
        this.locationLabel2 = new Label((Composite)this.locationGroup2, 0);
        this.locationLabel2.setText(Messages.WatchpointPropertiesComposite_23);
        this.endLocationText = new Text((Composite)this.locationGroup2, 2048);
        this.endLocationText.setLayoutData((Object)gridData8);
        this.endLocationText.addModifyListener((ModifyListener)this);
        this.browseStopLocationButton = new Button((Composite)this.locationGroup2, 0);
        this.browseStopLocationButton.setText(Messages.WatchpointPropertiesComposite_24);
        this.browseStopLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ICElement selected = TracepointPropertiesComposite.this.browseForICEElement();
                    if (selected instanceof SourceManipulation) {
                        int start = ((SourceManipulation)selected).getSourceRange().getStartLine();
                        if (selected instanceof IVariable) {
                            TracepointPropertiesComposite.this.endLocationText.setText(String.valueOf(selected.getElementName()) + "@" + selected.getPath().toOSString() + "," + start);
                        } else {
                            TracepointPropertiesComposite.this.endLocationText.setText(String.valueOf(selected.getPath().toOSString()) + "," + start);
                        }
                    }
                }
                catch (CModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void createLocationMaskComposite() {
    }

    private void createOperationGroup() {
        GridData gridData30 = new GridData();
        gridData30.horizontalAlignment = 4;
        GridData gridData21 = new GridData();
        gridData21.grabExcessHorizontalSpace = true;
        gridData21.verticalAlignment = 4;
        gridData21.horizontalAlignment = 4;
        GridLayout gridLayout8 = new GridLayout();
        gridLayout8.numColumns = 1;
        this.operationGroup = new Group(this.composite, 0);
        this.operationGroup.setText(Messages.WatchpointPropertiesComposite_31);
        this.operationGroup.setLayoutData((Object)gridData30);
        this.operationGroup.setLayoutData((Object)gridData21);
        this.operationGroup.setLayout((Layout)gridLayout8);
        this.messageRadio = new Button((Composite)this.operationGroup, 16);
        this.messageRadio.setText(Messages.WatchpointPropertiesComposite_32);
        this.messageRadio.addSelectionListener((SelectionListener)this);
        this.messageRadio.setToolTipText(Messages.TracepointPropertiesComposite_3);
        this.startRadio = new Button((Composite)this.operationGroup, 16);
        this.startRadio.setText(Messages.WatchpointPropertiesComposite_33);
        this.startRadio.addSelectionListener((SelectionListener)this);
        this.startRadio.setToolTipText(Messages.TracepointPropertiesComposite_4);
        this.stopRadio = new Button((Composite)this.operationGroup, 16);
        this.stopRadio.setText(Messages.WatchpointPropertiesComposite_34);
        this.stopRadio.addSelectionListener((SelectionListener)this);
        this.stopRadio.setToolTipText(Messages.TracepointPropertiesComposite_5);
    }

    private void createRangeCombo() {
        GridData gridData23 = new GridData(4, 0x1000000, true, false);
        this.rangeCombo = new Combo((Composite)this.conditionGroup, 8);
        this.rangeCombo.add(Messages.WatchpointPropertiesComposite_35);
        this.rangeCombo.add(Messages.WatchpointPropertiesComposite_36);
        this.rangeCombo.setText(Messages.WatchpointPropertiesComposite_37);
        this.rangeCombo.setLayoutData((Object)gridData23);
        this.rangeCombo.addSelectionListener((SelectionListener)this);
    }

    private void createTypeGroup() {
        GridData gridData31 = new GridData();
        gridData31.horizontalAlignment = 4;
        gridData31.verticalAlignment = 4;
        gridData31.verticalSpan = 2;
        GridData gridData9 = new GridData();
        gridData9.horizontalAlignment = 4;
        gridData9.grabExcessHorizontalSpace = true;
        gridData9.grabExcessVerticalSpace = false;
        gridData9.verticalSpan = 2;
        gridData9.verticalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.typeGroup = new Group(this.composite, 0);
        this.typeGroup.setText(Messages.WatchpointPropertiesComposite_38);
        this.typeGroup.setLayoutData((Object)gridData31);
        this.typeGroup.setLayoutData((Object)gridData9);
        this.typeGroup.setLayout((Layout)gridLayout);
        this.pcRadioButton = new Button((Composite)this.typeGroup, 16);
        this.pcRadioButton.setText(Messages.WatchpointPropertiesComposite_39);
        this.pcRadioButton.setToolTipText(Messages.WatchpointPropertiesComposite_40);
        this.pcRadioButton.addSelectionListener((SelectionListener)this);
        this.dataReadRadioButton = new Button((Composite)this.typeGroup, 16);
        this.dataReadRadioButton.setText(Messages.WatchpointPropertiesComposite_41);
        this.dataReadRadioButton.setToolTipText(Messages.WatchpointPropertiesComposite_42);
        this.dataReadRadioButton.addSelectionListener((SelectionListener)this);
        this.dataWriteRadioButton = new Button((Composite)this.typeGroup, 16);
        this.dataWriteRadioButton.setText(Messages.WatchpointPropertiesComposite_43);
        this.dataWriteRadioButton.setToolTipText(Messages.WatchpointPropertiesComposite_44);
        this.dataWriteRadioButton.addSelectionListener((SelectionListener)this);
        this.dataAccessRadioButton = new Button((Composite)this.typeGroup, 16);
        this.dataAccessRadioButton.setText(Messages.WatchpointPropertiesComposite_45);
        this.dataAccessRadioButton.setToolTipText(Messages.WatchpointPropertiesComposite_46);
        this.dataAccessRadioButton.addSelectionListener((SelectionListener)this);
    }

    private void createValueCompareCombo() {
        GridData gridData28 = new GridData();
        this.valueCompareCombo = new Combo((Composite)this.compareGroup, 8);
        this.valueCompareCombo.setText(Messages.WatchpointPropertiesComposite_47);
        this.valueCompareCombo.setLayoutData((Object)gridData28);
        this.valueCompareCombo.add(Messages.WatchpointPropertiesComposite_48);
        this.valueCompareCombo.add(Messages.WatchpointPropertiesComposite_49);
        this.valueCompareCombo.add(Messages.WatchpointPropertiesComposite_50);
        this.valueCompareCombo.add(Messages.WatchpointPropertiesComposite_51);
        this.valueCompareCombo.add(Messages.WatchpointPropertiesComposite_52);
        this.valueCompareCombo.addSelectionListener((SelectionListener)this);
    }

    private void createValueMaskBytesGroup() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginBottom = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginLeft = 0;
        GridData gridData26 = new GridData();
        gridData26.horizontalAlignment = 4;
        gridData26.horizontalSpan = 2;
        this.valueMaskBytesGroup = new Composite((Composite)this.compareGroup, 0);
        this.valueMaskBytesGroup.setLayoutData((Object)gridData26);
        this.valueMaskBytesGroup.setLayout((Layout)rowLayout);
        this.valueMask_3 = new Button(this.valueMaskBytesGroup, 32);
        this.valueMask_3.setToolTipText(Messages.WatchpointPropertiesComposite_53);
        this.valueMask_3.addSelectionListener((SelectionListener)this);
        this.valueMask_2 = new Button(this.valueMaskBytesGroup, 32);
        this.valueMask_2.setToolTipText(Messages.WatchpointPropertiesComposite_54);
        this.valueMask_2.addSelectionListener((SelectionListener)this);
        this.valueMask_1 = new Button(this.valueMaskBytesGroup, 32);
        this.valueMask_1.setToolTipText(Messages.WatchpointPropertiesComposite_55);
        this.valueMask_1.addSelectionListener((SelectionListener)this);
        this.valueMask_0 = new Button(this.valueMaskBytesGroup, 32);
        this.valueMask_0.setToolTipText(Messages.WatchpointPropertiesComposite_56);
        this.valueMask_0.addSelectionListener((SelectionListener)this);
    }

    private void initialize() {
        this.createComposite();
        this.setSize(new Point(460, 430));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        this.setLayout((Layout)gridLayout2);
        this.setSize(new Point(413, 494));
        this.setSize(new Point(543, 256));
    }

    public void modifyText(ModifyEvent e) {
        if (!this.doRefresh) {
            return;
        }
        this.validate();
        if (this.watchpoint.getWatchpoint() instanceof LineTracepoint) {
            if (e.widget.equals(this.startLocationText)) {
                this.watchpoint.setStartLocation(this.startLocationText.getText());
            }
            if (e.widget.equals(this.endLocationText)) {
                this.watchpoint.setEndLocation(this.endLocationText.getText());
            }
        }
        if (this.watchpoint.getWatchpoint() instanceof AddressTracepoint) {
            try {
                if (e.widget.equals(this.startLocationText)) {
                    this.watchpoint.setStartAddress((IAddress)new Addr32(this.startLocationText.getText()));
                }
                if (e.widget.equals(this.endLocationText)) {
                    this.watchpoint.setEndAddress((IAddress)new Addr32(this.endLocationText.getText()));
                }
            }
            catch (Exception exception) {}
        }
        if (e.widget.equals(this.valueCompareText)) {
            this.watchpoint.setComparisonValue(this.valueCompareText.getText());
        }
    }

    private void setEnabled(Composite group, boolean enabled) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
        group.setEnabled(enabled);
    }

    protected void setPage(TracepointPropertyPage page) {
        this.page = page;
    }

    protected void setTracepoint(TracepointWorkingCopy watchpoint) {
        this.watchpoint = watchpoint;
        this.updateWidgets();
    }

    private synchronized void updateEnabledState() {
        if (this.watchpoint.isDataTrace()) {
            this.boundariesButton.setEnabled(true);
        } else {
            this.boundariesButton.setEnabled(false);
        }
        if (this.watchpoint.getEvent().equals((Object)Tracepoint.Event.PROGRAM_COUNTER)) {
            this.setEnabled((Composite)this.compareGroup, false);
            this.setEnabled((Composite)this.locationGroup2, false);
            this.rangeRadio.setEnabled(false);
            this.rangeCombo.setEnabled(false);
            if (this.watchpoint.getWatchpoint() instanceof AddressTracepoint) {
                this.browseStartLocationButton.setEnabled(false);
            }
        } else {
            this.rangeRadio.setEnabled(true);
            if (this.watchpoint.getComparison().equals((Object)Tracepoint.Compare.EQUALITY)) {
                this.valueCompareText.setEnabled(true);
                this.valueCompareCombo.setEnabled(true);
            } else {
                this.valueCompareText.setEnabled(false);
                this.valueCompareCombo.setEnabled(false);
            }
            if (this.watchpoint.getLocationType().equals((Object)Tracepoint.Location.RANGE)) {
                this.setEnabled((Composite)this.locationGroup2, true);
                this.rangeCombo.setEnabled(true);
                this.setEnabled((Composite)this.compareGroup, false);
                if (this.watchpoint.getWatchpoint() instanceof AddressTracepoint) {
                    this.browseStopLocationButton.setEnabled(false);
                }
            } else {
                this.setEnabled((Composite)this.locationGroup2, false);
                this.rangeCombo.setEnabled(false);
                this.setEnabled((Composite)this.compareGroup, true);
            }
            if (this.watchpoint.getComparison().equals((Object)Tracepoint.Compare.MASK_BYTES)) {
                this.setEnabled(this.valueMaskBytesGroup, true);
            } else {
                this.setEnabled(this.valueMaskBytesGroup, false);
            }
        }
        if (this.watchpoint.isDataTrace() || this.watchpoint.isProgramTrace()) {
            this.setEnabled((Composite)this.operationGroup, true);
        } else {
            this.setEnabled((Composite)this.operationGroup, false);
        }
        this.validate();
    }

    private void updateWidgets() {
        this.doRefresh = false;
        this.valueCompareText.setText(this.watchpoint.getComparisonValue());
        if (this.watchpoint.getWatchpoint() instanceof LineTracepoint) {
            this.locationLabel1.setText(Messages.TracepointPropertiesComposite_FileLocationLabel);
            this.locationLabel2.setText(Messages.TracepointPropertiesComposite_FileLocationLabel);
            this.startLocationText.setText(this.watchpoint.getStartLocation());
            this.endLocationText.setText(this.watchpoint.getEndLocation());
        }
        if (this.watchpoint.getWatchpoint() instanceof AddressTracepoint) {
            this.locationLabel1.setText(Messages.TracepointPropertiesComposite_AddressLocationLabel);
            this.locationLabel2.setText(Messages.TracepointPropertiesComposite_AddressLocationLabel);
            this.startLocationText.setText(this.watchpoint.getStartAddress().toHexAddressString());
            this.endLocationText.setText(this.watchpoint.getEndAddress().toHexAddressString());
        }
        this.enabledCheckBox.setSelection(this.watchpoint.isEnabled());
        this.programTraceCheckBox.setSelection(this.watchpoint.isProgramTrace());
        this.dataTraceCheckBox.setSelection(this.watchpoint.isDataTrace());
        switch (this.watchpoint.getOperation()) {
            case MESSAGE: {
                this.messageRadio.setSelection(true);
                break;
            }
            case START: {
                this.startRadio.setSelection(true);
                break;
            }
            case STOP: {
                this.stopRadio.setSelection(true);
                break;
            }
        }
        switch (this.watchpoint.getEvent()) {
            case DATA_ACCESS: {
                this.dataAccessRadioButton.setSelection(true);
                break;
            }
            case DATA_WRITE: {
                this.dataWriteRadioButton.setSelection(true);
                break;
            }
            case DATA_READ: {
                this.dataReadRadioButton.setSelection(true);
                break;
            }
            case PROGRAM_COUNTER: {
                this.pcRadioButton.setSelection(true);
                break;
            }
        }
        switch (this.watchpoint.getComparison()) {
            case EQUALITY: {
                this.valueCompareRadioButton.setSelection(true);
                break;
            }
            case MASK_BYTES: {
                this.valueMaskRadioButton.setSelection(true);
                break;
            }
            case NO_COMPARISON: {
                this.noValueRadioButton.setSelection(true);
                break;
            }
        }
        switch (this.watchpoint.getComparisonSize()) {
            case DISREGARD: {
                this.valueCompareCombo.select(0);
                break;
            }
            case BYTE: {
                this.valueCompareCombo.select(1);
                break;
            }
            case HALFWORD: {
                this.valueCompareCombo.select(2);
                break;
            }
            case WORD: {
                this.valueCompareCombo.select(3);
                break;
            }
            case DOUBLEWORD: {
                this.valueCompareCombo.select(4);
                break;
            }
        }
        switch (this.watchpoint.getRangeType()) {
            case EXCLUSIVE: {
                this.rangeCombo.select(0);
                break;
            }
            case INCLUSIVE: {
                this.rangeCombo.select(1);
                break;
            }
        }
        switch (this.watchpoint.getLocationType()) {
            case LOCATION: {
                this.addressRadio.setSelection(true);
                break;
            }
            case RANGE: {
                this.rangeRadio.setSelection(true);
                break;
            }
        }
        this.valueMask_0.setSelection(false);
        this.valueMask_1.setSelection(false);
        this.valueMask_2.setSelection(false);
        this.valueMask_3.setSelection(false);
        for (Tracepoint.Mask mask : this.watchpoint.getComparisonMask()) {
            switch (mask) {
                case MASK_31_24: {
                    this.valueMask_3.setSelection(true);
                    break;
                }
                case MASK_23_16: {
                    this.valueMask_2.setSelection(true);
                    break;
                }
                case MASK_15_8: {
                    this.valueMask_1.setSelection(true);
                    break;
                }
                case MASK_7_0: {
                    this.valueMask_0.setSelection(true);
                }
            }
        }
        this.updateEnabledState();
        this.doRefresh = true;
    }

    private void validate() {
        IStatus status;
        try {
            Long.decode(this.valueCompareText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.page.setErrorMessage(Messages.TracepointPropertiesComposite_14);
            this.page.setValid(false);
            return;
        }
        if (this.watchpoint.getLocationType().equals((Object)Tracepoint.Location.RANGE) && this.watchpoint.getEvent().equals((Object)Tracepoint.Event.PROGRAM_COUNTER)) {
            this.page.setErrorMessage(Messages.WatchpointPropertiesComposite_57);
            this.page.setValid(false);
            return;
        }
        if (!this.watchpoint.isDataTrace() && !this.watchpoint.isProgramTrace()) {
            this.page.setErrorMessage(Messages.WatchpointPropertiesComposite_58);
            this.page.setValid(false);
            return;
        }
        if (this.watchpoint.getWatchpoint() instanceof LineTracepoint) {
            if (!this.watchpoint.isValidLocation(this.startLocationText.getText())) {
                if (this.watchpoint.getEvent() == Tracepoint.Event.PROGRAM_COUNTER) {
                    this.page.setMessage(Messages.TracepointPropertiesComposite_8, 3);
                } else {
                    this.page.setMessage(Messages.TracepointPropertiesComposite_12, 3);
                }
                this.page.setValid(false);
                return;
            }
            if (this.endLocationText.isEnabled() && !this.watchpoint.isValidLocation(this.endLocationText.getText())) {
                if (this.watchpoint.getEvent() == Tracepoint.Event.PROGRAM_COUNTER) {
                    this.page.setMessage(Messages.TracepointPropertiesComposite_9, 3);
                } else {
                    this.page.setMessage(Messages.TracepointPropertiesComposite_13, 3);
                }
                this.page.setValid(false);
                return;
            }
        }
        if (this.watchpoint.getWatchpoint() instanceof AddressTracepoint) {
            if (!this.watchpoint.isValidAddress(this.startLocationText.getText())) {
                this.page.setMessage(Messages.TracepointPropertiesComposite_10, 3);
                this.page.setValid(false);
                return;
            }
            if (this.endLocationText.isEnabled() && !this.watchpoint.isValidAddress(this.endLocationText.getText())) {
                this.page.setMessage(Messages.TracepointPropertiesComposite_11, 3);
                this.page.setValid(false);
                return;
            }
        }
        if (!(status = this.validateTracepoint(this.watchpoint)).isOK()) {
            if (status.getSeverity() == 2) {
                this.page.setMessage(status.getMessage(), 2);
                this.page.setValid(false);
            }
            if (status.getSeverity() == 4) {
                this.page.setMessage(status.getMessage(), 3);
                this.page.setValid(false);
            }
            return;
        }
        this.page.setValid(true);
        this.page.setMessage(null, 0);
        this.page.setErrorMessage(null);
    }

    public Tracepoint[] getTracepoints(IProject project) throws CoreException {
        IMarker[] markers;
        ArrayList<Tracepoint> found = new ArrayList<Tracepoint>();
        IMarker[] iMarkerArray = markers = project.findMarkers("com.atmel.avr32.debug.trace.TracepointMarker", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IBreakpoint bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
            if (bp != null && bp instanceof Tracepoint) {
                found.add((Tracepoint)bp);
            }
            ++n2;
        }
        return found.toArray(new Tracepoint[found.size()]);
    }

    private int countDataTracepoints(TracepointWorkingCopy tracepoint, Tracepoint.Operation operation) throws CoreException {
        Tracepoint[] watchpoints;
        int count = 0;
        Tracepoint[] tracepointArray = watchpoints = this.getTracepoints(tracepoint.getMarker().getResource().getProject());
        int n = watchpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Tracepoint watchpoint2 = tracepointArray[n2];
            if (!tracepoint.getWatchpoint().equals((Object)watchpoint2) && watchpoint2.isEnabled() && watchpoint2.isDataTrace() && watchpoint2.getOperation() == operation) {
                ++count;
            }
            ++n2;
        }
        if (tracepoint.isEnabled() && tracepoint.isDataTrace() && tracepoint.getOperation() == operation) {
            ++count;
        }
        return count;
    }

    private int countProgramTracepoints(TracepointWorkingCopy tracepoint, Tracepoint.Operation operation) throws CoreException {
        Tracepoint[] watchpoints;
        int count = 0;
        Tracepoint[] tracepointArray = watchpoints = this.getTracepoints(tracepoint.getMarker().getResource().getProject());
        int n = watchpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Tracepoint watchpoint2 = tracepointArray[n2];
            if (!tracepoint.getWatchpoint().equals((Object)watchpoint2) && watchpoint2.isEnabled() && watchpoint2.isProgramTrace() && watchpoint2.getOperation() == operation) {
                ++count;
            }
            ++n2;
        }
        if (tracepoint.isEnabled() && tracepoint.isProgramTrace() && tracepoint.getOperation() == operation) {
            ++count;
        }
        return count;
    }

    private static IStatus createErrorStatus(String text) {
        return new Status(4, "com.atmel.avr32.debug.trace", text);
    }

    IStatus validateTracepoint(TracepointWorkingCopy tracepoint) {
        IProject project = tracepoint.getMarker().getResource().getProject();
        if (project == null) {
            return TracepointPropertiesComposite.createErrorStatus(Messages.TracepointPropertiesComposite_UndeterminableProject);
        }
        String partName = TargetPlugin.getDefault().getPart(project).getName();
        DebugSystem debugSystem = TargetPlugin.getDefault().getPart(project).getDebugSystem();
        try {
            if (this.countProgramTracepoints(tracepoint, Tracepoint.Operation.START) > debugSystem.getStartPTW()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracepointPropertiesComposite_Start_PTW_Exhausted, partName, debugSystem.getStartPTW()));
            }
            if (this.countProgramTracepoints(tracepoint, Tracepoint.Operation.STOP) > debugSystem.getStopPTW()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracepointPropertiesComposite_Stop_PTW_Exhausted, partName, debugSystem.getStopPTW()));
            }
            if (this.countDataTracepoints(tracepoint, Tracepoint.Operation.START) > debugSystem.getStartDTW()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracepointPropertiesComposite_Start_DTW_Exhausted, partName, debugSystem.getStartDTW()));
            }
            if (this.countDataTracepoints(tracepoint, Tracepoint.Operation.STOP) > debugSystem.getStopDTW()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracepointPropertiesComposite_Stop_DTW_Exhausted, partName, debugSystem.getStopDTW()));
            }
            if (this.countDataModulesUsed(tracepoint) > debugSystem.getDataModules()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracePlugin_Validated_DataTraceExh, new Object[0]));
            }
            if (this.countProgramModulesUsed(tracepoint) > debugSystem.getProgramModules()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracePlugin_Validated_ProgramTraceExh, new Object[0]));
            }
            if (tracepoint.getLocationType() == Tracepoint.Location.RANGE && !debugSystem.isDataRangeSupported()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracepointPropertiesComposite_NoRangeError, partName));
            }
            if (tracepoint.getComparison() != Tracepoint.Compare.NO_COMPARISON && !debugSystem.isDwordAccessSupported()) {
                return TracepointPropertiesComposite.createErrorStatus(MessageFormat.format(Messages.TracepointPropertiesComposite_NoComparisonError, partName));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new Status(0, "com.atmel.avr32.debug.trace", Messages.TracePlugin_Validated);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        EnumSet<Tracepoint.Mask> mask;
        if (!this.doRefresh) {
            return;
        }
        if (e.widget.equals(this.enabledCheckBox)) {
            this.watchpoint.setEnabled(this.enabledCheckBox.getSelection());
        }
        if (e.widget.equals(this.startRadio)) {
            this.watchpoint.setOperation(Tracepoint.Operation.START);
        }
        if (e.widget.equals(this.stopRadio)) {
            this.watchpoint.setOperation(Tracepoint.Operation.STOP);
        }
        if (e.widget.equals(this.messageRadio)) {
            this.watchpoint.setOperation(Tracepoint.Operation.MESSAGE);
        }
        if (e.widget.equals(this.programTraceCheckBox)) {
            this.watchpoint.setProgramTrace(this.programTraceCheckBox.getSelection());
        }
        if (e.widget.equals(this.dataTraceCheckBox)) {
            this.watchpoint.setDataTrace(this.dataTraceCheckBox.getSelection());
        }
        if (e.widget.equals(this.pcRadioButton)) {
            this.watchpoint.setEvent(Tracepoint.Event.PROGRAM_COUNTER);
        }
        if (e.widget.equals(this.dataAccessRadioButton)) {
            this.watchpoint.setEvent(Tracepoint.Event.DATA_ACCESS);
        }
        if (e.widget.equals(this.dataReadRadioButton)) {
            this.watchpoint.setEvent(Tracepoint.Event.DATA_READ);
        }
        if (e.widget.equals(this.dataWriteRadioButton)) {
            this.watchpoint.setEvent(Tracepoint.Event.DATA_WRITE);
        }
        if (e.widget.equals(this.noValueRadioButton)) {
            this.watchpoint.setComparison(Tracepoint.Compare.NO_COMPARISON);
        }
        if (e.widget.equals(this.valueMaskRadioButton)) {
            this.watchpoint.setComparison(Tracepoint.Compare.MASK_BYTES);
        }
        if (e.widget.equals(this.valueCompareRadioButton)) {
            this.watchpoint.setComparison(Tracepoint.Compare.EQUALITY);
        }
        if (e.widget.equals(this.valueCompareCombo)) {
            switch (this.valueCompareCombo.getSelectionIndex()) {
                case 0: {
                    this.watchpoint.setComparisonSize(Tracepoint.Size.DISREGARD);
                    break;
                }
                case 1: {
                    this.watchpoint.setComparisonSize(Tracepoint.Size.BYTE);
                    break;
                }
                case 2: {
                    this.watchpoint.setComparisonSize(Tracepoint.Size.HALFWORD);
                    break;
                }
                case 3: {
                    this.watchpoint.setComparisonSize(Tracepoint.Size.WORD);
                    break;
                }
                case 4: {
                    this.watchpoint.setComparisonSize(Tracepoint.Size.DOUBLEWORD);
                }
            }
        }
        if (e.widget.equals(this.addressRadio) && this.addressRadio.getSelection()) {
            this.watchpoint.setLocationType(Tracepoint.Location.LOCATION);
        }
        if (e.widget.equals(this.rangeRadio) && this.rangeRadio.getSelection()) {
            this.watchpoint.setLocationType(Tracepoint.Location.RANGE);
        }
        if (e.widget.equals(this.valueMask_3)) {
            mask = this.watchpoint.getComparisonMask();
            if (this.valueMask_3.getSelection()) {
                mask.add(Tracepoint.Mask.MASK_31_24);
            } else {
                mask.remove(Tracepoint.Mask.MASK_31_24);
            }
            this.watchpoint.setComparisonMask(mask);
        }
        if (e.widget.equals(this.valueMask_2)) {
            mask = this.watchpoint.getComparisonMask();
            if (this.valueMask_2.getSelection()) {
                mask.add(Tracepoint.Mask.MASK_23_16);
            } else {
                mask.remove(Tracepoint.Mask.MASK_23_16);
            }
            this.watchpoint.setComparisonMask(mask);
        }
        if (e.widget.equals(this.valueMask_1)) {
            mask = this.watchpoint.getComparisonMask();
            if (this.valueMask_1.getSelection()) {
                mask.add(Tracepoint.Mask.MASK_15_8);
            } else {
                mask.remove(Tracepoint.Mask.MASK_15_8);
            }
            this.watchpoint.setComparisonMask(mask);
        }
        if (e.widget.equals(this.valueMask_0)) {
            mask = this.watchpoint.getComparisonMask();
            if (this.valueMask_0.getSelection()) {
                mask.add(Tracepoint.Mask.MASK_7_0);
            } else {
                mask.remove(Tracepoint.Mask.MASK_7_0);
            }
            this.watchpoint.setComparisonMask(mask);
        }
        if (e.widget.equals(this.rangeCombo)) {
            switch (this.rangeCombo.getSelectionIndex()) {
                case 0: {
                    this.watchpoint.setRangeType(Tracepoint.Range.EXCLUSIVE);
                    break;
                }
                case 1: {
                    this.watchpoint.setRangeType(Tracepoint.Range.INCLUSIVE);
                    break;
                }
            }
        }
        this.updateEnabledState();
    }
}

