/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.TracePlugin;
import com.atmel.avr32.debug.trace.client.ITraceEventListener;
import com.atmel.avr32.debug.trace.client.TraceClient;
import com.atmel.avr32.debug.trace.client.TraceEvent;
import com.atmel.avr32.debug.trace.client.TraceException;
import com.atmel.avr32.debug.trace.data.ITraceFrame;
import com.atmel.avr32.debug.trace.data.ProgramTraceFrame;
import com.atmel.avr32.debug.trace.ui.TraceUIPlugin;
import com.atmel.avr32.debug.trace.ui.internal.Messages;
import com.atmel.avr32.debug.trace.ui.internal.TraceColumnLabelProvider;
import com.atmel.avr32.debug.trace.ui.internal.TraceDataTableContentProvider;
import com.atmel.avr32.debug.trace.ui.internal.TraceDataViewer;
import com.atmel.avr32.debug.trace.ui.internal.TraceFrameDoubleClickListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.CSourceViewerConfiguration;
import org.eclipse.core.commands.Command;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class TraceView
extends ViewPart
implements ITraceEventListener,
IDebugContextListener {
    private final NumberFormat formatter = NumberFormat.getInstance();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Highlighting fFilenameHighlighting;
    private List<HighlightedPosition> fileNameLocations = new ArrayList<HighlightedPosition>();
    private static final String EMPTY_STRING = "";
    final int COLUMN_COUNT = 3;
    private LaunchListener fLaunchListener;
    private PartListener fPartListener;
    boolean fPinned;
    private TraceClient fSession;
    private CSourceViewer fSourceViewer;
    private TableSelectionListener fListener;
    private SourceViewerConfiguration fSourceViewerConfiguration;
    private SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    private Label fStatusField;
    private IAction pinAction;
    private TraceDataViewer tableView;

    private String _getContentDescription() {
        StringBuffer sb = new StringBuffer();
        if (this.fSession == null) {
            sb.append(Messages.TraceView_NoData);
        } else {
            sb.append(this.fSession.getLaunch().getLaunchConfiguration().getName());
            if (!this.fSession.isConnected()) {
                sb.append(Messages.TraceView_Disconnected);
            }
        }
        return sb.toString();
    }

    void setEnabled(boolean state) {
        Display display = Display.getCurrent();
        this.tableView.getTable().setEnabled(state);
        this.fSourceViewer.getControl().setEnabled(state);
        if (state) {
            this.fSourceViewer.getControl().setBackground(display.getSystemColor(25));
        } else {
            this.fSourceViewer.getControl().setBackground(display.getSystemColor(22));
        }
    }

    private void clearBuffer() {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                if (TraceView.this.fSourceViewer != null && TraceView.this.fSourceViewer.getDocument() != null) {
                    TraceView.this.fSourceViewer.getDocument().set(TraceView.EMPTY_STRING);
                }
                if (TraceView.this.fStatusField != null) {
                    TraceView.this.fStatusField.setText(TraceView.EMPTY_STRING);
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(update);
    }

    private void createActions() {
        this.pinAction = new Action(Messages.TraceView_Pin, 2){

            public void run() {
                TraceView.this.fPinned = TraceView.this.pinAction.isChecked();
            }
        };
        this.pinAction.setImageDescriptor(TraceUIPlugin.getViewImageDescriptor("clcl16/pin.gif"));
    }

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayout((Layout)new FillLayout());
        Composite panel = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        panel.setLayout((Layout)gl);
        this.tableView = new TraceDataViewer(this.getViewSite().getActionBars().getStatusLineManager(), panel, 268501762, true);
        this.tableView.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTable(this.tableView);
        this.tableView.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fStatusField = new Label(panel, 0);
        this.fStatusField.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        IPreferenceStore fPreferenceStore = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        this.tableView.addDoubleClickListener(new TraceFrameDoubleClickListener());
        this.fListener = new TableSelectionListener();
        this.tableView.addSelectionChangedListener(this.fListener);
        this.fSourceViewer = new CSourceViewer((Composite)sash, null, null, false, 776, fPreferenceStore);
        SimpleCSourceViewerConfiguration fViewerConfiguration = new SimpleCSourceViewerConfiguration(tools.getColorManager(), fPreferenceStore, null, "___c_partitioning", true);
        this.fSourceViewer.configure((SourceViewerConfiguration)fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont"));
        Document d = new Document();
        tools.setupCDocument((IDocument)d);
        this.fSourceViewer.setDocument((IDocument)d);
        this.fFilenameHighlighting = new Highlighting(new TextAttribute(this.fSourceViewer.getControl().getBackground(), this.getSharedColors().getColor(new RGB(180, 180, 180)), 1), true);
        this.fSourceViewer.addTextPresentationListener((ITextPresentationListener)new FilenamePainter());
        this.createActions();
        this.setEnabled(false);
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add(this.pinAction);
        this.fLaunchListener = new LaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchListener);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        this.fPartListener = new PartListener();
        this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
    }

    private void createTable(TraceDataViewer table) {
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.tableView, 0x1000000);
        column.getColumn().setText(EMPTY_STRING);
        column.getColumn().setWidth(25);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(table){

            public Image getImage(Object element) {
                if (element instanceof ProgramTraceFrame) {
                    ProgramTraceFrame td = (ProgramTraceFrame)element;
                    switch (td.getBranch()) {
                        case CALL: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_CALL");
                        }
                        case DIRECT_BRANCH: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_DIRECT");
                        }
                        case EXCEPTION: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_EXEPTION");
                        }
                        case PC_MODIFIED: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_REGISTER");
                        }
                        case RETURN: {
                            return TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_BRANCH_RETURN");
                        }
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return TraceView.EMPTY_STRING;
            }

            public String getToolTipText(Object element) {
                if (element instanceof ProgramTraceFrame) {
                    return ((ProgramTraceFrame)element).getTooltip();
                }
                return null;
            }
        });
        column = new TableViewerColumn((TableViewer)this.tableView, 16384);
        column.getColumn().setText("Frame #");
        column.getColumn().setWidth(125);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(table){

            public String getText(Object element) {
                if (element instanceof ITraceFrame) {
                    return ((ITraceFrame)element).getSequence();
                }
                return TraceView.EMPTY_STRING;
            }
        });
        column = new TableViewerColumn((TableViewer)this.tableView, 16384);
        column.getColumn().setText(Messages.TraceView_Address);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(table){

            public String getText(Object element) {
                if (element instanceof ITraceFrame) {
                    return ((ITraceFrame)element).getAddress();
                }
                return TraceView.EMPTY_STRING;
            }
        });
        column = new TableViewerColumn((TableViewer)this.tableView, 16384);
        column.getColumn().setText(Messages.TraceView_Trace);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(false);
        column.setLabelProvider((CellLabelProvider)new TraceColumnLabelProvider(table){

            public String getText(Object element) {
                if (element instanceof ITraceFrame) {
                    return ((ITraceFrame)element).getText();
                }
                return TraceView.EMPTY_STRING;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableView, (int)2);
        this.tableView.getTable().setHeaderVisible(true);
        this.tableView.setUseHashlookup(false);
        this.tableView.setContentProvider((IContentProvider)new TraceDataTableContentProvider());
        this.tableView.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = event.gc.getFontMetrics().getHeight() + 2;
            }
        });
    }

    public void dispose() {
        if (this.fSession != null) {
            this.fSession.removeTraceEventListener((ITraceEventListener)this);
            this.fSession = null;
        }
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchListener);
        this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
        super.dispose();
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchSiteProgressService service = null;
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    private ISharedTextColors getSharedColors() {
        ISharedTextColors sharedColors = CDebugUIPlugin.getDefault().getSharedTextColors();
        return sharedColors;
    }

    protected SourceViewerConfiguration getSourceViewerConfiguration() {
        if (this.fSourceViewerConfiguration == null) {
            CTextTools tools = CUIPlugin.getDefault().getTextTools();
            IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
            this.fSourceViewerConfiguration = new CSourceViewerConfiguration(tools.getColorManager(), store, null, "___c_partitioning");
        }
        return this.fSourceViewerConfiguration;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, null, null, this.getSharedColors());
        }
        return this.fSourceViewerDecorationSupport;
    }

    public TraceClient getTraceSession() {
        return this.fSession;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    private void handleSelectionChange(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            TraceClient session = null;
            Object o = ((IStructuredSelection)selection).getFirstElement();
            if (o instanceof ILaunch) {
                session = TracePlugin.getDefault().getTraceSession((ILaunch)o);
            }
            if (o instanceof CDebugTarget) {
                session = TracePlugin.getDefault().getTraceSession(((CDebugTarget)o).getLaunch());
            }
            if (o instanceof CThread) {
                session = TracePlugin.getDefault().getTraceSession(((CThread)o).getLaunch());
            }
            if (o instanceof CStackFrame) {
                session = TracePlugin.getDefault().getTraceSession(((CStackFrame)o).getLaunch());
            }
            if (session == null || !session.equals(this.fSession)) {
                this.setTraceSession(session);
            }
        }
    }

    public void setFocus() {
    }

    private void setTraceSession(TraceClient session) {
        if (this.fSession != null) {
            this.fSession.removeTraceEventListener((ITraceEventListener)this);
        }
        if (session != null) {
            session.addTraceEventListener((ITraceEventListener)this);
        }
        this.fSession = session;
        if (session == null) {
            this.setEnabled(false);
            this.tableView.setInput(null);
            this.clearBuffer();
        } else {
            this.setEnabled(session.isConnected());
            this.tableView.setInput(session);
        }
        this.updateContentDescription();
        this.updateActions();
    }

    public void showBusy(boolean busy) {
    }

    public void traceEvent(TraceEvent event) {
        switch (event.getType()) {
            case CLIENT_CONNECTED: {
                break;
            }
            case CLIENT_DISCONNECTED: {
                this.updateContentDescription();
                this.updateActions();
                this.clearBuffer();
                break;
            }
            case CLIENT_INITIALIZED: {
                this.updateContentDescription();
                this.updateActions();
                break;
            }
            case DATA_AVAILABLE: {
                this.updateStatusField(event);
                break;
            }
            case FORMAT_CHANGED: {
                this.fListener.updateSelection(this.tableView.getSelection());
                break;
            }
            case BUFFER_CLEARED: {
                this.clearBuffer();
                break;
            }
        }
    }

    private void updateActions() {
        final IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        Runnable update = new Runnable(){

            @Override
            public void run() {
                HashMap<String, IWorkbenchWindow> filter = new HashMap<String, IWorkbenchWindow>();
                filter.put("org.eclipse.ui.IWorkbenchWindow", window);
                ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
                if (commandService != null) {
                    Command[] commands = commandService.getDefinedCommands();
                    int i = 0;
                    while (i < commands.length) {
                        commandService.refreshElements(commands[i].getId(), filter);
                        ++i;
                    }
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(update);
    }

    private void updateContentDescription() {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                TraceView.this.setContentDescription(TraceView.this._getContentDescription());
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(update);
    }

    private void updateStatusField(final TraceEvent event) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                if (TraceView.this.fStatusField != null) {
                    TraceView.this.fStatusField.setText(MessageFormat.format(Messages.TraceView_TraceFrameCount, TraceView.this.formatter.format(event.getLength())));
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(update);
    }

    public void debugContextChanged(DebugContextEvent event) {
        if (this.fPinned) {
            return;
        }
        this.handleSelectionChange(event.getContext());
    }

    private class FilenamePainter
    implements ITextPresentationListener {
        private FilenamePainter() {
        }

        private int computeIndexAtOffset(List<HighlightedPosition> positions, int offset) {
            int i = -1;
            int j = positions.size();
            while (j - i > 1) {
                int k = i + j >> 1;
                Position position = positions.get(k);
                if (position.getOffset() >= offset) {
                    j = k;
                    continue;
                }
                i = k;
            }
            return j;
        }

        /*
         * Unable to fully structure code
         */
        public void applyTextPresentation(TextPresentation textPresentation) {
            block4: {
                region = textPresentation.getExtent();
                i = this.computeIndexAtOffset(TraceView.access$5(TraceView.this), region.getOffset());
                n = this.computeIndexAtOffset(TraceView.access$5(TraceView.this), region.getOffset() + region.getLength());
                if (n - i <= 2) ** GOTO lbl21
                ranges = new ArrayList<StyleRange>(n - i);
                while (i < n) {
                    position = (HighlightedPosition)TraceView.access$5(TraceView.this).get(i);
                    if (!position.isDeleted()) {
                        ranges.add(position.createStyleRange());
                    }
                    ++i;
                }
                array = new StyleRange[ranges.size()];
                array = ranges.toArray(array);
                textPresentation.replaceStyleRanges(array);
                break block4;
lbl-1000:
                // 1 sources

                {
                    position = (HighlightedPosition)TraceView.access$5(TraceView.this).get(i);
                    if (!position.isDeleted()) {
                        textPresentation.replaceStyleRange(position.createStyleRange());
                    }
                    ++i;
lbl21:
                    // 2 sources

                    ** while (i < n)
                }
            }
        }
    }

    static class HighlightedPosition
    extends Position {
        private Highlighting fStyle;
        private Object fLock;

        public HighlightedPosition(int offset, int length, Highlighting highlighting, Object lock) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, Highlighting highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public Highlighting getHighlighting() {
            return this.fStyle;
        }
    }

    static class Highlighting {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public Highlighting(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }

    private class LaunchListener
    implements ILaunchesListener2 {
        private LaunchListener() {
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
            if (TraceView.this.fSession == null) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch launch = iLaunchArray[n2];
                    final TraceClient session = TracePlugin.getDefault().getTraceSession(launch);
                    if (session != null) {
                        Runnable update = new Runnable(){

                            @Override
                            public void run() {
                                TraceView.this.setTraceSession(session);
                            }
                        };
                        PlatformUI.getWorkbench().getDisplay().asyncExec(update);
                        break;
                    }
                    ++n2;
                }
            }
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (TraceView.this.fSession != null && TraceView.this.fSession.getLaunch().equals(launch)) {
                    Runnable update = new Runnable(){

                        @Override
                        public void run() {
                            TraceView.this.setTraceSession(null);
                        }
                    };
                    PlatformUI.getWorkbench().getDisplay().asyncExec(update);
                }
                ++n2;
            }
        }
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == TraceView.this) {
                if (TraceView.this.fSession == null) {
                    TraceClient[] sessions = TracePlugin.getDefault().getTraceSessions();
                    if (sessions.length > 0) {
                        TraceClient[] traceClientArray = sessions;
                        int n = sessions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TraceClient traceClient = traceClientArray[n2];
                            if (traceClient.isConnected()) {
                                TraceView.this.setTraceSession(sessions[0]);
                                break;
                            }
                            ++n2;
                        }
                    }
                } else {
                    TraceView.this.updateContentDescription();
                    TraceView.this.updateActions();
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }
    }

    private class TableSelectionListener
    implements ISelectionChangedListener {
        private TableSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                this.updateSelection(event.getSelection());
            }
        }

        public void updateSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                Object[] elements;
                StringBuilder code = new StringBuilder();
                TraceClient provider = (TraceClient)TraceView.this.tableView.getInput();
                IStructuredSelection s = (IStructuredSelection)selection;
                TraceView.this.fileNameLocations.clear();
                Object[] objectArray = elements = s.toArray();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof ProgramTraceFrame) {
                        try {
                            String filename = ((ProgramTraceFrame)object).getPresentationString();
                            TraceView.this.fileNameLocations.add(new HighlightedPosition(code.length(), filename.length(), TraceView.this.fFilenameHighlighting, null));
                            code.append(filename);
                            code.append(LINE_SEPARATOR);
                            code.append(provider.getCode((ProgramTraceFrame)object));
                        }
                        catch (TraceException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                TraceView.this.fSourceViewer.getDocument().set(code.toString());
            }
        }
    }
}

