/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.debug.IUpdate;
import com.atmel.avr32.debug.trace.ui.internal.Messages;
import com.atmel.avr32.debug.trace.ui.internal.TraceSettingsComposite;
import com.atmel.avr32.debug.ui.internal.launch.StandaloneMainTab;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.tool.model.TargetInterfaceDescription;
import java.util.EnumSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class TraceSettingsTab
extends AbstractLaunchConfigurationTab
implements IUpdate {
    TraceSettingsComposite composite;
    private static final String CONTEXT_HELP_ID = "com.atmel.avr32.doc.guide.launch_standalone";
    private boolean valid = true;

    public String getId() {
        return "avr32.launch.trace.main";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.valid;
    }

    public void createControl(Composite parent) {
        this.composite = new TraceSettingsComposite(parent, 0, this);
        this.setControl((Control)this.composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), CONTEXT_HELP_ID);
    }

    public String getName() {
        return Messages.TraceSettingsTab_Name;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.composite.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.composite.performApply(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void updateConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void error(String message) {
        super.setErrorMessage(message);
        this.valid = message == null;
    }

    public void update() {
        EnumSet<AVR32DebugPlugin.TraceMethod> methods = EnumSet.noneOf(AVR32DebugPlugin.TraceMethod.class);
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        TargetInterfaceDescription ti = null;
        ITarget td = null;
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof StandaloneMainTab) {
                ti = ((StandaloneMainTab)tab).getTargetInterface();
                td = ((StandaloneMainTab)tab).getTarget();
                IResource file = ((StandaloneMainTab)tab).getFile();
                this.composite.setFile(file);
                break;
            }
            ++n2;
        }
        if (td != null && ti != null) {
            if (TargetPlugin.getDefault().supportsCapability(ti, td, TargetPlugin.CapabilityId.nanotrace)) {
                methods.add(AVR32DebugPlugin.TraceMethod.NANO_TRACE);
            }
            if (TargetPlugin.getDefault().supportsCapability(ti, td, TargetPlugin.CapabilityId.auxtrace)) {
                methods.add(AVR32DebugPlugin.TraceMethod.AUX_TRACE);
                methods.add(AVR32DebugPlugin.TraceMethod.STREAMING_AUX_TRACE);
            }
            this.composite.setPart(td.getPart());
        }
        this.composite.setTraceEnablement(methods);
    }

    public void setResource(IResource resource) {
        this.composite.setFile(resource);
    }
}

