/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.debug.AVR32NM;
import com.atmel.avr32.debug.trace.ui.internal.Messages;
import com.atmel.avr32.debug.trace.ui.internal.TraceSettingsTab;
import com.atmel.avr32.debug.ui.SymbolSelectionDialog;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.util.math.BytePrefixParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class TraceSettingsComposite
extends Composite
implements ModifyListener,
SelectionListener {
    private static final String EMULATOR_BUFFER_SIZE = "128kB";
    private static final String NANOTRACE_ADDRESS_NAME = "NANOTRACE";
    private Combo bufferSizeCombo;
    private static final String DEFAULT_NANOTRACE_LENGTH = "1024";
    private static final String DEFAULT_ACCESS_TYPE = "RW";
    private static final String[] ACCESS_TYPES = new String[]{"RW", "R", "W"};
    private static final String ELIPSIS = Messages.TraceBoundariesComposite_Elipsis;
    private static final String HEX_PREFIX = "0x";
    private static final String HEX_ZERO = "0x0";
    private Group bufferFullGroup = null;
    private Text bufferSize = null;
    private Composite channel_1_composite = null;
    private Group channel_1_lower_group = null;
    private Group channel_1_upper_group = null;
    private Composite channel_2_composite = null;
    private Group channel_2_lower_group = null;
    private Group channel_2_upper_group = null;
    private TabFolder channel_tab_folder = null;
    private Combo channel_1_type;
    private Combo channel_2_type;
    private Group dataTraceOptionsGroup = null;
    private Button detectButton;
    private Button disableTrace = null;
    private Button enableNTAP = null;
    private Button enableOwnershipTrace = null;
    private Button enableTrace = null;
    private Button enterDebugMode = null;
    private Group nanotraceGroup = null;
    private Button overwriteBuffer = null;
    private TraceSettingsTab page;
    private Button readAndContinue = null;
    private IResource resource;
    private Text startAddress = null;
    private Combo traceMethod = null;
    private EnumSet<AVR32DebugPlugin.TraceMethod> traceMethods = EnumSet.noneOf(AVR32DebugPlugin.TraceMethod.class);
    private Text channel_1_lb_text = null;
    private Text channel_2_lb_text = null;
    private Text channel_1_ub_text = null;
    private Text channel_2_ub_text = null;
    private Button channel_1_lb_prompt;
    private Button channel_1_ub_prompt;
    private Button channel_2_lb_prompt;
    private Button channel_2_ub_prompt;
    private Group auxiliaryTraceGroup;
    private Button useNanotraceVariableButton;
    private Button specifySizeAndButton;
    Part part;
    private Combo nexusInterfaceCombo;
    private Button overrideNexusInterface;
    private Label nexusInterfaceLabel;

    public TraceSettingsComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public TraceSettingsComposite(Composite parent, int style, TraceSettingsTab tab) {
        super(parent, style);
        this.page = tab;
        this.initialize();
    }

    private AVR32NM.AddressNamePair browse() {
        SymbolSelectionDialog dialog = new SymbolSelectionDialog(this.getShell(), SymbolSelectionDialog.SymbolType.ALL, this.resource.getLocation().toOSString());
        if (dialog.open() == 0 && dialog.getResult().length == 1) {
            return (AVR32NM.AddressNamePair)dialog.getResult()[0];
        }
        return null;
    }

    private void createBufferFullGroup() {
        GridData gridData3 = new GridData(4, 4, false, false, 2, 1);
        gridData3.widthHint = 262;
        this.bufferFullGroup = new Group((Composite)this, 0);
        this.bufferFullGroup.setLayout((Layout)new GridLayout(2, true));
        this.bufferFullGroup.setLayoutData((Object)gridData3);
        this.bufferFullGroup.setText(Messages.TraceSettingsComposite_4);
        this.disableTrace = new Button((Composite)this.bufferFullGroup, 16);
        this.disableTrace.setText(Messages.TraceSettingsComposite_8);
        this.disableTrace.addSelectionListener((SelectionListener)this);
        this.enterDebugMode = new Button((Composite)this.bufferFullGroup, 16);
        this.enterDebugMode.setText(Messages.TraceSettingsComposite_6);
        this.enterDebugMode.addSelectionListener((SelectionListener)this);
        this.readAndContinue = new Button((Composite)this.bufferFullGroup, 16);
        this.readAndContinue.setText(Messages.TraceSettingsComposite_5);
        this.readAndContinue.addSelectionListener((SelectionListener)this);
        this.overwriteBuffer = new Button((Composite)this.bufferFullGroup, 16);
        this.overwriteBuffer.setText(Messages.TraceSettingsComposite_7);
        this.overwriteBuffer.addSelectionListener((SelectionListener)this);
    }

    private void createChannel1Composite() {
        this.channel_1_composite = new Composite((Composite)this.channel_tab_folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.channel_1_composite.setLayout((Layout)gridLayout);
        this.createChannel1LowerGroup();
        this.createChannel1UpperGroup();
    }

    private void createChannel1LowerGroup() {
        GridData gridData17 = new GridData();
        gridData17.minimumWidth = 80;
        gridData17.horizontalAlignment = 4;
        gridData17.grabExcessHorizontalSpace = true;
        GridLayout gridLayout5 = new GridLayout();
        gridLayout5.numColumns = 3;
        GridData gd_channel_1_lower_group = new GridData(4, 4, true, false, 2, 1);
        Label memoryAccessTypeLabel = new Label(this.channel_1_composite, 0);
        memoryAccessTypeLabel.setText(Messages.TraceSettingsComposite_33);
        this.channel_1_type = new Combo(this.channel_1_composite, 8);
        this.channel_1_type.setItems(new String[]{Messages.TraceSettingsComposite_Access, Messages.TraceSettingsComposite_Read, Messages.TraceSettingsComposite_Write});
        this.channel_1_type.select(0);
        this.channel_1_type.addSelectionListener((SelectionListener)this);
        this.channel_1_type.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.channel_1_lower_group = new Group(this.channel_1_composite, 0);
        this.channel_1_lower_group.setLayoutData((Object)gd_channel_1_lower_group);
        this.channel_1_lower_group.setLayout((Layout)gridLayout5);
        this.channel_1_lower_group.setText(Messages.TraceBoundariesComposite_5);
        Label label = new Label((Composite)this.channel_1_lower_group, 0);
        label.setText(Messages.TraceBoundariesComposite_6);
        this.channel_1_lb_text = new Text((Composite)this.channel_1_lower_group, 133120);
        this.channel_1_lb_text.setLayoutData((Object)gridData17);
        this.channel_1_lb_text.addModifyListener((ModifyListener)this);
        this.channel_1_lb_prompt = new Button((Composite)this.channel_1_lower_group, 0);
        this.channel_1_lb_prompt.setText(ELIPSIS);
        this.channel_1_lb_prompt.addSelectionListener((SelectionListener)this);
    }

    private void createChannel1UpperGroup() {
        GridData gridData19 = new GridData();
        gridData19.minimumWidth = 80;
        gridData19.grabExcessHorizontalSpace = true;
        gridData19.horizontalAlignment = 4;
        GridLayout gridLayout7 = new GridLayout();
        gridLayout7.numColumns = 3;
        GridData gd_channel_1_upper_group = new GridData(4, 0x1000000, true, false, 2, 1);
        this.channel_1_upper_group = new Group(this.channel_1_composite, 0);
        this.channel_1_upper_group.setLayoutData((Object)gd_channel_1_upper_group);
        this.channel_1_upper_group.setLayout((Layout)gridLayout7);
        this.channel_1_upper_group.setText(Messages.TraceBoundariesComposite_8);
        Label label = new Label((Composite)this.channel_1_upper_group, 0);
        label.setText(Messages.TraceBoundariesComposite_9);
        this.channel_1_ub_text = new Text((Composite)this.channel_1_upper_group, 133120);
        this.channel_1_ub_text.setLayoutData((Object)gridData19);
        this.channel_1_ub_text.addModifyListener((ModifyListener)this);
        this.channel_1_ub_prompt = new Button((Composite)this.channel_1_upper_group, 0);
        this.channel_1_ub_prompt.addSelectionListener((SelectionListener)this);
        this.channel_1_ub_prompt.setText(ELIPSIS);
    }

    private void createChannel2Composite() {
        this.channel_2_composite = new Composite((Composite)this.channel_tab_folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.channel_2_composite.setLayout((Layout)gridLayout);
        this.createChannel2LowerGroup();
        this.createChannel2UpperGroup();
    }

    private void createChannel2LowerGroup() {
        GridData gridData11 = new GridData();
        gridData11.minimumWidth = 80;
        gridData11.grabExcessHorizontalSpace = true;
        gridData11.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        GridData gd_channel_2_lower_group = new GridData(4, 0x1000000, true, false, 2, 1);
        Label memoryAccessTypeLabel = new Label(this.channel_2_composite, 0);
        memoryAccessTypeLabel.setText(Messages.TraceSettingsComposite_37);
        this.channel_2_type = new Combo(this.channel_2_composite, 8);
        this.channel_2_type.setItems(new String[]{Messages.TraceSettingsComposite_Access, Messages.TraceSettingsComposite_Read, Messages.TraceSettingsComposite_Write});
        this.channel_2_type.select(0);
        this.channel_2_type.addSelectionListener((SelectionListener)this);
        this.channel_2_type.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.channel_2_lower_group = new Group(this.channel_2_composite, 0);
        this.channel_2_lower_group.setLayoutData((Object)gd_channel_2_lower_group);
        this.channel_2_lower_group.setLayout((Layout)gridLayout);
        this.channel_2_lower_group.setText(Messages.TraceBoundariesComposite_11);
        Label label = new Label((Composite)this.channel_2_lower_group, 0);
        label.setText(Messages.TraceBoundariesComposite_12);
        this.channel_2_lb_text = new Text((Composite)this.channel_2_lower_group, 133120);
        this.channel_2_lb_text.setLayoutData((Object)gridData11);
        this.channel_2_lb_text.addModifyListener((ModifyListener)this);
        this.channel_2_lb_prompt = new Button((Composite)this.channel_2_lower_group, 0);
        this.channel_2_lb_prompt.setText(ELIPSIS);
        this.channel_2_lb_prompt.addSelectionListener((SelectionListener)this);
    }

    private void createChannel2UpperGroup() {
        GridData gridData3 = new GridData();
        gridData3.minimumWidth = 80;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 4;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        GridData gd_channel_2_upper_group = new GridData(4, 0x1000000, true, false, 2, 1);
        this.channel_2_upper_group = new Group(this.channel_2_composite, 0);
        this.channel_2_upper_group.setLayoutData((Object)gd_channel_2_upper_group);
        this.channel_2_upper_group.setLayout((Layout)gridLayout1);
        this.channel_2_upper_group.setText(Messages.TraceBoundariesComposite_14);
        Label label = new Label((Composite)this.channel_2_upper_group, 0);
        label.setText(Messages.TraceBoundariesComposite_15);
        this.channel_2_ub_text = new Text((Composite)this.channel_2_upper_group, 133120);
        this.channel_2_ub_text.setLayoutData((Object)gridData3);
        this.channel_2_ub_text.addModifyListener((ModifyListener)this);
        this.channel_2_ub_prompt = new Button((Composite)this.channel_2_upper_group, 0);
        this.channel_2_ub_prompt.setText(ELIPSIS);
        this.channel_2_ub_prompt.addSelectionListener((SelectionListener)this);
    }

    private void createDataTraceGroup() {
        this.dataTraceOptionsGroup = new Group((Composite)this, 0);
        this.dataTraceOptionsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.dataTraceOptionsGroup.setText(Messages.TraceSettingsComposite_41);
        GridLayout gridLayout_1 = new GridLayout();
        this.dataTraceOptionsGroup.setLayout((Layout)gridLayout_1);
        this.channel_tab_folder = new TabFolder((Composite)this.dataTraceOptionsGroup, 0);
        this.channel_tab_folder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 2));
        this.createChannel1Composite();
        TabItem range1tab = new TabItem(this.channel_tab_folder, 0);
        range1tab.setText(Messages.TraceBoundariesComposite_3);
        range1tab.setControl((Control)this.channel_1_composite);
        this.createChannel2Composite();
        TabItem range2tab = new TabItem(this.channel_tab_folder, 0);
        range2tab.setText(Messages.TraceBoundariesComposite_4);
        range2tab.setControl((Control)this.channel_2_composite);
    }

    private void createAuxiliaryTraceGroup() {
        this.auxiliaryTraceGroup = new Group((Composite)this, 0);
        GridData gd_auxiliaryTraceGroup = new GridData(4, 4, false, false);
        this.auxiliaryTraceGroup.setLayoutData((Object)gd_auxiliaryTraceGroup);
        this.auxiliaryTraceGroup.setText(Messages.TraceSettingsComposite_AUXTraceOptionsLabel);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.auxiliaryTraceGroup.setLayout((Layout)gridLayout_1);
        Label bufferSizeLabel = new Label((Composite)this.auxiliaryTraceGroup, 0);
        bufferSizeLabel.setText(Messages.TraceSettingsComposite_BufferSizeLabel);
        this.bufferSizeCombo = new Combo((Composite)this.auxiliaryTraceGroup, 8);
        GridData gd_combo_1 = new GridData(4, 0x1000000, true, false);
        this.bufferSizeCombo.add("128MB");
        this.bufferSizeCombo.add("64MB");
        this.bufferSizeCombo.add("32MB");
        this.bufferSizeCombo.add("16MB");
        this.bufferSizeCombo.add("8MB");
        this.bufferSizeCombo.add("4MB");
        this.bufferSizeCombo.add("2MB");
        this.bufferSizeCombo.add("1MB");
        this.bufferSizeCombo.add("512kB");
        this.bufferSizeCombo.add("256kB");
        this.bufferSizeCombo.add(EMULATOR_BUFFER_SIZE);
        this.bufferSizeCombo.add("64kB");
        this.bufferSizeCombo.add("32kB");
        this.bufferSizeCombo.add("16kB");
        gd_combo_1.widthHint = 50;
        this.bufferSizeCombo.setLayoutData((Object)gd_combo_1);
        this.bufferSizeCombo.addModifyListener((ModifyListener)this);
        this.overrideNexusInterface = new Button((Composite)this.auxiliaryTraceGroup, 32);
        this.overrideNexusInterface.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.overrideNexusInterface.setText(Messages.TraceSettingsComposite_OverrideAUXPortPin);
        this.overrideNexusInterface.addSelectionListener((SelectionListener)this);
        this.nexusInterfaceLabel = new Label((Composite)this.auxiliaryTraceGroup, 0);
        this.nexusInterfaceLabel.setText(Messages.TraceSettingsComposite_AUXPortPins);
        this.nexusInterfaceCombo = new Combo((Composite)this.auxiliaryTraceGroup, 8);
        GridData gd_combo_2 = new GridData(4, 0x1000000, true, false);
        gd_combo_2.widthHint = 25;
        this.nexusInterfaceCombo.setLayoutData((Object)gd_combo_2);
        this.nexusInterfaceCombo.addModifyListener((ModifyListener)this);
        this.setEnabled((Composite)this.auxiliaryTraceGroup, false);
    }

    private void createNanoTraceGroup() {
        GridData gridData8 = new GridData(4, 0x1000000, false, false);
        gridData8.widthHint = 50;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        GridData gridData6 = new GridData(4, 4, false, false);
        this.nanotraceGroup = new Group((Composite)this, 0);
        this.nanotraceGroup.setLayoutData((Object)gridData6);
        this.nanotraceGroup.setLayout((Layout)gridLayout1);
        this.nanotraceGroup.setText(Messages.TraceSettingsComposite_13);
        this.enableNTAP = new Button((Composite)this.nanotraceGroup, 32);
        this.enableNTAP.setText(Messages.TraceSettingsComposite_14);
        this.enableNTAP.addSelectionListener((SelectionListener)this);
        this.enableNTAP.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.useNanotraceVariableButton = new Button((Composite)this.nanotraceGroup, 16);
        GridData gd_useNanotraceVariableButton = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.useNanotraceVariableButton.setLayoutData((Object)gd_useNanotraceVariableButton);
        this.useNanotraceVariableButton.setText(Messages.TraceSettingsComposite_UseNanoTraceVariableLabel);
        this.useNanotraceVariableButton.addSelectionListener((SelectionListener)this);
        this.specifySizeAndButton = new Button((Composite)this.nanotraceGroup, 16);
        GridData gd_specifySizeAndButton = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.specifySizeAndButton.setLayoutData((Object)gd_specifySizeAndButton);
        this.specifySizeAndButton.setText(Messages.TraceSettingsComposite_SizeAndLocationLabel);
        this.specifySizeAndButton.addSelectionListener((SelectionListener)this);
        Label label4 = new Label((Composite)this.nanotraceGroup, 0);
        label4.setLayoutData((Object)new GridData());
        label4.setText(Messages.TraceSettingsComposite_16);
        label4.setToolTipText(Messages.TraceSettingsComposite_17);
        this.startAddress = new Text((Composite)this.nanotraceGroup, 133120);
        this.startAddress.setLayoutData((Object)gridData8);
        this.startAddress.addModifyListener((ModifyListener)this);
        this.detectButton = new Button((Composite)this.nanotraceGroup, 0);
        this.detectButton.setLayoutData((Object)new GridData());
        this.detectButton.setText(Messages.TraceSettingsComposite_46);
        this.detectButton.setToolTipText(Messages.TraceSettingsComposite_47);
        this.detectButton.addSelectionListener((SelectionListener)this);
        Label label5 = new Label((Composite)this.nanotraceGroup, 0);
        label5.setLayoutData((Object)new GridData());
        label5.setText(Messages.TraceSettingsComposite_18);
        label5.setToolTipText(Messages.TraceSettingsComposite_19);
        GridData gridData9 = new GridData(4, 0x1000000, false, false);
        gridData9.widthHint = 50;
        this.bufferSize = new Text((Composite)this.nanotraceGroup, 133120);
        this.bufferSize.setLayoutData((Object)gridData9);
        this.bufferSize.addModifyListener((ModifyListener)this);
        Label bytesLabel = new Label((Composite)this.nanotraceGroup, 0);
        bytesLabel.setLayoutData((Object)new GridData());
        bytesLabel.setText(Messages.TraceSettingsComposite_48);
    }

    private void createTraceMethod() {
        Group composite = new Group((Composite)this, 0);
        composite.setText(Messages.TraceSettingsComposite_49);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.enableTrace = new Button((Composite)composite, 32);
        this.enableTrace.setText(Messages.TraceSettingsComposite_1);
        this.enableTrace.addSelectionListener((SelectionListener)this);
        this.enableOwnershipTrace = new Button((Composite)composite, 32);
        this.enableOwnershipTrace.setText(Messages.TraceSettingsComposite_3);
        this.enableOwnershipTrace.addSelectionListener((SelectionListener)this);
        Label label3 = new Label((Composite)composite, 0);
        label3.setText(Messages.TraceSettingsComposite_2);
        this.traceMethod = new Combo((Composite)composite, 8);
        GridData gd_traceMethod = new GridData(4, 0x1000000, false, false);
        gd_traceMethod.minimumWidth = 200;
        this.traceMethod.setLayoutData((Object)gd_traceMethod);
        this.traceMethod.setToolTipText(Messages.TraceSettingsComposite_9);
        this.traceMethod.add(Messages.TraceSettingsComposite_10);
        this.traceMethod.add(Messages.TraceSettingsComposite_11);
        this.traceMethod.add(Messages.TraceSettingsComposite_StreamingAUXTraceOption);
        this.traceMethod.setText(Messages.TraceSettingsComposite_12);
        this.traceMethod.addSelectionListener((SelectionListener)this);
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.createTraceMethod();
        this.createAuxiliaryTraceGroup();
        this.createDataTraceGroup();
        this.createNanoTraceGroup();
        this.createBufferFullGroup();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.enableTrace.setSelection(configuration.getAttribute("AVR32_ATTR_ENABLE_TRACE", false));
            switch (AVR32DebugPlugin.TraceMethod.valueOf((String)configuration.getAttribute("AVR32_TRACE_METHOD", AVR32DebugPlugin.TraceMethod.NANO_TRACE.toString()))) {
                case NANO_TRACE: {
                    this.traceMethod.select(0);
                    break;
                }
                case AUX_TRACE: {
                    this.traceMethod.select(1);
                    break;
                }
                case STREAMING_AUX_TRACE: {
                    this.traceMethod.select(2);
                }
            }
            this.enableOwnershipTrace.setSelection(configuration.getAttribute("AVR32_ATTR_OWNERSHIP_TRACE", false));
            this.enableNTAP.setSelection(configuration.getAttribute("AVR32_ATTR_ENABLE_NTAP", false));
            this.useNanotraceVariableButton.setSelection(configuration.getAttribute("AVR32_ATTR_DETECT_BUFFER", false));
            this.specifySizeAndButton.setSelection(configuration.getAttribute("AVR32_ATTR_BUFFER_SPECIFIED", true));
            this.startAddress.setText(configuration.getAttribute("AVR32_ATTR_BUFFER_START", HEX_ZERO));
            this.bufferSize.setText(configuration.getAttribute("AVR32_ATTR_BUFFER_SIZE", "32"));
            this.overrideNexusInterface.setSelection(configuration.getAttribute("AVR32_AUX_PORT_OVERRIDE", false));
            this.nexusInterfaceCombo.select(configuration.getAttribute("AVR32_AUX_PORT_CONFIGURATION", 0));
            this.startAddress.setEnabled(this.specifySizeAndButton.getSelection());
            this.bufferSize.setEnabled(this.specifySizeAndButton.getSelection());
            switch (AVR32DebugPlugin.TraceBufferControl.valueOf((String)configuration.getAttribute("AVR32_ATTR_BUFFER_ACTION", AVR32DebugPlugin.TraceBufferControl.DISABLE_TRACE.toString()))) {
                case DISABLE_TRACE: {
                    this.disableTrace.setSelection(true);
                    break;
                }
                case ENTER_DEBUG_MODE: {
                    this.enterDebugMode.setSelection(true);
                    break;
                }
                case OVERWRITE_BUFFER: {
                    this.overwriteBuffer.setSelection(true);
                    break;
                }
                case READOUT_AND_CONTINUE: {
                    this.readAndContinue.setSelection(true);
                }
            }
            int x = 0;
            while (x < ACCESS_TYPES.length) {
                if (configuration.getAttribute("AVR32_ATTR_RANGE1_ACCESS", DEFAULT_ACCESS_TYPE).equals(ACCESS_TYPES[x])) {
                    this.channel_1_type.select(x);
                }
                if (configuration.getAttribute("AVR32_ATTR_RANGE2_ACCESS", DEFAULT_ACCESS_TYPE).equals(ACCESS_TYPES[x])) {
                    this.channel_2_type.select(x);
                }
                ++x;
            }
            this.channel_1_lb_text.setText(configuration.getAttribute("AVR32_ATTR_RANGE1_LB", HEX_ZERO));
            this.channel_1_ub_text.setText(configuration.getAttribute("AVR32_ATTR_RANGE1_UB", HEX_ZERO));
            this.channel_2_lb_text.setText(configuration.getAttribute("AVR32_ATTR_RANGE2_LB", HEX_ZERO));
            this.channel_2_ub_text.setText(configuration.getAttribute("AVR32_ATTR_RANGE2_UB", HEX_ZERO));
            this.bufferSizeCombo.setText(configuration.getAttribute("AVR32_ATTR_DEBUGGER_BUFFER_SIZE", EMULATOR_BUFFER_SIZE));
            this.updateWidgets();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.updateWidgets();
        if (e.widget.equals(this.startAddress) && this.startAddress.getText().length() == 0) {
            this.startAddress.setText(HEX_ZERO);
        }
        if (e.widget.equals(this.channel_1_lb_text) && this.channel_1_lb_text.getText().length() == 0) {
            this.channel_1_lb_text.setText(HEX_ZERO);
        }
        if (e.widget.equals(this.channel_1_ub_text) && this.channel_1_ub_text.getText().length() == 0) {
            this.channel_1_ub_text.setText(HEX_ZERO);
        }
        if (e.widget.equals(this.channel_2_lb_text) && this.channel_2_lb_text.getText().length() == 0) {
            this.channel_2_lb_text.setText(HEX_ZERO);
        }
        if (e.widget.equals(this.channel_2_ub_text) && this.channel_2_ub_text.getText().length() == 0) {
            this.channel_2_ub_text.setText(HEX_ZERO);
        }
        this.page.updateConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("AVR32_ATTR_ENABLE_TRACE", this.enableTrace.getSelection());
        switch (this.traceMethod.getSelectionIndex()) {
            case 0: {
                configuration.setAttribute("AVR32_TRACE_METHOD", AVR32DebugPlugin.TraceMethod.NANO_TRACE.toString());
                break;
            }
            case 1: {
                configuration.setAttribute("AVR32_TRACE_METHOD", AVR32DebugPlugin.TraceMethod.AUX_TRACE.toString());
                break;
            }
            case 2: {
                configuration.setAttribute("AVR32_TRACE_METHOD", AVR32DebugPlugin.TraceMethod.STREAMING_AUX_TRACE.toString());
            }
        }
        configuration.setAttribute("AVR32_ATTR_OWNERSHIP_TRACE", this.enableOwnershipTrace.getSelection());
        configuration.setAttribute("AVR32_ATTR_ENABLE_NTAP", this.enableNTAP.getSelection());
        configuration.setAttribute("AVR32_ATTR_DETECT_BUFFER", this.useNanotraceVariableButton.getSelection());
        configuration.setAttribute("AVR32_ATTR_BUFFER_SPECIFIED", this.specifySizeAndButton.getSelection());
        configuration.setAttribute("AVR32_ATTR_BUFFER_START", this.startAddress.getText());
        configuration.setAttribute("AVR32_ATTR_BUFFER_SIZE", this.bufferSize.getText());
        if (this.readAndContinue.getSelection()) {
            configuration.setAttribute("AVR32_ATTR_BUFFER_ACTION", AVR32DebugPlugin.TraceBufferControl.READOUT_AND_CONTINUE.toString());
        }
        if (this.enterDebugMode.getSelection()) {
            configuration.setAttribute("AVR32_ATTR_BUFFER_ACTION", AVR32DebugPlugin.TraceBufferControl.ENTER_DEBUG_MODE.toString());
        }
        if (this.overwriteBuffer.getSelection()) {
            configuration.setAttribute("AVR32_ATTR_BUFFER_ACTION", AVR32DebugPlugin.TraceBufferControl.OVERWRITE_BUFFER.toString());
        }
        if (this.disableTrace.getSelection()) {
            configuration.setAttribute("AVR32_ATTR_BUFFER_ACTION", AVR32DebugPlugin.TraceBufferControl.DISABLE_TRACE.toString());
        }
        configuration.setAttribute("AVR32_ATTR_RANGE1_LB", this.channel_1_lb_text.getText());
        configuration.setAttribute("AVR32_ATTR_RANGE1_UB", this.channel_1_ub_text.getText());
        configuration.setAttribute("AVR32_ATTR_RANGE1_ACCESS", ACCESS_TYPES[this.channel_1_type.getSelectionIndex()]);
        configuration.setAttribute("AVR32_ATTR_RANGE2_LB", this.channel_2_lb_text.getText());
        configuration.setAttribute("AVR32_ATTR_RANGE2_UB", this.channel_2_ub_text.getText());
        configuration.setAttribute("AVR32_ATTR_RANGE2_ACCESS", ACCESS_TYPES[this.channel_2_type.getSelectionIndex()]);
        configuration.setAttribute("AVR32_ATTR_DEBUGGER_BUFFER_SIZE", this.bufferSizeCombo.getText());
        configuration.setAttribute("AVR32_AUX_PORT_OVERRIDE", this.overrideNexusInterface.getSelection());
        configuration.setAttribute("AVR32_AUX_PORT_CONFIGURATION", this.nexusInterfaceCombo.getSelectionIndex());
    }

    private String select() {
        AVR32NM.AddressNamePair selected = this.browse();
        if (selected != null) {
            return HEX_PREFIX + Long.toHexString(selected.address);
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void setEnabled(Composite group, boolean enabled) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
        group.setEnabled(enabled);
    }

    public void setFile(IResource resource) {
        this.resource = resource;
    }

    public void setTraceEnablement(EnumSet<AVR32DebugPlugin.TraceMethod> enablement) {
        this.traceMethods = enablement;
        this.updateWidgets();
    }

    public void setPart(Part part) {
        this.part = part;
        this.updateWidgets();
        this.nexusInterfaceCombo.removeModifyListener((ModifyListener)this);
        this.nexusInterfaceCombo.removeAll();
        String[] stringArray = part.getDebugSystem().getAuxiliaryPortValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.nexusInterfaceCombo.add(s);
            ++n2;
        }
        this.nexusInterfaceCombo.addModifyListener((ModifyListener)this);
    }

    private void updateWidgets() {
        this.page.error(null);
        if (this.enableTrace.getSelection()) {
            if (this.traceMethods.isEmpty()) {
                this.page.error(Messages.TraceSettingsComposite_23);
                this.enableOwnershipTrace.setEnabled(false);
                this.traceMethod.setEnabled(false);
                this.setEnabled((Composite)this.nanotraceGroup, false);
                this.setEnabled((Composite)this.bufferFullGroup, false);
                this.setEnabled((Composite)this.dataTraceOptionsGroup, false);
                return;
            }
            this.setEnabled((Composite)this.dataTraceOptionsGroup, true);
            this.setEnabled((Composite)this.bufferFullGroup, true);
            this.enableOwnershipTrace.setEnabled(true);
            this.traceMethod.setEnabled(true);
            switch (this.traceMethod.getSelectionIndex()) {
                case 0: {
                    this.handleNanoTraceSelected();
                    break;
                }
                case 1: {
                    this.handleBufferedAUXTraceSelected();
                    this.updateAUXInterfaceSelection();
                    break;
                }
                case 2: {
                    this.handleStreamingAUXTraceSelected();
                    this.updateAUXInterfaceSelection();
                }
            }
            try {
                long size = BytePrefixParser.getInt((String)this.bufferSizeCombo.getText());
                if (size < 12288L) {
                    this.page.error(Messages.TraceSettingsComposite_Error_4);
                }
                if (size > 0x8000000L) {
                    this.page.error(Messages.TraceSettingsComposite_Error_5);
                }
                if ((float)Math.round(size / 2048L) != (float)size / 2048.0f) {
                    this.page.error(Messages.TraceSettingsComposite_Error_6);
                }
            }
            catch (Exception exception) {}
            try {
                long a2ub;
                long a2lb;
                long a1ub;
                long a1lb = Long.decode(this.channel_1_lb_text.getText());
                if (a1lb < 0L || a1lb > 0xFFFFFFFFL) {
                    this.page.error(Messages.TraceSettingsComposite_InvalidBoundaryAddress);
                }
                if ((a1ub = Long.decode(this.channel_1_ub_text.getText()).longValue()) < 0L || a1ub > 0xFFFFFFFFL) {
                    this.page.error(Messages.TraceSettingsComposite_InvalidBoundaryAddress);
                }
                if ((a2lb = Long.decode(this.channel_2_lb_text.getText()).longValue()) < 0L || a2lb > 0xFFFFFFFFL) {
                    this.page.error(Messages.TraceSettingsComposite_InvalidBoundaryAddress);
                }
                if ((a2ub = Long.decode(this.channel_2_ub_text.getText()).longValue()) < 0L || a2ub > 0xFFFFFFFFL) {
                    this.page.error(Messages.TraceSettingsComposite_InvalidBoundaryAddress);
                }
            }
            catch (Exception exception) {
                this.page.error(Messages.TraceSettingsComposite_InvalidBoundaryNumber);
            }
        } else {
            this.enableOwnershipTrace.setEnabled(false);
            this.traceMethod.setEnabled(false);
            this.setEnabled((Composite)this.nanotraceGroup, false);
            this.setEnabled((Composite)this.bufferFullGroup, false);
            this.setEnabled((Composite)this.dataTraceOptionsGroup, false);
            return;
        }
    }

    private void handleStreamingAUXTraceSelected() {
        this.setEnabled((Composite)this.auxiliaryTraceGroup, true);
        this.setEnabled((Composite)this.nanotraceGroup, false);
        this.overwriteBuffer.setEnabled(false);
        if (this.overwriteBuffer.getSelection()) {
            this.page.error(Messages.TraceSettingsComposite_27);
        }
        if (!this.traceMethods.contains(AVR32DebugPlugin.TraceMethod.STREAMING_AUX_TRACE)) {
            this.page.error(Messages.TraceSettingsComposite_Error_3);
        }
    }

    private void handleBufferedAUXTraceSelected() {
        this.setEnabled((Composite)this.auxiliaryTraceGroup, true);
        this.setEnabled((Composite)this.nanotraceGroup, false);
        this.overwriteBuffer.setEnabled(true);
        if (!this.traceMethods.contains(AVR32DebugPlugin.TraceMethod.AUX_TRACE)) {
            this.page.error(Messages.TraceSettingsComposite_25);
        }
    }

    private void updateAUXInterfaceSelection() {
        this.overrideNexusInterface.setEnabled(this.part.getDebugSystem().isAuxiliaryPortOverrideSupported() && this.auxiliaryTraceGroup.isEnabled());
        this.nexusInterfaceCombo.setEnabled(this.overrideNexusInterface.getSelection());
        this.nexusInterfaceLabel.setEnabled(this.overrideNexusInterface.getSelection());
    }

    private void handleNanoTraceSelected() {
        this.setEnabled((Composite)this.auxiliaryTraceGroup, false);
        this.setEnabled((Composite)this.nanotraceGroup, true);
        this.overwriteBuffer.setEnabled(true);
        this.startAddress.setEnabled(this.specifySizeAndButton.getSelection());
        this.bufferSize.setEnabled(this.specifySizeAndButton.getSelection());
        if (this.useNanotraceVariableButton.getSelection()) {
            try {
                AVR32NM nm = new AVR32NM(this.resource.getLocation().toOSString());
                AVR32NM.AddressNamePair[] pairs = nm.getBSSSymbols();
                boolean found = false;
                AVR32NM.AddressNamePair[] addressNamePairArray = pairs;
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    AVR32NM.AddressNamePair addressNamePair = addressNamePairArray[n2];
                    if (addressNamePair.name.equals(NANOTRACE_ADDRESS_NAME)) {
                        found = true;
                        int nano = (int)addressNamePair.size;
                        if (!this.isPowerOf2(nano)) {
                            this.page.error(Messages.TraceSettingsComposite_Error_1);
                        }
                    }
                    ++n2;
                }
                if (!found) {
                    this.page.error(Messages.TraceSettingsComposite_Error_2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.traceMethods.contains(AVR32DebugPlugin.TraceMethod.NANO_TRACE)) {
            this.page.error(Messages.TraceSettingsComposite_24);
        }
        if (this.enableNTAP.getSelection()) {
            if (!this.part.getDebugSystem().isNTAPSupported()) {
                this.page.error(MessageFormat.format(Messages.TraceSettingsComposite_51, this.part.getName()));
            }
            if (this.useNanotraceVariableButton.getSelection()) {
                this.page.error(MessageFormat.format(Messages.TraceSettingsComposite_50, new Object[0]));
                this.useNanotraceVariableButton.setEnabled(false);
            }
        }
        try {
            int nano = Integer.decode(this.bufferSize.getText());
            if (!this.isPowerOf2(nano)) {
                this.page.error(Messages.TraceSettingsComposite_Error_7);
            }
            if (nano < 32) {
                this.page.error(Messages.TraceSettingsComposite_Error_8);
            }
        }
        catch (Exception exception) {
            this.page.error(Messages.TraceSettingsComposite_Error_9);
        }
    }

    boolean isPowerOf2(int n) {
        return (n & n - 1) == 0 || n == 0;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateWidgets();
        this.page.updateConfigurationDialog();
    }

    public void widgetSelected(SelectionEvent e) {
        String selected;
        if (e.widget.equals(this.channel_1_lb_prompt) && (selected = this.select()) != null) {
            this.channel_1_lb_text.setText(selected);
        }
        if (e.widget.equals(this.channel_1_ub_prompt) && (selected = this.select()) != null) {
            this.channel_1_ub_text.setText(selected);
        }
        if (e.widget.equals(this.channel_2_lb_prompt) && (selected = this.select()) != null) {
            this.channel_2_lb_text.setText(selected);
        }
        if (e.widget.equals(this.channel_2_ub_prompt) && (selected = this.select()) != null) {
            this.channel_2_ub_text.setText(selected);
        }
        if (e.widget.equals(this.detectButton)) {
            try {
                AVR32NM nm = new AVR32NM(this.resource.getLocation().toOSString());
                this.startAddress.setText(HEX_PREFIX + Long.toHexString(nm.getStackStart() - 1024L));
                this.bufferSize.setText(DEFAULT_NANOTRACE_LENGTH);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        this.updateWidgets();
        this.page.updateConfigurationDialog();
    }
}

