/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.data.ProgramTraceFrame;
import com.atmel.avr32.debug.trace.ui.internal.Messages;
import com.atmel.avr32.debug.ui.AVR32DebugUIPlugin;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class TraceFrameDoubleClickListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        Object o;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ProgramTraceFrame) {
            ProgramTraceFrame data = (ProgramTraceFrame)o;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            Path path = new Path(data.getFile());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file != null && file.exists()) {
                try {
                    IDocument document;
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    if (editor instanceof ITextEditor && (document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null) {
                        int offset = document.getLineOffset(data.getStart() - 1);
                        int length = document.getLineOffset(data.getStart() - 1 + data.getLines()) - offset;
                        ((ITextEditor)editor).selectAndReveal(offset, length);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else {
                AVR32DebugUIPlugin.messageDialog((IStatus)new Status(4, "com.atmel.avr32.debug.trace", MessageFormat.format(Messages.TraceFrameDoubleClickListener_CannotOpen, path)));
            }
        }
    }
}

