/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.ui.internal.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class TraceDataViewer
extends TableViewer {
    private static final int MAX_SELECTION = 500;
    private static final String EMPTY_STRING = "";
    private IStatusLineManager fStatusLineManager;
    private boolean fLimit;
    private static final int CACHE_SIZE = 50;
    private static int cacheCount;

    public TraceDataViewer(IStatusLineManager manager, Composite parent, int style, boolean limit) {
        super(parent, style);
        this.fStatusLineManager = manager;
        this.fLimit = limit;
        this.getTable().addListener(36, new Listener(){

            public void handleEvent(Event e) {
                TraceDataViewer.this.checkCache(TraceDataViewer.this.getTable());
            }
        });
    }

    protected int[] doGetSelectionIndices() {
        int[] indices = super.doGetSelectionIndices();
        if (this.fLimit) {
            int[] result = new int[]{};
            if (indices.length > 500) {
                Point p = this.getTopBottom();
                result = new int[p.y - p.x];
                int i = 0;
                while (i < p.y - p.x) {
                    result[i] = p.x + i;
                    ++i;
                }
                result = new int[]{};
                this.setSelection((ISelection)StructuredSelection.EMPTY);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid selection", (String)MessageFormat.format(Messages.TraceDataViewer_ReducedSelection, new Integer(500)));
            } else {
                result = indices;
            }
            return result;
        }
        return indices;
    }

    private void checkCache(Table table) {
        if (cacheCount++ < 50) {
            return;
        }
        cacheCount = 0;
        Point p = this.getTopBottom();
        if (p.x != 0) {
            table.clear(0, p.x - 1);
        }
        if (p.y != table.getItemCount()) {
            table.clear(p.y, table.getItemCount() - 1);
        }
    }

    private Point getTopBottom() {
        Rectangle clientRect = this.getTable().getClientArea();
        int topIndex = this.getTable().getTopIndex();
        int bottomIndex = topIndex + 1;
        while (bottomIndex < this.getTable().getItemCount()) {
            Rectangle itemRect = this.getTable().getItem(bottomIndex).getBounds();
            if (itemRect.y > clientRect.y + clientRect.height) break;
            ++bottomIndex;
        }
        return new Point(topIndex, bottomIndex);
    }
}

