/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.client.ITraceEventListener;
import com.atmel.avr32.debug.trace.client.TraceClient;
import com.atmel.avr32.debug.trace.client.TraceEvent;
import com.atmel.avr32.debug.trace.client.TraceException;
import com.atmel.avr32.debug.trace.data.ITraceFrame;
import com.atmel.avr32.debug.trace.ui.internal.Messages;
import com.atmel.avr32.debug.ui.AVR32DebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class TraceDataTableContentProvider
implements ILazyContentProvider,
ITraceEventListener {
    static final String BUSY_CURSOR = "SWT BusyIndicator Cursor";
    static final String BUSYID_NAME = "SWT BusyIndicator";
    static int nextBusyId = 1;
    private ITraceFrame cached;
    private final DataAvailableUpdater fAvailableUpdater = new DataAvailableUpdater();
    private final DataUpdater fDataUpdater = new DataUpdater();
    private TraceClient fSession;
    private TableViewer viewer;

    public void dispose() {
    }

    private Display getDisplay() {
        return this.viewer.getControl().getDisplay();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TableViewer) {
            this.viewer = (TableViewer)viewer;
        }
        if (oldInput instanceof TraceClient) {
            ((TraceClient)oldInput).removeTraceEventListener((ITraceEventListener)this);
        }
        if (newInput instanceof TraceClient) {
            ((TraceClient)newInput).addTraceEventListener((ITraceEventListener)this);
            this.fSession = (TraceClient)newInput;
            this.fAvailableUpdater.update(this.fSession.getDataLength());
        } else {
            this.fSession = null;
        }
    }

    public void traceEvent(TraceEvent event) {
        if (event.getType() == TraceEvent.EventType.CLIENT_DISCONNECTED) {
            this.fAvailableUpdater.update(event.getLength());
            if (this.fSession != null) {
                this.fSession.removeTraceEventListener((ITraceEventListener)this);
            }
        }
        if (event.getType() == TraceEvent.EventType.DATA_AVAILABLE) {
            this.fAvailableUpdater.update(event.getLength());
        }
        if (event.getType() == TraceEvent.EventType.BUFFER_CLEARED) {
            this.fAvailableUpdater.update(event.getLength());
        }
    }

    public void updateElement(int index) {
        this.fDataUpdater.update(index);
    }

    static /* synthetic */ Display access$1(TraceDataTableContentProvider traceDataTableContentProvider) {
        return traceDataTableContentProvider.getDisplay();
    }

    private class DataAvailableUpdater
    implements Runnable {
        private int count;
        private int previousCount;

        private DataAvailableUpdater() {
        }

        @Override
        public void run() {
            if (this.count < this.previousCount) {
                this.runWithBusy();
            } else {
                TraceDataTableContentProvider.this.viewer.setItemCount(this.count);
            }
            this.previousCount = this.count;
        }

        /*
         * Unable to fully structure code
         */
        private void runWithBusy() {
            display = TraceDataTableContentProvider.access$1(TraceDataTableContentProvider.this);
            cursor = display.getSystemCursor(1);
            busyId = new Integer(TraceDataTableContentProvider.nextBusyId);
            ++TraceDataTableContentProvider.nextBusyId;
            shells = display.getShells();
            i = 0;
            while (i < shells.length) {
                id = (Integer)shells[i].getData("SWT BusyIndicator");
                if (id == null) {
                    shells[i].setCursor(cursor);
                    shells[i].setData("SWT BusyIndicator", (Object)busyId);
                }
                ++i;
            }
            try {
                TraceDataTableContentProvider.access$0(TraceDataTableContentProvider.this).setItemCount(this.count);
            }
            finally {
                shells = display.getShells();
                i = 0;
                ** while (i < shells.length)
            }
lbl-1000:
            // 1 sources

            {
                id = (Integer)shells[i].getData("SWT BusyIndicator");
                if (id == busyId) {
                    shells[i].setCursor(null);
                    shells[i].setData("SWT BusyIndicator", null);
                }
                ++i;
                continue;
            }
lbl27:
            // 1 sources

        }

        public void update(int count) {
            this.count = count;
            TraceDataTableContentProvider.this.viewer.getControl().getDisplay().syncExec((Runnable)this);
        }
    }

    private class DataUpdater
    implements Runnable {
        private int index;

        private DataUpdater() {
        }

        @Override
        public void run() {
            if (TraceDataTableContentProvider.this.fSession != null && TraceDataTableContentProvider.this.fSession.isConnected()) {
                if (TraceDataTableContentProvider.this.cached == null || TraceDataTableContentProvider.this.cached.getSequenceNumber() != this.index) {
                    try {
                        TraceDataTableContentProvider.this.cached = TraceDataTableContentProvider.this.fSession.getData(this.index);
                    }
                    catch (TraceException e) {
                        AVR32DebugUIPlugin.messageDialog((IStatus)new Status(4, "com.atmel.avr32.debug.trace.ui", Messages.TraceDataTableContentProvider_NoDataError, (Throwable)e));
                        e.printStackTrace();
                    }
                }
                TraceDataTableContentProvider.this.viewer.replace((Object)TraceDataTableContentProvider.this.cached, this.index);
            } else if (!TraceDataTableContentProvider.this.viewer.isBusy()) {
                TraceDataTableContentProvider.this.viewer.replace((Object)Messages.TraceDataTableContentProvider_Disconnected, this.index);
            }
        }

        public void update(int index) {
            this.index = index;
            TraceDataTableContentProvider.this.viewer.getControl().getDisplay().syncExec((Runnable)this);
        }
    }
}

