/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import com.atmel.avr32.debug.trace.data.DataTraceFrame;
import com.atmel.avr32.debug.trace.data.DebugStatusFrame;
import com.atmel.avr32.debug.trace.data.ErrorFrame;
import com.atmel.avr32.debug.trace.data.NoSyncFrame;
import com.atmel.avr32.debug.trace.data.OwnershipTraceFrame;
import com.atmel.avr32.debug.trace.data.ProgramTraceFrame;
import com.atmel.avr32.debug.trace.data.TraceOffFrame;
import com.atmel.avr32.debug.trace.data.TraceOnFrame;
import com.atmel.avr32.debug.trace.data.TraceWatchpointHitFrame;
import com.atmel.avr32.debug.trace.data.TracepointHitFrame;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;

public class TraceColumnLabelProvider
extends ColumnLabelProvider
implements IPropertyChangeListener {
    private TableViewer tableViewer;
    private static final String COLOR_DATA = "com.atmel.avr32.debug.trace.color.data";
    private static final String COLOR_DEBS = "com.atmel.avr32.debug.trace.color.debs";
    private static final String COLOR_ERROR = "com.atmel.avr32.debug.trace.color.error";
    private static final String COLOR_HIT = "com.atmel.avr32.debug.trace.color.hit";
    private static final String COLOR_OWNERSHIP = "com.atmel.avr32.debug.trace.color.ownership";
    private static final String COLOR_PROGRAM_CALL = "com.atmel.avr32.debug.trace.color.program.call";
    private static final String COLOR_PROGRAM_DIRECT = "com.atmel.avr32.debug.trace.color.program.direct";
    private static final String COLOR_PROGRAM_EXCEPTION = "com.atmel.avr32.debug.trace.color.program.exception";
    private static final String COLOR_PROGRAM_PC_MODIFIED = "com.atmel.avr32.debug.trace.color.program.pc_modified";
    private static final String COLOR_PROGRAM_RETURN = "com.atmel.avr32.debug.trace.color.program.return";
    private static final String COLOR_BOUNDARY = "com.atmel.avr32.debug.trace.color.boundary";
    private static final String FONT_TEXT = "com.atmel.avr32.debug.trace.font.text";
    private final ColorRegistry cr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
    private final FontRegistry fr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();

    public TraceColumnLabelProvider() {
    }

    public TraceColumnLabelProvider(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.fr.addListener((IPropertyChangeListener)this);
        this.cr.addListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.fr.removeListener((IPropertyChangeListener)this);
        this.cr.removeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public Color getBackground(Object element) {
        if (element instanceof DataTraceFrame) {
            return this.cr.get(COLOR_DATA);
        }
        if (element instanceof OwnershipTraceFrame) {
            return this.cr.get(COLOR_OWNERSHIP);
        }
        if (element instanceof ProgramTraceFrame) {
            ProgramTraceFrame td = (ProgramTraceFrame)element;
            switch (td.getBranch()) {
                case CALL: {
                    return this.cr.get(COLOR_PROGRAM_CALL);
                }
                case DIRECT_BRANCH: {
                    return this.cr.get(COLOR_PROGRAM_DIRECT);
                }
                case EXCEPTION: {
                    return this.cr.get(COLOR_PROGRAM_EXCEPTION);
                }
                case PC_MODIFIED: {
                    return this.cr.get(COLOR_PROGRAM_PC_MODIFIED);
                }
                case RETURN: {
                    return this.cr.get(COLOR_PROGRAM_RETURN);
                }
            }
        }
        if (element instanceof ErrorFrame) {
            return this.cr.get(COLOR_ERROR);
        }
        if (element instanceof DebugStatusFrame) {
            return this.cr.get(COLOR_DEBS);
        }
        if (element instanceof TraceWatchpointHitFrame) {
            return this.cr.get(COLOR_HIT);
        }
        if (element instanceof TracepointHitFrame) {
            return this.cr.get(COLOR_HIT);
        }
        if (element instanceof TraceOnFrame) {
            return this.cr.get(COLOR_BOUNDARY);
        }
        if (element instanceof TraceOffFrame) {
            return this.cr.get(COLOR_BOUNDARY);
        }
        if (element instanceof NoSyncFrame) {
            return this.cr.get(COLOR_BOUNDARY);
        }
        return null;
    }

    public Font getFont(Object element) {
        return this.fr.get(FONT_TEXT);
    }

    private void updateViewer() {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                TraceColumnLabelProvider.this.tableViewer.refresh();
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(update);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("com.atmel.avr32.debug.trace.")) {
            this.updateViewer();
        }
    }
}

