/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui.internal;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.ui.IncludesGrouping;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CModelContentProvider
implements ITreeContentProvider {
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;
    protected boolean fIncludesGrouping = false;
    protected boolean fNamespacesGrouping = false;
    protected boolean fIncludesFunctions = false;
    protected static final Object[] NO_CHILDREN = new Object[0];

    public CModelContentProvider(boolean functions) {
        this.fIncludesFunctions = functions;
    }

    public Object[] getChildren(Object element) {
        try {
            if (element instanceof IResource) {
                ICElement[] children;
                ICElement ast = CoreModel.getDefault().create((IFile)element);
                ITranslationUnit trUnit = (ITranslationUnit)ast;
                ArrayList<ICElement> list = new ArrayList<ICElement>();
                ICElement[] iCElementArray = children = trUnit.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement element2 = iCElementArray[n2];
                    if (this.fIncludesFunctions && element2 instanceof IFunctionDeclaration) {
                        list.add(element2);
                    }
                    if (!this.fIncludesFunctions && element2 instanceof IVariableDeclaration) {
                        list.add(element2);
                    }
                    ++n2;
                }
                return list.toArray();
            }
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    public boolean hasChildren(Object element) {
        if (this.fProvideMembers) {
            if (element instanceof IBinary || element instanceof ITranslationUnit || element instanceof IArchive) {
                return true;
            }
        } else if (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive || element instanceof IFile) {
            return false;
        }
        if (element instanceof ICProject) {
            ICProject cp = (ICProject)element;
            return cp.getProject().isOpen();
        }
        if (element instanceof IParent && ((IParent)element).hasChildren()) {
            return true;
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        viewer.refresh();
    }

    public Object internalGetParent(Object element) {
        IResource res;
        if (element instanceof IResource) {
            ICElement cParent;
            IContainer parent = ((IResource)element).getParent();
            if (parent != null && parent.isAccessible() && (cParent = CoreModel.getDefault().create((IResource)parent)) != null && cParent.exists()) {
                return cParent;
            }
            return parent;
        }
        Object parent = null;
        if (element instanceof ICElement) {
            parent = ((ICElement)element).getParent();
        } else if (element instanceof IWorkbenchAdapter) {
            parent = ((IWorkbenchAdapter)element).getParent(element);
        }
        if ((parent instanceof IBinaryContainer || parent instanceof IArchiveContainer) && element instanceof ICElement && (res = ((ICElement)element).getResource()) != null) {
            parent = this.internalGetParent(res);
        }
        if (element instanceof IInclude && this.fIncludesGrouping) {
            parent = new IncludesGrouping(((IInclude)element).getTranslationUnit());
        }
        return parent;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).exists();
        }
        return true;
    }
}

