/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui;

import com.atmel.avr32.debug.trace.Tracepoint;
import com.atmel.avr32.debug.trace.ui.TraceUIPlugin;
import org.eclipse.cdt.debug.internal.ui.CDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class DebugModelPresentation
extends CDebugModelPresentation {
    private static DebugModelPresentation gfInstance = null;

    public static DebugModelPresentation getDefault() {
        if (gfInstance == null) {
            gfInstance = new DebugModelPresentation();
        }
        return gfInstance;
    }

    public IEditorInput getEditorInput(Object element) {
        Tracepoint b;
        IFile file;
        if (element instanceof Tracepoint && (file = (IFile)(b = (Tracepoint)element).getMarker().getResource().getAdapter(IFile.class)) != null) {
            return new FileEditorInput(file);
        }
        return super.getEditorInput(element);
    }

    private boolean isShowFullPath() {
        IPreferenceStore store = CDebugUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.debug.ui.BreakpointView." + ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS);
    }

    public String getText(Object element) {
        if (element instanceof Tracepoint) {
            return ((Tracepoint)element).getText(this.isShowFullPath());
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        IBreakpoint bp;
        if (element instanceof Tracepoint) {
            return this.getImage((Tracepoint)element);
        }
        if (element instanceof IMarker && (bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)element)) instanceof Tracepoint) {
            return this.getImage((Tracepoint)bp);
        }
        return super.getImage(element);
    }

    public Image getImage(Tracepoint watchpoint) {
        int flags = 0;
        try {
            if (!watchpoint.isEnabled()) {
                flags |= 1;
            }
            switch (watchpoint.getOperation()) {
                case START: {
                    flags |= 2;
                    break;
                }
                case STOP: {
                    flags |= 4;
                    break;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Image base = TraceUIPlugin.getDefault().getImageRegistry().get("IMAGE_TRACEPOINT_KEY");
        if (base == null) {
            return null;
        }
        OverlayedTracepointIcon icon = new OverlayedTracepointIcon(base, flags);
        return icon.createImage();
    }

    public static /* bridge */ /* synthetic */ CDebugModelPresentation getDefault() {
        return DebugModelPresentation.getDefault();
    }

    private class OverlayedTracepointIcon
    extends CompositeImageDescriptor {
        private static final int DISABLED = 1;
        private static final int START = 2;
        private static final int STOP = 4;
        private Image fBaseImage;
        private int fFlags;
        private Point fSize;

        public OverlayedTracepointIcon(Image baseImage, int flags) {
            this.setBaseImage(baseImage);
            this.setFlags(flags);
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData bg = this.getBaseImage().getImageData();
            if (bg == null) {
                bg = DEFAULT_IMAGE_DATA;
            }
            this.drawImage(bg, 0, 0);
            this.drawOverlays();
        }

        protected void drawOverlays() {
            int flags = this.getFlags();
            int x = 0;
            int y = 0;
            ImageRegistry registry = TraceUIPlugin.getDefault().getImageRegistry();
            ImageData data = null;
            if ((flags & 1) != 0) {
                x = 0;
                y = 0;
                data = registry.get("IMAGE_TRACEPOINT_DISABLED_KEY").getImageData();
                this.drawImage(data, x, y);
            }
            if ((flags & 2) != 0) {
                x = 0;
                y = 0;
                data = registry.get("IMAGE_TRACEPOINT_START_KEY").getImageData();
                this.drawImage(data, x, y);
            }
            if ((flags & 4) != 0) {
                x = 0;
                y = 0;
                data = registry.get("IMAGE_TRACEPOINT_STOP_KEY").getImageData();
                this.drawImage(data, x, y);
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof OverlayedTracepointIcon)) {
                return false;
            }
            OverlayedTracepointIcon other = (OverlayedTracepointIcon)((Object)object);
            return this.getBaseImage().equals((Object)other.getBaseImage()) && this.getFlags() == other.getFlags();
        }

        protected Image getBaseImage() {
            return this.fBaseImage;
        }

        protected int getFlags() {
            return this.fFlags;
        }

        protected Point getSize() {
            if (this.fSize == null) {
                ImageData data = this.getBaseImage().getImageData();
                this.setSize(new Point(data.width, data.height));
            }
            return this.fSize;
        }

        public int hashCode() {
            return this.getBaseImage().hashCode() | this.getFlags();
        }

        protected void setBaseImage(Image image) {
            this.fBaseImage = image;
        }

        protected void setFlags(int flags) {
            this.fFlags = flags;
        }

        protected void setSize(Point size) {
            this.fSize = size;
        }
    }
}

