/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.ui;

import com.atmel.avr32.debug.trace.AddressTracepoint;
import com.atmel.avr32.debug.trace.LineTracepoint;
import com.atmel.avr32.debug.trace.Tracepoint;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractTracepointHandler
extends AbstractHandler {
    private IWorkbenchPart fTargetPart;

    protected void setTargetPart(IWorkbenchPart part) {
        this.fTargetPart = part;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected int getLine() {
        if (this.fTargetPart instanceof EditorPart) {
            ISelection selection = ((EditorPart)this.fTargetPart).getEditorSite().getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                return ((ITextSelection)selection).getStartLine() + 1;
            }
            return -1;
        }
        return -1;
    }

    protected int getColumn() {
        if (this.fTargetPart instanceof EditorPart) {
            ISelection selection = ((EditorPart)this.fTargetPart).getEditorSite().getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                return ((ITextSelection)selection).getOffset();
            }
            return -1;
        }
        return -1;
    }

    protected int getOffset() {
        if (this.fTargetPart instanceof EditorPart) {
            ISelection selection = ((EditorPart)this.fTargetPart).getEditorSite().getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                return ((ITextSelection)selection).getOffset();
            }
            return -1;
        }
        return -1;
    }

    protected IAddress getAddress() {
        BreakpointLocationVerifier bv;
        int lineNumber;
        if (this.fTargetPart == null) {
            return null;
        }
        ISelection selection = this.fTargetPart.getSite().getSelectionProvider().getSelection();
        IEditorInput input = ((DisassemblyView)this.fTargetPart).getInput();
        if (input instanceof DisassemblyEditorInput && (lineNumber = (bv = new BreakpointLocationVerifier()).getValidAddressBreakpointLocation(null, ((ITextSelection)selection).getStartLine())) != -1) {
            return ((DisassemblyEditorInput)input).getAddress(lineNumber);
        }
        return null;
    }

    protected IVariable getModelElement(int offset) {
        try {
            ICElement[] elements = this.getElements();
            ISourceRange range = null;
            ICElement[] iCElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement element = iCElementArray[n2];
                switch (element.getElementType()) {
                    case 76: {
                        range = ((IVariable)element).getSourceRange();
                        if (offset < range.getIdStartPos() || offset > range.getIdStartPos() + range.getIdLength()) break;
                        return (IVariable)element;
                    }
                }
                ++n2;
            }
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Tracepoint determineTracepoint() {
        block10: {
            if (this.getResource() != null) break block10;
            return null;
        }
        try {
            if (this.fTargetPart instanceof EditorPart) {
                IMarker[] markers;
                int pos = this.getLine();
                int offset = this.getOffset();
                IMarker[] iMarkerArray = markers = this.getResource().findMarkers("com.atmel.avr32.debug.trace.LineTracepointMarker", true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp;
                    IMarker marker = iMarkerArray[n2];
                    int line = (Integer)marker.getAttribute("lineNumber");
                    int start = (Integer)marker.getAttribute("charStart");
                    int end = (Integer)marker.getAttribute("charEnd");
                    if ((line == pos || offset >= start && offset <= end) && (bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) != null && bp instanceof LineTracepoint) {
                        return (LineTracepoint)bp;
                    }
                    ++n2;
                }
            } else if (this.fTargetPart instanceof DisassemblyView) {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = this.getResource().findMarkers("com.atmel.avr32.debug.trace.AddressTracepointMarker", true, 2);
                int n = markers.length;
                int n3 = 0;
                while (n3 < n) {
                    IMarker marker = iMarkerArray[n3];
                    Addr32 address = new Addr32((String)marker.getAttribute("tracepoint.start.address"));
                    if (address.equals((Object)this.getAddress())) {
                        IBreakpoint bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
                        return (AddressTracepoint)bp;
                    }
                    ++n3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ICElement[] getElements() {
        ICElement cParent;
        IResource parent = this.getResource();
        if (parent != null && parent.isAccessible() && (cParent = CoreModel.getDefault().create(parent)) != null && cParent.exists()) {
            try {
                if (cParent instanceof IParent) {
                    return ((IParent)cParent).getChildren();
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        return new ICElement[0];
    }

    protected IResource getResource() {
        IFile[] files;
        Path path;
        IEditorInput input;
        String fileName;
        if (this.fTargetPart instanceof EditorPart) {
            IEditorInput input2 = ((EditorPart)this.fTargetPart).getEditorInput();
            IResource resource = (IResource)input2.getAdapter(IFile.class);
            if (resource == null) {
                resource = (IResource)input2.getAdapter(IResource.class);
            }
            return resource;
        }
        if (this.fTargetPart instanceof DisassemblyView && (fileName = ((DisassemblyEditorInput)(input = ((DisassemblyView)this.fTargetPart).getInput())).getSourceFile()) != null && (path = new Path(fileName)).isValidPath(fileName) && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path)).length > 0) {
            return files[0];
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

