/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.data;

import com.atmel.avr32.debug.trace.data.DefaultTraceFrame;
import com.atmel.avr32.debug.trace.data.Messages;

public class ProgramTraceFrame
extends DefaultTraceFrame {
    private static final String EMPTY_STRING = "";
    private static final char BACKSLASH = '\\';
    private static final char COLON = ':';
    private static final char SPACE = ' ';
    private final BranchType branch;
    private int lines;
    private int start;
    private String file;
    private String code;

    public ProgramTraceFrame(String input) {
        this.input = input;
        ParseContext ctx = this.parseFields(input, ' ', 3);
        this.sequence = ctx.fields[1];
        this.sequenceNumber = Integer.decode(this.sequence);
        this.branch = BranchType.valueOf(ctx.fields[2]);
        ctx = this.parseFields(ctx.remainingString.substring(1), ':', 92, 4);
        this.address = ctx.fields[0];
        this.file = ctx.fields[1];
        this.start = Integer.parseInt(ctx.fields[2]);
        ctx = this.parseFields(ctx.remainingString.substring(1), ':', 92, 4);
        int to = Integer.parseInt(ctx.fields[2]);
        this.text = ctx.remainingString.substring(1);
        this.lines = to - this.start + 1;
        this.code = EMPTY_STRING;
    }

    private ParseContext parseFields(String string, char separator, int numberOfFields) {
        return this.parseFields(string, separator, -1, numberOfFields);
    }

    private ParseContext parseFields(String string, char separator, int escapeChar, int numberOfFields) {
        ParseContext ctx = new ParseContext();
        ctx.fields = new String[numberOfFields];
        String field = new String();
        int fieldIndex = 0;
        boolean escaped = false;
        int i = 0;
        while (i < string.length()) {
            char chr = string.charAt(i);
            if (fieldIndex == numberOfFields - 1 && chr == ' ') {
                ctx.fields[fieldIndex] = field;
                break;
            }
            if (escapeChar != -1 && chr == escapeChar && i < string.length() - 1) {
                escaped = true;
            } else if (!escaped && chr == separator) {
                ctx.fields[fieldIndex] = field;
                if (++fieldIndex == numberOfFields) break;
                field = new String();
            } else {
                field = String.valueOf(field) + chr;
                escaped = false;
            }
            ++i;
        }
        ctx.remainingString = string.substring(i);
        return ctx;
    }

    public BranchType getBranch() {
        return this.branch;
    }

    public int getLines() {
        return this.lines;
    }

    public String getTooltip() {
        StringBuffer sb = new StringBuffer();
        switch (this.branch) {
            case CALL: {
                sb.append(Messages.getString("ProgramTraceFrame.CALL"));
                break;
            }
            case DIRECT_BRANCH: {
                sb.append(Messages.getString("ProgramTraceFrame.DIRECT_BRANCH"));
                break;
            }
            case EXCEPTION: {
                sb.append(Messages.getString("ProgramTraceFrame.EXCEPTION"));
                break;
            }
            case PC_MODIFIED: {
                sb.append(Messages.getString("ProgramTraceFrame.PC_MODIFIED"));
                break;
            }
            case RETURN: {
                sb.append(Messages.getString("ProgramTraceFrame.RETURN"));
                break;
            }
        }
        return sb.toString();
    }

    public String getPresentationString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTooltip());
        if (this.file.split("\\.\\./").length > 1) {
            sb.append(" into ");
            sb.append(this.file.split("\\.\\./")[1]);
            sb.append(" line ");
            sb.append(this.start);
        }
        return sb.toString();
    }

    public String getFile() {
        return this.file;
    }

    public int getStart() {
        return this.start;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static enum BranchType {
        CALL,
        RETURN,
        EXCEPTION,
        PC_MODIFIED,
        DIRECT_BRANCH;

    }

    class ParseContext {
        String remainingString;
        String[] fields;

        ParseContext() {
        }
    }
}

