/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.data;

import com.atmel.avr32.debug.trace.data.ITraceFrame;
import java.util.regex.Pattern;

public class DefaultTraceFrame
implements ITraceFrame {
    protected static final Pattern fSplitter = Pattern.compile(" ");
    protected String sequence;
    protected int sequenceNumber;
    protected String address = "";
    protected String text = "<unknown>";
    protected String input;

    public DefaultTraceFrame() {
    }

    public DefaultTraceFrame(String input) {
        this.input = input;
        String[] columns = fSplitter.split(input);
        if (columns.length > 1) {
            this.sequence = columns[1];
            this.sequenceNumber = Integer.decode(this.sequence);
        }
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public DefaultTraceFrame(String sequence, String code) {
        this.sequence = sequence;
        this.text = code;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.input;
    }
}

