/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.data;

import com.atmel.avr32.debug.trace.data.DefaultTraceFrame;

public class DataTraceFrame
extends DefaultTraceFrame {
    private static final char SPACE = ' ';
    private static final String LOAD = "ld.";
    private static final String STORE = "st.";
    private static final String WRITE = "Write";
    private boolean write;
    private int dsz;
    private String value;
    private String[] DSZ = new String[]{"b", "hw", "w", "dw"};

    public DataTraceFrame(String input) {
        this.input = input;
        String[] columns = fSplitter.split(input);
        this.sequence = columns[1];
        this.sequenceNumber = Integer.decode(this.sequence);
        this.dsz = Integer.decode(columns[2]);
        this.address = columns[3];
        this.value = columns[4];
        this.write = columns[5].equals(WRITE);
    }

    @Override
    public String getText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.write ? STORE : LOAD);
        sb.append(this.DSZ[this.dsz]);
        sb.append(' ');
        sb.append(this.value);
        return sb.toString();
    }

    public String getValue() {
        return this.value;
    }

    public boolean isWrite() {
        return this.write;
    }
}

