/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.client.commands;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TraceCommand {
    private static final String EMPTY_STRING = "";
    private static final char NEWLINE = '\n';
    private static final char ARGUMENT_SEPARATOR = ',';
    private static final char COMMAND_PREFIX = '$';
    private static final String HEX_PREFIX = "0x";
    private static final Pattern pattern = Pattern.compile("(([^:@]+)@)?([^,]+)(,(\\d+))?");
    private String version;
    private String command;
    private String[] arguments;

    public TraceCommand(String version, String command) {
        this.version = version;
        this.command = command;
        this.arguments = new String[0];
    }

    public TraceCommand(String version, String command, String[] arguments) {
        this.version = version;
        this.command = command;
        this.arguments = arguments;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('$');
        sb.append(this.command);
        String[] stringArray = this.arguments;
        int n = this.arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            sb.append(',');
            sb.append(argument);
            ++n2;
        }
        sb.append('\n');
        return sb.toString();
    }

    protected static String toHex(String version, long address) {
        StringBuffer sb = new StringBuffer();
        sb.append(HEX_PREFIX);
        sb.append(Long.toHexString(address));
        return sb.toString();
    }

    protected static String toHex(String version, byte theByte) {
        StringBuffer sb = new StringBuffer();
        sb.append(HEX_PREFIX);
        sb.append(Integer.toHexString(theByte));
        return sb.toString();
    }

    protected static String toHex(String version, int value) {
        StringBuffer sb = new StringBuffer();
        sb.append(HEX_PREFIX);
        sb.append(Integer.toHexString(value));
        return sb.toString();
    }

    protected static <E extends Enum<E>> long toLong(EnumSet<E> s) {
        long vector = 0L;
        for (Enum e : s) {
            vector |= 1L << e.ordinal();
        }
        return vector;
    }

    protected static String convertLocation(String location) {
        Matcher matcher = pattern.matcher(location.trim());
        boolean matchFound = matcher.find();
        StringBuffer newLocation = new StringBuffer();
        if (matchFound) {
            if (matcher.group(3) != null) {
                newLocation.append(matcher.group(3));
            }
            if (matcher.group(5) != null) {
                newLocation.append(':');
                newLocation.append(matcher.group(5));
            }
            if (matcher.group(2) != null) {
                newLocation.append(':');
                newLocation.append(matcher.group(2));
            }
            return newLocation.toString();
        }
        return EMPTY_STRING;
    }

    public String getVersion() {
        return this.version;
    }

    public static enum Access {
        R,
        W,
        RW;

    }

    public static enum Action {
        START,
        STOP,
        NONE;

    }

    public static enum FeatureState {
        ON,
        OFF;

    }
}

