/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.client.commands;

import com.atmel.avr32.debug.trace.Tracepoint;
import com.atmel.avr32.debug.trace.client.commands.TraceCommand;
import java.util.EnumSet;
import org.eclipse.cdt.core.IAddress;

public class SVDWCommand
extends TraceCommand {
    private static final String COMMAND = "SVDW";
    private static final String _64BIT = "64BIT";
    private static final String _32BIT = "32BIT";
    private static final String _16BIT = "16BIT";
    private static final String _8BIT = "8BIT";
    private static final String _DISREGARD = "DISREGARD";

    public SVDWCommand(String version, EnumSet<Tracepoint.Mask> mask, TraceCommand.Action paction, TraceCommand.Action daction, IAddress address, Tracepoint.Size size, long value) {
        super(version, COMMAND, new String[]{SVDWCommand.toHex(version, SVDWCommand.toLong(mask)), paction.toString(), daction.toString(), address.toHexAddressString(), SVDWCommand.convert(size), SVDWCommand.toHex(version, value)});
    }

    public SVDWCommand(String version, EnumSet<Tracepoint.Mask> mask, TraceCommand.Action paction, TraceCommand.Action daction, String location, Tracepoint.Size size, long value) {
        super(version, COMMAND, new String[]{SVDWCommand.toHex(version, SVDWCommand.toLong(mask)), paction.toString(), daction.toString(), SVDWCommand.convertLocation(location), SVDWCommand.convert(size), SVDWCommand.toHex(version, value)});
    }

    private static String convert(Tracepoint.Size size) {
        switch (size) {
            case DISREGARD: {
                return _DISREGARD;
            }
            case BYTE: {
                return _8BIT;
            }
            case HALFWORD: {
                return _16BIT;
            }
            case WORD: {
                return _32BIT;
            }
            case DOUBLEWORD: {
                return _64BIT;
            }
        }
        return _DISREGARD;
    }
}

