/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace.client;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.debug.AVR32NM;
import com.atmel.avr32.debug.trace.AddressTracepoint;
import com.atmel.avr32.debug.trace.LineTracepoint;
import com.atmel.avr32.debug.trace.TracePlugin;
import com.atmel.avr32.debug.trace.Tracepoint;
import com.atmel.avr32.debug.trace.client.DisconnectedException;
import com.atmel.avr32.debug.trace.client.ITraceEventListener;
import com.atmel.avr32.debug.trace.client.Messages;
import com.atmel.avr32.debug.trace.client.TraceEvent;
import com.atmel.avr32.debug.trace.client.TraceException;
import com.atmel.avr32.debug.trace.client.commands.CAWCommand;
import com.atmel.avr32.debug.trace.client.commands.CWCommand;
import com.atmel.avr32.debug.trace.client.commands.DTRECommand;
import com.atmel.avr32.debug.trace.client.commands.DTRSCommand;
import com.atmel.avr32.debug.trace.client.commands.ETCommand;
import com.atmel.avr32.debug.trace.client.commands.FTBCommand;
import com.atmel.avr32.debug.trace.client.commands.RBSCommand;
import com.atmel.avr32.debug.trace.client.commands.RTDCommand;
import com.atmel.avr32.debug.trace.client.commands.SBCommand;
import com.atmel.avr32.debug.trace.client.commands.SDWCommand;
import com.atmel.avr32.debug.trace.client.commands.SEFCommand;
import com.atmel.avr32.debug.trace.client.commands.SPWCommand;
import com.atmel.avr32.debug.trace.client.commands.SRDWCommand;
import com.atmel.avr32.debug.trace.client.commands.SVDWCommand;
import com.atmel.avr32.debug.trace.client.commands.TFCommand;
import com.atmel.avr32.debug.trace.client.commands.TraceCommand;
import com.atmel.avr32.debug.trace.client.commands.VCommand;
import com.atmel.avr32.debug.trace.data.DataTraceFrame;
import com.atmel.avr32.debug.trace.data.DebugStatusFrame;
import com.atmel.avr32.debug.trace.data.DefaultTraceFrame;
import com.atmel.avr32.debug.trace.data.ErrorFrame;
import com.atmel.avr32.debug.trace.data.ITraceFrame;
import com.atmel.avr32.debug.trace.data.NoSyncFrame;
import com.atmel.avr32.debug.trace.data.OwnershipTraceFrame;
import com.atmel.avr32.debug.trace.data.ProgramTraceFrame;
import com.atmel.avr32.debug.trace.data.TraceOffFrame;
import com.atmel.avr32.debug.trace.data.TraceOnFrame;
import com.atmel.avr32.debug.trace.data.TraceWatchpointHitFrame;
import com.atmel.avr32.debug.trace.data.TracepointHitFrame;
import com.atmel.avr32.debug.ui.AVR32DebugUIPlugin;
import com.atmel.avr32.util.math.BytePrefixParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IBreakpoint;

public class TraceClient {
    private static final String BUNDLE_NAME = "com.atmel.avr32.debug.trace.client.messages";
    private static final String COMMA = ",";
    private static final String EMPTY_STRING = "";
    private static final String EOT = "EOT";
    private static final String IN = " < ";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int LOCK_TIMEOUT = 450;
    private static final String NO_MESSAGE = "";
    private static final Status OK_STATUS = new Status(0, "com.atmel.avr32.debug.trace", "", null);
    private static final String OUT = " > ";
    private static final int POLL_INTERVAL = 1000;
    private static final RBSCommand RBS_COMMAND = new RBSCommand("1.0");
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.atmel.avr32.debug.trace.client.messages");
    private static int SOCKET_LONG_TIMEOUT = 60000;
    public static int SOCKET_READ_TIMEOUT = 5000;
    private static final String version = "1.0";
    protected Object cachedRoot;
    protected ArrayList<ITraceFrame> cachedSource;
    private long commandSequence;
    protected ServerConnection connection;
    private ILaunch fLaunch;
    private LaunchListener fLaunchListener;
    private String fSessionName;
    private int fSize;
    private final ReentrantLock fLock = new ReentrantLock(true);
    private TFCommand.Format previousCodeFormat;
    private TFCommand.Format selectedCodeFormat = TFCommand.Format.DIS_ASM;
    private ListenerList traceEventListeners;
    private TracepointManager fTracepointManager;

    private static String format(String key, Object[] arguments) {
        return MessageFormat.format(key, arguments);
    }

    private static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public TraceClient(ILaunch launch, String name, int initTimout, int commTimeout) {
        this.fLaunch = launch;
        this.fSessionName = name;
        this.traceEventListeners = new ListenerList();
        this.cachedSource = new ArrayList();
        SOCKET_LONG_TIMEOUT = initTimout;
        SOCKET_READ_TIMEOUT = commTimeout;
    }

    public void addTraceEventListener(ITraceEventListener listener) {
        this.traceEventListeners.add((Object)listener);
    }

    public IStatus clearTraceBuffer() {
        IStatus status = this.connection.execute(new FTBCommand(version));
        if (status.isOK()) {
            this.fSize = 0;
            this.fireTraceEvent(new TraceEvent(TraceEvent.EventType.BUFFER_CLEARED));
        }
        return status;
    }

    private Status createErrorStatus(String message) {
        return new Status(4, "com.atmel.avr32.debug.trace", message);
    }

    private Status createExceptionStatus(String message, Throwable exception) {
        return new Status(4, "com.atmel.avr32.debug.trace", message, exception);
    }

    private ProtocolStatus createProtocolErrorStatus(String text, String message, String reply) {
        return new ProtocolStatus(2, text, null, reply);
    }

    private ProtocolStatus createProtocolOKStatus(String reply) {
        return new ProtocolStatus(0, "", reply);
    }

    private synchronized int detectTraceData() {
        if (!this.isConnected()) {
            return 0;
        }
        int total = 0;
        try {
            assert (this.fLock.getHoldCount() == 0);
            assert (!this.fLock.isHeldByCurrentThread());
            if (this.fLock.tryLock(450L, TimeUnit.MILLISECONDS)) {
                try {
                    IStatus cmd = this.connection.execute(RBS_COMMAND);
                    if (cmd.isOK()) {
                        String line = ((ProtocolStatus)cmd).getReply();
                        total = Integer.decode(line.substring(line.indexOf(COMMA) + 1));
                    } else {
                        AVR32DebugUIPlugin.messageDialog((IStatus)cmd);
                    }
                }
                finally {
                    this.fLock.unlock();
                }
            }
            if (total > this.fSize) {
                int more = total - this.fSize;
                this.fSize = total;
                this.fireTraceEvent(new TraceEvent(TraceEvent.EventType.DATA_AVAILABLE, this, this.fSize));
                return more;
            }
        }
        catch (InterruptedException interruptedException) {}
        return 0;
    }

    private void fireTraceEvent(final TraceEvent event) {
        Object[] l = this.traceEventListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            final ITraceEventListener listener = (ITraceEventListener)l[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    exception.printStackTrace();
                }

                public void run() throws Exception {
                    listener.traceEvent(event);
                }
            });
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCode(ProgramTraceFrame root) throws TraceException {
        if (!this.isConnected()) {
            throw new DisconnectedException(Messages.TraceClient_Disconnected);
        }
        try {
            assert (this.fLock.getHoldCount() == 0);
            assert (!this.fLock.isHeldByCurrentThread());
            if (!this.fLock.tryLock() && !this.fLock.tryLock(450L, TimeUnit.MILLISECONDS)) {
                throw new TraceException(MessageFormat.format(Messages.TraceClient_LockTimeout, 450));
            }
            try {
                String string = this.connection.getFrameRawData(Integer.decode(root.getSequence()), true);
                return string;
            }
            catch (IOException iOException) {
                throw new TraceException();
            }
            finally {
                this.fLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new TraceException(e);
        }
    }

    public ITraceFrame getData(int position) throws TraceException {
        return this.getData(position, 1)[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITraceFrame[] getData(int position, int length) throws TraceException {
        if (!this.isConnected()) {
            throw new DisconnectedException(Messages.TraceClient_Disconnected);
        }
        try {
            assert (this.fLock.getHoldCount() == 0);
            assert (!this.fLock.isHeldByCurrentThread());
            if (!this.fLock.tryLock() && !this.fLock.tryLock(450L, TimeUnit.MILLISECONDS)) {
                throw new TraceException(MessageFormat.format(Messages.TraceClient_LockTimeout, 450));
            }
            try {
                ITraceFrame[] iTraceFrameArray = this.connection.getFrameHeaders(position, length);
                return iTraceFrameArray;
            }
            catch (IOException e) {
                this.connection.disconnect();
                throw new TraceException(e);
            }
            finally {
                this.fLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new TraceException(e);
        }
    }

    public int getDataLength() {
        return this.fSize;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public String getName() {
        return this.fSessionName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRaw(int frame) throws TraceException {
        if (!this.isConnected()) {
            throw new DisconnectedException(Messages.TraceClient_Disconnected);
        }
        try {
            assert (this.fLock.getHoldCount() == 0);
            assert (!this.fLock.isHeldByCurrentThread());
            if (!this.fLock.tryLock() && !this.fLock.tryLock(450L, TimeUnit.MILLISECONDS)) {
                throw new TraceException(MessageFormat.format(Messages.TraceClient_LockTimeout, 450));
            }
            try {
                String string = this.connection.getFrameRawData(frame, false);
                return string;
            }
            catch (IOException e) {
                throw new TraceException(e);
            }
            finally {
                this.fLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new TraceException(e);
        }
    }

    public TFCommand.Format getSelectedCodeFormat() {
        return this.selectedCodeFormat;
    }

    public IStatus init() {
        try {
            ILaunchConfiguration configuration = this.fLaunch.getLaunchConfiguration();
            int port = Integer.parseInt(configuration.getAttribute("AVR32_ATTR_GDB_TRACE_PORT", "-1"));
            String host = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "localhost");
            this.selectedCodeFormat = TFCommand.Format.SOURCE;
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new DebugEventSetListener());
            this.fTracepointManager = new TracepointManager();
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this.fTracepointManager);
            this.fLaunchListener = new LaunchListener();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchListener);
            this.connection = new ServerConnection();
            IStatus status = Status.OK_STATUS;
            status = this.connection.connect(host, port);
            status = this.connection.execute(new VCommand(version));
            if (status.isOK()) {
                status = this.initializeTrace();
            }
            if (status.isOK()) {
                status = this.initializeBuffer();
            }
            if (status.isOK()) {
                status = this.fTracepointManager.setTracepoints();
            }
            if (status.isOK()) {
                this.fireTraceEvent(new TraceEvent(TraceEvent.EventType.CLIENT_INITIALIZED));
                PollJob job = new PollJob(Messages.TraceClient_PollerName);
                job.schedule();
            }
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "com.atmel.avr32.debug.trace", Messages.TraceClient_CouldNotInitialize, (Throwable)e);
        }
    }

    private IStatus initializeBuffer() {
        ILaunchConfiguration configuration = this.fLaunch.getLaunchConfiguration();
        try {
            long size = Long.decode(configuration.getAttribute("AVR32_ATTR_BUFFER_SIZE", "64"));
            long offset = Long.decode(configuration.getAttribute("AVR32_ATTR_BUFFER_START", "32848"));
            if (configuration.getAttribute("AVR32_ATTR_DETECT_BUFFER", false)) {
                IPath objectfile = Path.fromPortableString((String)configuration.getAttribute("AVR32_ATTR_EXEPATH", ""));
                try {
                    AVR32NM nm = new AVR32NM(objectfile.toOSString());
                    AVR32NM.AddressNamePair[] pairs = nm.getBSSSymbols();
                    boolean found = false;
                    AVR32NM.AddressNamePair[] addressNamePairArray = pairs;
                    int n = pairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AVR32NM.AddressNamePair addressNamePair = addressNamePairArray[n2];
                        if (addressNamePair.name.equals("NANOTRACE")) {
                            size = addressNamePair.size;
                            offset = addressNamePair.address;
                            found = true;
                        }
                        ++n2;
                    }
                    if (!found) {
                        this.createErrorStatus(Messages.TraceClient_ArrayNotDetected);
                    }
                }
                catch (IOException e) {
                    return this.createExceptionStatus(Messages.TraceClient_ArrayDetectionError, e);
                }
            }
            boolean ntap = configuration.getAttribute("AVR32_ATTR_ENABLE_NTAP", true);
            AVR32DebugPlugin.TraceBufferControl full = AVR32DebugPlugin.TraceBufferControl.valueOf((String)configuration.getAttribute("AVR32_ATTR_BUFFER_ACTION", AVR32DebugPlugin.TraceBufferControl.ENTER_DEBUG_MODE.toString()));
            AVR32DebugPlugin.TraceMethod method = AVR32DebugPlugin.TraceMethod.valueOf((String)configuration.getAttribute("AVR32_TRACE_METHOD", AVR32DebugPlugin.TraceMethod.NANO_TRACE.toString()));
            if (method != AVR32DebugPlugin.TraceMethod.NANO_TRACE) {
                size = BytePrefixParser.getInt((String)configuration.getAttribute("AVR32_ATTR_DEBUGGER_BUFFER_SIZE", "128Mb")) / 2048;
                offset = 0L;
            }
            IStatus status = null;
            status = size > 0L ? this.connection.execute(new SBCommand(version, method, full, ntap, size, offset)) : this.connection.execute(new SBCommand(version, method, full, ntap));
            if (status.isOK()) {
                status = this.connection.execute(new TFCommand(version, TFCommand.Format.SOURCE_FROM_TO));
            }
            return status;
        }
        catch (CoreException e) {
            return this.createExceptionStatus(Messages.TraceClient_CouldNotInitializeBuffer, e);
        }
    }

    private IStatus initializeTrace() throws CoreException, IOException {
        TraceCommand.Access access;
        ILaunchConfiguration configuration = this.fLaunch.getLaunchConfiguration();
        IPath objectfile = Path.fromPortableString((String)configuration.getAttribute("AVR32_ATTR_EXEPATH", ""));
        IStatus status = this.connection.execute(new SEFCommand(version, objectfile.makeAbsolute().toFile()));
        if (Long.decode(configuration.getAttribute("AVR32_ATTR_RANGE1_UB", "0x0")) > 0L) {
            access = TraceCommand.Access.valueOf(configuration.getAttribute("AVR32_ATTR_RANGE1_ACCESS", "RW"));
            this.connection.execute(new DTRSCommand(version, 0, Long.decode(configuration.getAttribute("AVR32_ATTR_RANGE1_LB", "0x0")), access));
            this.connection.execute(new DTRECommand(version, 0, Long.decode(configuration.getAttribute("AVR32_ATTR_RANGE1_UB", "0x0"))));
        }
        if (Long.decode(configuration.getAttribute("AVR32_ATTR_RANGE2_UB", "0x0")) > 0L) {
            access = TraceCommand.Access.valueOf(configuration.getAttribute("AVR32_ATTR_RANGE2_ACCESS", "RW"));
            this.connection.execute(new DTRSCommand(version, 1, Long.decode(configuration.getAttribute("AVR32_ATTR_RANGE2_LB", "0x0")), access));
            this.connection.execute(new DTRECommand(version, 1, Long.decode(configuration.getAttribute("AVR32_ATTR_RANGE2_UB", "0x0"))));
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        ServerConnection serverConnection = this.connection;
        synchronized (serverConnection) {
            return this.connection.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void panic(String message, Throwable exception) {
        if (exception != null) {
            TracePlugin.debug(String.valueOf(message) + " (" + exception.getMessage() + ")");
        } else {
            TracePlugin.debug(message);
        }
        ServerConnection serverConnection = this.connection;
        synchronized (serverConnection) {
            this.connection.disconnect();
        }
    }

    public void removeTraceEventListener(ITraceEventListener listener) {
        this.traceEventListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus setTrace(ETCommand.Trace type, boolean state) {
        ServerConnection serverConnection = this.connection;
        synchronized (serverConnection) {
            return this.connection.execute(new ETCommand(version, type, state));
        }
    }

    public void setSelectedCodeFormat(TFCommand.Format selectedCodeFormat, boolean triggerEvent) {
        this.selectedCodeFormat = selectedCodeFormat;
        if (triggerEvent) {
            this.fireTraceEvent(new TraceEvent(TraceEvent.EventType.FORMAT_CHANGED, (Object)selectedCodeFormat));
        }
    }

    private void stop() {
        if (this.fTracepointManager != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this.fTracepointManager);
        }
        if (this.fLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchListener);
        }
    }

    private class CDIEventListener
    implements ICDIEventListener {
        private CDIEventListener() {
        }

        public void handleDebugEvents(ICDIEvent[] events) {
            ICDIEvent[] iCDIEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                ICDIEvent event = iCDIEventArray[n2];
                if (event.getSource() instanceof Target) {
                    if (event instanceof ICDIDisconnectedEvent) {
                        TraceClient.this.connection.disconnect();
                    }
                    boolean cfr_ignored_0 = event instanceof ICDIResumedEvent;
                    if (event instanceof ICDIDestroyedEvent) {
                        if (!TraceClient.this.isConnected()) {
                            return;
                        }
                        TraceClient.this.connection.disconnect();
                    }
                    if (event instanceof ICDISuspendedEvent && TraceClient.this.isConnected()) {
                        TraceClient.this.detectTraceData();
                    }
                }
                ++n2;
            }
        }
    }

    private class DebugEventSetListener
    implements IDebugEventSetListener {
        private DebugEventSetListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (TraceClient.this.fLaunch.getDebugTarget() != null) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent debugEvent = debugEventArray[n2];
                    Object src = debugEvent.getSource();
                    if (src != null && src.equals(TraceClient.this.fLaunch.getDebugTarget()) && debugEvent.getKind() == 4) {
                        ((CDebugTarget)src).getCDISession().getEventManager().addEventListener((ICDIEventListener)new CDIEventListener());
                    }
                    ++n2;
                }
            }
        }
    }

    private class LaunchListener
    implements ILaunchesListener2 {
        private LaunchListener() {
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch == TraceClient.this.fLaunch) {
                    TraceClient.this.stop();
                }
                ++n2;
            }
        }
    }

    private class PollJob
    extends Job {
        public PollJob(String name) {
            super(name);
            this.setSystem(true);
            this.setPriority(30);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (TraceClient.this.isConnected()) {
                try {
                    Thread.sleep(1000L);
                    TraceClient.this.detectTraceData();
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class ProtocolStatus
    extends Status {
        private String reply;

        public ProtocolStatus(int severity, String message, String reply) {
            super(severity, "com.atmel.avr32.debug.trace", message);
            this.reply = reply;
        }

        public ProtocolStatus(int severity, String message, Throwable exception, String reply) {
            super(severity, "com.atmel.avr32.debug.trace", message, exception);
            this.reply = reply;
        }

        public String getReply() {
            return this.reply;
        }
    }

    private class ServerConnection {
        private static final String MSG_BAD_REPLY = "-";
        private static final String MSG_GOOD_REPLY = "+";
        private static final String STREAM_ENCODING = "ASCII";
        private boolean connected;
        private final String[] DATATYPES = new String[]{"PTT", "PTS", "PTP", "PTA", "OTM", "DTM", "DEB", "ERROR", "WH", "TWH", "TON", "TOF", "PT_NO_SYNC"};
        private BufferedReader fStreamReader;
        String line = new String();
        private BufferedWriter out;
        StringBuilder sb = new StringBuilder();
        private Socket socket;

        private ServerConnection() {
        }

        private IStatus connect(String host, int port) {
            TracePlugin.debug("Trace client connecting to " + host + ":" + port);
            try {
                this.socket = new Socket(host, port);
                this.socket.setKeepAlive(true);
                this.socket.setSoTimeout(SOCKET_READ_TIMEOUT);
                this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), STREAM_ENCODING));
                this.fStreamReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), STREAM_ENCODING));
                this.connected = true;
                TraceClient.this.fireTraceEvent(new TraceEvent(TraceEvent.EventType.CLIENT_CONNECTED));
            }
            catch (UnknownHostException e) {
                this.connected = false;
                return TraceClient.this.createExceptionStatus(Messages.TraceClient_NoHost, e);
            }
            catch (IOException e) {
                this.connected = false;
                return TraceClient.this.createExceptionStatus(Messages.TraceClient_IOError, e);
            }
            return OK_STATUS;
        }

        private ITraceFrame decode(String message) {
            if (message.startsWith(MSG_BAD_REPLY)) {
                return null;
            }
            int type = -1;
            String ts = message.substring(0, message.indexOf(32)).trim();
            int a = 0;
            while (a < this.DATATYPES.length) {
                if (ts.equals(this.DATATYPES[a])) {
                    type = a;
                }
                ++a;
            }
            switch (type) {
                case 0: {
                    return new ProgramTraceFrame(message);
                }
                case 1: {
                    return new ProgramTraceFrame(message);
                }
                case 2: {
                    return new ProgramTraceFrame(message);
                }
                case 3: {
                    return new ProgramTraceFrame(message);
                }
                case 4: {
                    return new OwnershipTraceFrame(message);
                }
                case 5: {
                    return new DataTraceFrame(message);
                }
                case 6: {
                    return new DebugStatusFrame(message);
                }
                case 7: {
                    return new ErrorFrame(message);
                }
                case 8: {
                    return new TraceWatchpointHitFrame(message);
                }
                case 9: {
                    return new TracepointHitFrame(message);
                }
                case 10: {
                    return new TraceOnFrame(message);
                }
                case 11: {
                    return new TraceOffFrame(message);
                }
                case 12: {
                    return new NoSyncFrame(message);
                }
            }
            return new DefaultTraceFrame(message);
        }

        protected void disconnect() {
            TraceClient.this.stop();
            if (TraceClient.this.isConnected()) {
                try {
                    TracePlugin.debug("Trace client disconnecting.");
                    this.connected = false;
                    TraceClient.this.fSize = 0;
                    this.out.close();
                    this.fStreamReader.close();
                    this.socket.close();
                }
                catch (IOException iOException) {}
                TraceClient.this.fireTraceEvent(new TraceEvent(TraceEvent.EventType.CLIENT_DISCONNECTED));
            }
        }

        protected IStatus execute(TraceCommand command) {
            if (TraceClient.this.isConnected()) {
                int timeout = 0;
                try {
                    timeout = command instanceof SEFCommand ? SOCKET_LONG_TIMEOUT : SOCKET_READ_TIMEOUT;
                    this.socket.setSoTimeout(timeout);
                    TraceClient traceClient = TraceClient.this;
                    traceClient.commandSequence = traceClient.commandSequence + 1L;
                    TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.OUT + command.toString().trim());
                    this.out.write(command.toString());
                    this.out.flush();
                    return this.read_consumeReply(command.toString());
                }
                catch (Exception e) {
                    String error = MessageFormat.format(Messages.TraceClient_CouldNotExecute, command, new Integer(timeout));
                    TraceClient.this.panic(error, e);
                    return TraceClient.this.createExceptionStatus(error, e);
                }
            }
            return TraceClient.this.createErrorStatus(MessageFormat.format(Messages.TraceClient_NotConnected, command));
        }

        private ITraceFrame[] getFrameHeaders(int position, int length) throws IOException {
            if (TraceClient.this.previousCodeFormat != TFCommand.Format.SOURCE_FROM_TO) {
                TraceClient.this.connection.execute(new TFCommand(TraceClient.version, TFCommand.Format.SOURCE_FROM_TO));
                TraceClient.this.previousCodeFormat = TFCommand.Format.SOURCE_FROM_TO;
            }
            ITraceFrame[] frames = new ITraceFrame[length];
            IStatus status = TraceClient.this.connection.execute(new RTDCommand(TraceClient.version, position, length));
            if (!status.isOK()) {
                return frames;
            }
            int pos = 0;
            this.line = this.fStreamReader.readLine();
            TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.IN + this.line + " (decoded)");
            while (!this.line.startsWith(TraceClient.EOT)) {
                frames[pos++] = this.decode(this.line);
                this.line = this.fStreamReader.readLine();
                TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.IN + this.line + " (decoded)");
            }
            if (pos != length) {
                TracePlugin.debug("Adjusting returned data length. Requested " + length + " got " + pos);
                ITraceFrame[] temp = new ITraceFrame[pos];
                System.arraycopy(frames, 0, temp, 0, pos);
                frames = temp;
            }
            this.line = this.fStreamReader.readLine();
            TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.IN + this.line + " (ignored)");
            return frames;
        }

        private String getFrameRawData(int position, boolean massage) throws IOException {
            IStatus status;
            this.sb.setLength(0);
            if (TraceClient.this.previousCodeFormat != TraceClient.this.selectedCodeFormat) {
                TraceClient.this.connection.execute(new TFCommand(TraceClient.version, TraceClient.this.selectedCodeFormat));
                TraceClient.this.previousCodeFormat = TraceClient.this.selectedCodeFormat;
            }
            if (!(status = TraceClient.this.connection.execute(new RTDCommand(TraceClient.version, position, 1L))).isOK()) {
                return status.getMessage();
            }
            this.line = this.fStreamReader.readLine();
            TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.IN + this.line + " (ignored)");
            while (this.line != null) {
                if (massage) {
                    boolean found = false;
                    String[] stringArray = this.DATATYPES;
                    int n = this.DATATYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String pre = stringArray[n2];
                        if (this.line.startsWith(pre)) {
                            found = true;
                        }
                        ++n2;
                    }
                    if (found) {
                        this.sb.append(this.line.substring(14));
                        this.sb.append(LINE_SEPARATOR);
                    }
                } else {
                    this.sb.append(this.line);
                    this.sb.append(LINE_SEPARATOR);
                }
                this.line = this.fStreamReader.readLine();
                TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.IN + this.line + " (source)");
                if (!this.line.equals(TraceClient.EOT)) continue;
                this.line = this.fStreamReader.readLine();
                TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.IN + this.line + " (ignored)");
                break;
            }
            return this.sb.toString();
        }

        private IStatus read_consumeReply(String command) throws IOException {
            String line = null;
            line = this.fStreamReader.readLine();
            TracePlugin.debug(String.valueOf(TraceClient.this.commandSequence) + TraceClient.IN + line);
            if (line == null) {
                return TraceClient.this.createErrorStatus(TraceClient.format(Messages.TraceClient_NoReply, new String[]{command.trim()}));
            }
            if (line.startsWith(MSG_BAD_REPLY)) {
                return TraceClient.this.createProtocolErrorStatus(TraceClient.format(Messages.TraceClient_ServerReplied, new String[]{TraceClient.getString(line.substring(1)), command}), line, line);
            }
            if (line.startsWith(MSG_GOOD_REPLY)) {
                return TraceClient.this.createProtocolOKStatus(line);
            }
            return Status.CANCEL_STATUS;
        }
    }

    private class TracepointManager
    implements IBreakpointsListener,
    IBreakpointManagerListener {
        HashMap<Tracepoint, Integer> map = new HashMap();

        private TracepointManager() {
        }

        public void breakpointManagerEnablementChanged(boolean enabled) {
        }

        public void breakpointsAdded(IBreakpoint[] breakpoints) {
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof Tracepoint) {
                    try {
                        IStatus status = this.setTracepoint((Tracepoint)breakpoint);
                        if (!status.isOK()) {
                            AVR32DebugUIPlugin.messageDialog((IStatus)status);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }

        public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof Tracepoint && this.map.containsKey(breakpoint)) {
                    if (this.map.get(breakpoint) != null) {
                        TraceClient.this.connection.execute(new CWCommand(TraceClient.version, this.map.get(breakpoint)));
                        this.map.remove(breakpoint);
                    }
                    try {
                        IStatus status = this.setTracepoint((Tracepoint)breakpoint);
                        if (!status.isOK()) {
                            AVR32DebugUIPlugin.messageDialog((IStatus)status);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }

        public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof Tracepoint && this.map.containsKey(breakpoint) && this.map.get(breakpoint) != null) {
                    TraceClient.this.connection.execute(new CWCommand(TraceClient.version, this.map.get(breakpoint)));
                    this.map.remove(breakpoint);
                }
                ++n2;
            }
        }

        private IStatus setTracepoint(Tracepoint tracepoint) throws CoreException {
            IStatus status = Status.OK_STATUS;
            if (tracepoint.isEnabled()) {
                TraceCommand.Action pAction = TraceCommand.Action.NONE;
                TraceCommand.Action dAction = TraceCommand.Action.NONE;
                if (tracepoint.getOperation().equals((Object)Tracepoint.Operation.START)) {
                    if (tracepoint.isProgramTrace()) {
                        pAction = TraceCommand.Action.START;
                    }
                    if (tracepoint.isDataTrace()) {
                        dAction = TraceCommand.Action.START;
                    }
                } else if (tracepoint.getOperation().equals((Object)Tracepoint.Operation.STOP)) {
                    if (tracepoint.isProgramTrace()) {
                        pAction = TraceCommand.Action.STOP;
                    }
                    if (tracepoint.isDataTrace()) {
                        dAction = TraceCommand.Action.STOP;
                    }
                }
                if (tracepoint.getEvent() == Tracepoint.Event.PROGRAM_COUNTER) {
                    if (tracepoint instanceof LineTracepoint) {
                        status = TraceClient.this.connection.execute(new SPWCommand(TraceClient.version, pAction, dAction, ((LineTracepoint)tracepoint).getStartLocation()));
                    } else if (tracepoint instanceof AddressTracepoint) {
                        status = TraceClient.this.connection.execute(new SPWCommand(TraceClient.version, pAction, dAction, ((AddressTracepoint)tracepoint).getStartAddress()));
                    }
                    if (status instanceof ProtocolStatus && status.isOK()) {
                        String reply = ((ProtocolStatus)status).getReply();
                        this.map.put(tracepoint, Integer.decode(reply.substring(4)));
                    } else {
                        this.map.put(tracepoint, null);
                    }
                } else {
                    TraceCommand.Access access = null;
                    switch (tracepoint.getEvent()) {
                        case DATA_ACCESS: {
                            access = TraceCommand.Access.RW;
                            break;
                        }
                        case DATA_READ: {
                            access = TraceCommand.Access.R;
                            break;
                        }
                        case DATA_WRITE: {
                            access = TraceCommand.Access.W;
                        }
                    }
                    if (tracepoint.getComparison() == Tracepoint.Compare.NO_COMPARISON && tracepoint.getLocationType() == Tracepoint.Location.LOCATION) {
                        if (tracepoint instanceof LineTracepoint) {
                            status = TraceClient.this.connection.execute(new SDWCommand(TraceClient.version, access, pAction, dAction, ((LineTracepoint)tracepoint).getStartLocation()));
                        } else if (tracepoint instanceof AddressTracepoint) {
                            status = TraceClient.this.connection.execute(new SDWCommand(TraceClient.version, access, pAction, dAction, ((AddressTracepoint)tracepoint).getStartAddress()));
                        }
                    } else if (tracepoint.getLocationType() == Tracepoint.Location.RANGE) {
                        if (tracepoint instanceof LineTracepoint) {
                            status = TraceClient.this.connection.execute(new SRDWCommand(TraceClient.version, access, pAction, dAction, ((LineTracepoint)tracepoint).getStartLocation(), ((LineTracepoint)tracepoint).getEndLocation(), tracepoint.getRangeType()));
                        } else if (tracepoint instanceof AddressTracepoint) {
                            status = TraceClient.this.connection.execute(new SRDWCommand(TraceClient.version, access, pAction, dAction, ((AddressTracepoint)tracepoint).getStartAddress(), ((AddressTracepoint)tracepoint).getEndAddress(), tracepoint.getRangeType()));
                        }
                    } else if (tracepoint.getComparison() != Tracepoint.Compare.NO_COMPARISON) {
                        if (tracepoint instanceof LineTracepoint) {
                            status = TraceClient.this.connection.execute(new SVDWCommand(TraceClient.version, tracepoint.getComparisonMask(), pAction, dAction, ((LineTracepoint)tracepoint).getStartLocation(), tracepoint.getComparisonSize(), (long)Long.decode(tracepoint.getComparisonValue())));
                        }
                        if (tracepoint instanceof AddressTracepoint) {
                            status = TraceClient.this.connection.execute(new SVDWCommand(TraceClient.version, tracepoint.getComparisonMask(), pAction, dAction, ((AddressTracepoint)tracepoint).getStartAddress(), tracepoint.getComparisonSize(), (long)Long.decode(tracepoint.getComparisonValue())));
                        }
                    }
                    if (status instanceof ProtocolStatus && status.isOK()) {
                        String reply = ((ProtocolStatus)status).getReply();
                        this.map.put(tracepoint, Integer.decode(reply.substring(4)));
                    } else {
                        this.map.put(tracepoint, null);
                    }
                }
                if (!status.isOK()) {
                    tracepoint.setEnabled(false);
                }
            } else {
                this.map.put(tracepoint, null);
            }
            return status;
        }

        private IStatus setTracepoints() {
            try {
                MultiStatus status = new MultiStatus("com.atmel.avr32.debug.trace", 0, Messages.TraceClient_Settings, null);
                TraceClient.this.connection.execute(new CAWCommand(TraceClient.version));
                String project = TraceClient.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                IProject iproject = ResourcesPlugin.getWorkspace().getRoot().getProject(project);
                IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                int n = iBreakpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint breakpoint = iBreakpointArray[n2];
                    IResource resource = breakpoint.getMarker().getResource();
                    if (resource != null) {
                        if (breakpoint instanceof Tracepoint && resource.getProject().equals((Object)iproject)) {
                            Tracepoint tracepoint = (Tracepoint)breakpoint;
                            status.add(this.setTracepoint(tracepoint));
                        }
                    } else {
                        status.add((IStatus)TraceClient.this.createErrorStatus(Messages.TraceClient_ErrorBadResource));
                    }
                    ++n2;
                }
                return status;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return TraceClient.this.createExceptionStatus(Messages.TraceClient_CouldNotSetTracepoints, e);
            }
        }
    }
}

