/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace;

import com.atmel.avr32.debug.trace.AddressTracepoint;
import com.atmel.avr32.debug.trace.LineTracepoint;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;

public abstract class Tracepoint
extends LineBreakpoint {
    protected static final String RIGHT_BRACKET = "]";
    protected static final String LEFT_BRACKET = " [";
    protected static final String HEX_ZERO = "0x0";
    public static final String LOCATION_PATTERN = "(([^:@]+)@)?([^,]+)(,(\\d+))?";
    public static final String ADDRESS_PATTERN = "0x([a-fA-F0-9])+";
    public static final String VARIABLE_SEPARATOR = "@";
    public static final String LINE_SEPARATOR = ",";
    protected static final String TRACEPOINT_OPERATION = "tracepoint.operation";
    public static final String TRACEPOINT_START_ADDRESS = "tracepoint.start.address";
    protected static final String TRACEPOINT_END_ADDRESS = "tracepoint.end.address";
    protected static final String TRACEPOINT_START_LOCATION = "tracepoint.start.location";
    protected static final String TRACEPOINT_END_LOCATION = "tracepoint.end.location";
    protected static final String TRACEPOINT_EVENT = "tracepoint.event";
    protected static final String TRACEPOINT_PROGRAM_TRACE = "tracepoint.program_trace";
    protected static final String TRACEPOINT_DATA_TRACE = "tracepoint.data_trace";
    protected static final String TRACEPOINT_COMPARE = "tracepoint.comparison";
    protected static final String TRACEPOINT_COMPARE_VALUE = "tracepoint.comparison.value";
    protected static final String TRACEPOINT_COMPARE_MASK = "tracepoint.comparison.mask";
    protected static final String TRACEPOINT_COMPARE_SIZE = "tracepoint.comparison.size";
    protected static final String TRACEPOINT_LOCATION_TYPE = "tracepoint.location.type";
    protected static final String TRACEPOINT_LOCATION_RANGE = "tracepoint.location.range";
    protected static final String EMPTY_STRING = "";

    public static Tracepoint createInstance(IResource resource, int lineNumber, boolean enabled) throws CoreException {
        return Tracepoint.createInstance(resource, lineNumber, -1, enabled);
    }

    public static Tracepoint createInstance(IResource resource, int lineNumber, int column, boolean enabled) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "com.atmel.avr32.debug.core.id");
        attributes.put("charStart", new Integer(column));
        attributes.put("charEnd", new Integer(column));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put(TRACEPOINT_OPERATION, Operation.START.toString());
        attributes.put(TRACEPOINT_EVENT, Event.PROGRAM_COUNTER.toString());
        attributes.put(TRACEPOINT_START_LOCATION, String.valueOf(resource.getLocation().toOSString()) + LINE_SEPARATOR + lineNumber);
        attributes.put(TRACEPOINT_END_LOCATION, EMPTY_STRING);
        return new LineTracepoint(resource, attributes, false);
    }

    public static Tracepoint createInstance(IResource resource, IVariable variable, boolean enabled, boolean register) throws CoreException {
        ISourceRange range = variable.getSourceRange();
        int charStart = range.getIdStartPos();
        int charEnd = range.getIdStartPos() + range.getIdLength();
        int lineNumber = range.getStartLine();
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "com.atmel.avr32.debug.core.id");
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put(TRACEPOINT_DATA_TRACE, true);
        attributes.put(TRACEPOINT_PROGRAM_TRACE, false);
        attributes.put(TRACEPOINT_OPERATION, Operation.MESSAGE.toString());
        attributes.put(TRACEPOINT_EVENT, Event.DATA_ACCESS.toString());
        attributes.put(TRACEPOINT_START_LOCATION, String.valueOf(variable.getElementName()) + VARIABLE_SEPARATOR + resource.getLocation().toOSString() + LINE_SEPARATOR + lineNumber);
        attributes.put(TRACEPOINT_END_LOCATION, String.valueOf(variable.getElementName()) + VARIABLE_SEPARATOR + resource.getLocation().toOSString() + LINE_SEPARATOR + lineNumber);
        return new LineTracepoint(resource, attributes, register);
    }

    public static AddressTracepoint createAddressTracepoint(IResource resource, IAddress address, boolean enabled, boolean register) throws CoreException {
        if (resource == null || address == null) {
            return null;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "com.atmel.avr32.debug.core.id");
        attributes.put("charStart", new Integer(-1));
        attributes.put("charEnd", new Integer(-1));
        attributes.put("lineNumber", new Integer(-1));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put(TRACEPOINT_START_ADDRESS, address.toHexAddressString());
        attributes.put(TRACEPOINT_END_ADDRESS, HEX_ZERO);
        attributes.put(TRACEPOINT_DATA_TRACE, false);
        attributes.put(TRACEPOINT_PROGRAM_TRACE, true);
        attributes.put(TRACEPOINT_OPERATION, Operation.START.toString());
        attributes.put(TRACEPOINT_EVENT, Event.PROGRAM_COUNTER.toString());
        return new AddressTracepoint(resource, attributes, register);
    }

    protected void createMarker(final IResource resource, final Map<String, Object> attributes, final boolean register) throws DebugException {
        Assert.isNotNull((Object)resource, (String)"A resource must be specified for creating a marker!");
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Tracepoint.this.setMarker(resource.createMarker(Tracepoint.this.getMarkerId()));
                Tracepoint.this.ensureMarker().setAttributes(attributes);
                Tracepoint.this.setAttribute("message", Tracepoint.this.getMarkerMessage());
                Tracepoint.this.setRegistered(register);
            }
        };
        this.run(wr);
    }

    public abstract String getMarkerId();

    public String getModelIdentifier() {
        return "com.atmel.avr32.debug.core.id";
    }

    protected void run(IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public abstract String getMarkerMessage();

    public abstract String getText(boolean var1);

    public Operation getOperation() {
        String value = this.getMarker().getAttribute(TRACEPOINT_OPERATION, Operation.START.toString());
        return Operation.valueOf(value);
    }

    public Range getRangeType() {
        String value = this.getMarker().getAttribute(TRACEPOINT_LOCATION_RANGE, Range.INCLUSIVE.toString());
        return Range.valueOf(value);
    }

    public Event getEvent() {
        String value = this.getMarker().getAttribute(TRACEPOINT_EVENT, Event.PROGRAM_COUNTER.toString());
        return Event.valueOf(value);
    }

    public Compare getComparison() {
        String value = this.getMarker().getAttribute(TRACEPOINT_COMPARE, Compare.NO_COMPARISON.toString());
        return Compare.valueOf(value);
    }

    public Location getLocationType() {
        String value = this.getMarker().getAttribute(TRACEPOINT_LOCATION_TYPE, Location.LOCATION.toString());
        return Location.valueOf(value);
    }

    public Size getComparisonSize() {
        String value = this.getMarker().getAttribute(TRACEPOINT_COMPARE_SIZE, Size.DISREGARD.toString());
        return Size.valueOf(value);
    }

    public EnumSet<Mask> getComparisonMask() {
        String values = this.getMarker().getAttribute(TRACEPOINT_COMPARE_MASK, EMPTY_STRING);
        EnumSet<Mask> mask = EnumSet.noneOf(Mask.class);
        try {
            String[] stringArray = values.split(LINE_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                mask.add(Mask.valueOf(value));
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return mask;
    }

    public String getComparisonValue() {
        return this.getMarker().getAttribute(TRACEPOINT_COMPARE_VALUE, HEX_ZERO);
    }

    public boolean isProgramTrace() {
        return this.getMarker().getAttribute(TRACEPOINT_PROGRAM_TRACE, true);
    }

    public boolean isDataTrace() {
        return this.getMarker().getAttribute(TRACEPOINT_DATA_TRACE, false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMarkerMessage());
        sb.append('(');
        sb.append("registered=");
        try {
            sb.append(this.isRegistered());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        sb.append(", enabled=");
        try {
            sb.append(this.isEnabled());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        sb.append(')');
        return sb.toString();
    }

    public static enum Compare {
        NO_COMPARISON,
        MASK_BYTES,
        EQUALITY;

    }

    public static enum Event {
        PROGRAM_COUNTER,
        DATA_READ,
        DATA_WRITE,
        DATA_ACCESS;

    }

    public static enum Location {
        LOCATION,
        RANGE;

    }

    public static enum Mask {
        MASK_7_0,
        MASK_15_8,
        MASK_23_16,
        MASK_31_24;

    }

    public static enum Operation {
        START,
        STOP,
        MESSAGE;

    }

    public static enum Range {
        EXCLUSIVE,
        INCLUSIVE;

    }

    public static enum Size {
        DISREGARD,
        BYTE,
        HALFWORD,
        WORD,
        DOUBLEWORD;

    }
}

