/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace;

import com.atmel.avr32.debug.trace.client.TraceClient;
import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.part.model.DebugSystem;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.util.UtilPlugin;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.osgi.framework.BundleContext;

public class TracePlugin
extends Plugin {
    public static final String PREF_INITIALIZE_TIMEOUT = "PREF_INITIALIZE_TIMEOUT";
    public static final String PREF_MESSAGE_TIMEOUT = "PREF_MESSAGE_TIMEOUT";
    public static final String DEBUG_MODEL_ID = "com.atmel.avr32.debug.core.id";
    public static final String ATTR_BUFFER_ACTION = "AVR32_ATTR_BUFFER_ACTION";
    public static final String ATTR_BUFFER_SIZE = "AVR32_ATTR_BUFFER_SIZE";
    public static final String ATTR_BUFFER_START = "AVR32_ATTR_BUFFER_START";
    public static final String ATTR_DETECT_BUFFER = "AVR32_ATTR_DETECT_BUFFER";
    public static final String ATTR_BUFFER_SPECIFIED = "AVR32_ATTR_BUFFER_SPECIFIED";
    public static final String ATTR_ENABLE_NTAP = "AVR32_ATTR_ENABLE_NTAP";
    public static final String ATTR_ENABLE_TRACE = "AVR32_ATTR_ENABLE_TRACE";
    public static final String ATTR_OWNERSHIP_TRACE = "AVR32_ATTR_OWNERSHIP_TRACE";
    public static final String ATTR_RANGE1_ACCESS = "AVR32_ATTR_RANGE1_ACCESS";
    public static final String ATTR_RANGE2_ACCESS = "AVR32_ATTR_RANGE2_ACCESS";
    public static final String ATTR_RANGE1_LB = "AVR32_ATTR_RANGE1_LB";
    public static final String ATTR_RANGE1_UB = "AVR32_ATTR_RANGE1_UB";
    public static final String ATTR_RANGE2_LB = "AVR32_ATTR_RANGE2_LB";
    public static final String ATTR_RANGE2_UB = "AVR32_ATTR_RANGE2_UB";
    public static final String ATTR_TRACE_METHOD = "AVR32_TRACE_METHOD";
    public static final String ATTR_DEBUGGER_BUFFER_SIZE = "AVR32_ATTR_DEBUGGER_BUFFER_SIZE";
    public static final String ID_TRACEPOINT_MARKER = "com.atmel.avr32.debug.trace.TracepointMarker";
    public static final String ID_LINE_TRACEPOINT_MARKER = "com.atmel.avr32.debug.trace.LineTracepointMarker";
    public static final String ID_ADDRESS_TRACEPOINT_MARKER = "com.atmel.avr32.debug.trace.AddressTracepointMarker";
    private static TracePlugin fgDebugPlugin;
    public static final String PLUGIN_ID = "com.atmel.avr32.debug.trace";
    private static HashMap<ILaunch, TraceClient> sessions;
    private static boolean fDebugging;
    public static final String TRACE_DATA_VIEW_ID = "com.atmel.avr32.debug.trace.TraceDataView";
    private LaunchListener fLaunchListener;

    public static TracePlugin getDefault() {
        if (fgDebugPlugin == null) {
            fgDebugPlugin = new TracePlugin();
        }
        return fgDebugPlugin;
    }

    public static boolean supportsWatchpoints(IProject project) {
        DebugSystem ds;
        String id = ManagedbuildPlugin.getProjectMCU((IProject)project);
        Part p = PartRegistry.getPart((String)id);
        if (p != null && (ds = p.getDebugSystem()) != null) {
            return ds.getDataModules() != 0 || ds.getProgramModules() != 0;
        }
        return false;
    }

    public TracePlugin() {
        fgDebugPlugin = this;
    }

    public TraceClient getTraceSession(ILaunch launch) {
        return sessions.get(launch);
    }

    void addtraceSession(ILaunch launch, TraceClient client) {
        sessions.put(launch, client);
    }

    public TraceClient[] getTraceSessions() {
        return sessions.values().toArray(new TraceClient[sessions.size()]);
    }

    public boolean isDebugging() {
        return fDebugging;
    }

    public static synchronized void debug(String message) {
        if (fDebugging) {
            UtilPlugin.debug((Object)message);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        sessions = new HashMap();
        this.fLaunchListener = new LaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchListener);
        if (super.isDebugging()) {
            fDebugging = true;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchListener);
    }

    private class LaunchListener
    implements ILaunchesListener2 {
        private LaunchListener() {
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                sessions.remove(launch);
                ++n2;
            }
        }

        public void launchesTerminated(ILaunch[] launches) {
        }
    }
}

