/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace;

import com.atmel.avr32.debug.trace.Messages;
import com.atmel.avr32.debug.trace.Tracepoint;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class LineTracepoint
extends Tracepoint {
    public LineTracepoint() {
    }

    protected LineTracepoint(IResource resource, Map<String, Object> attributes, boolean register) throws CoreException {
        this.createMarker(resource, attributes, register);
    }

    public String getEndLocation() {
        return this.getMarker().getAttribute("tracepoint.end.location", "");
    }

    public String getStartLocation() {
        try {
            Pattern pattern = Pattern.compile("(([^:@]+)@)?([^,]+)(,(\\d+))?");
            Matcher matcher = pattern.matcher(this.getMarker().getAttribute("tracepoint.start.location", ""));
            boolean matchFound = matcher.find();
            StringBuffer newLocation = new StringBuffer();
            if (matchFound) {
                if (matcher.group(2) != null) {
                    newLocation.append(matcher.group(2));
                    newLocation.append("@");
                }
                if (matcher.group(3) != null) {
                    newLocation.append(this.getMarker().getResource().getLocation().toOSString());
                    IPath existingPath = this.getMarker().getResource().getFullPath();
                    IPath newPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(matcher.group(3));
                    existingPath.equals((Object)newPath);
                }
                if (matcher.group(5) != null) {
                    newLocation.append(",");
                    newLocation.append(this.getMarker().getAttribute("lineNumber"));
                }
                return newLocation.toString();
            }
            throw new IllegalArgumentException("The start location of the watchpoint trigger must be specified on the form [variable@]file[:line].");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getMarkerMessage() {
        IMarker marker = this.getMarker();
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(marker.getResource().getLocation().toOSString());
            sb.append(" [");
            sb.append(Messages.LineTracepoint_LineNumberLabel);
            sb.append(marker.getAttribute("lineNumber"));
            if (Tracepoint.Event.valueOf(marker.getAttribute("tracepoint.event", "")) != Tracepoint.Event.PROGRAM_COUNTER) {
                String location = this.getMarker().getAttribute("tracepoint.start.location", "");
                sb.append(' ');
                sb.append(Messages.LineTracepoint_VariableLabel);
                sb.append(location.substring(0, location.indexOf(64)));
            }
            sb.append("]");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public String getMarkerId() {
        return "com.atmel.avr32.debug.trace.LineTracepointMarker";
    }

    @Override
    public String getText(boolean showFullPath) {
        IMarker marker = this.getMarker();
        StringBuilder sb = new StringBuilder();
        try {
            if (showFullPath) {
                sb.append(marker.getResource().getLocation().toOSString());
            } else {
                sb.append(marker.getResource().getName());
            }
            sb.append(" [");
            sb.append(Messages.LineTracepoint_LineNumberLabel);
            sb.append(marker.getAttribute("lineNumber"));
            if (Tracepoint.Event.valueOf(marker.getAttribute("tracepoint.event", "")) != Tracepoint.Event.PROGRAM_COUNTER) {
                String location = this.getMarker().getAttribute("tracepoint.start.location", "");
                sb.append(' ');
                sb.append(Messages.LineTracepoint_VariableLabel);
                sb.append(location.substring(0, location.indexOf(64)));
            }
            sb.append("]");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

