/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace;

import com.atmel.avr32.debug.ILaunchParticipant;
import com.atmel.avr32.debug.trace.Messages;
import com.atmel.avr32.debug.trace.TracePlugin;
import com.atmel.avr32.debug.trace.client.TraceClient;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchParticipant
implements ILaunchParticipant {
    public IStatus postDebugger(ILaunch launch) {
        return Status.OK_STATUS;
    }

    public IStatus preDebugger(ILaunch launch) {
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        try {
            if (configuration.getAttribute("AVR32_ATTR_ENABLE_TRACE", false)) {
                int fInitializeTimeout = TracePlugin.getDefault().getPluginPreferences().getInt("PREF_INITIALIZE_TIMEOUT");
                int fCommunicationTimeout = TracePlugin.getDefault().getPluginPreferences().getInt("PREF_MESSAGE_TIMEOUT");
                TraceClient session = new TraceClient(launch, configuration.getName(), fInitializeTimeout, fCommunicationTimeout);
                TracePlugin.getDefault().addtraceSession(launch, session);
                IStatus status = session.init();
                if (!status.isOK()) {
                    return status;
                }
            }
        }
        catch (Exception e) {
            return new Status(4, "com.atmel.avr32.debug", Messages.TracePlugin_CouldNotStart, (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

