/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.trace;

import com.atmel.avr32.debug.trace.Tracepoint;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class AddressTracepoint
extends Tracepoint {
    private static final String ADDRESS = "address: ";
    private static final String DEFAULT_ADDRESS = "0x0";

    public AddressTracepoint() {
    }

    protected AddressTracepoint(IResource resource, Map<String, Object> attributes, boolean register) throws CoreException {
        this.createMarker(resource, attributes, register);
    }

    public IAddress getStartAddress() {
        return new Addr32(this.getMarker().getAttribute("tracepoint.start.address", DEFAULT_ADDRESS));
    }

    public IAddress getEndAddress() {
        return new Addr32(this.getMarker().getAttribute("tracepoint.end.address", DEFAULT_ADDRESS));
    }

    @Override
    public String getMarkerId() {
        return "com.atmel.avr32.debug.trace.AddressTracepointMarker";
    }

    @Override
    public String getMarkerMessage() {
        IMarker marker = this.getMarker();
        StringBuffer sb = new StringBuffer();
        sb.append(marker.getResource().getLocation().toOSString());
        sb.append(" [");
        sb.append(ADDRESS);
        sb.append(this.getStartAddress().toHexAddressString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getText(boolean showFullPath) {
        IMarker marker = this.getMarker();
        StringBuilder sb = new StringBuilder();
        if (showFullPath) {
            sb.append(marker.getResource().getLocation().toOSString());
        } else {
            sb.append(marker.getResource().getName());
        }
        sb.append(" [");
        sb.append(ADDRESS);
        sb.append(this.getStartAddress().toHexAddressString());
        sb.append("]");
        return sb.toString();
    }
}

