/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.util.math;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class BytePrefixParser {
    private static final DecimalFormat formatter = new DecimalFormat("##0");
    private static final String[] SI_UNITS = new String[]{"m", "", "k", "M", "G"};
    private static final long[] SI_VALUES = new long[]{1L, 1024L, 0x100000L, 0x40000000L};

    private static SINumber decode(String value) {
        SINumber number = new SINumber();
        if (value.length() == 0) {
            return number;
        }
        char decimalSeparator = '.';
        NumberFormat nf = NumberFormat.getInstance();
        if (nf instanceof DecimalFormat) {
            decimalSeparator = ((DecimalFormat)nf).getDecimalFormatSymbols().getDecimalSeparator();
        }
        int i = 0;
        char factor = '\u0000';
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isDigit(c) && c != decimalSeparator) {
                factor = c;
                break;
            }
            ++i;
        }
        try {
            Number num = nf.parse(value.substring(0, i));
            number.value = num.floatValue();
            if (factor != '\u0000') {
                if (factor == 'k') {
                    number.factor = 1024.0f;
                }
                if (factor == 'M') {
                    number.factor = 1048576.0f;
                }
                if (factor == 'G') {
                    number.factor = 1.0737418E9f;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return number;
    }

    public static long getLong(String value) {
        SINumber number = BytePrefixParser.decode(value);
        return (long)(number.value * number.factor);
    }

    public static int getInt(String value) {
        SINumber number = BytePrefixParser.decode(value);
        return (int)(number.value * number.factor);
    }

    public static String getString(long value) {
        String rv = formatter.format(value);
        int a = 0;
        while (a < SI_VALUES.length) {
            if (value >= SI_VALUES[a]) {
                long v = value / SI_VALUES[a];
                rv = String.valueOf(formatter.format(v)) + SI_UNITS[a];
            }
            ++a;
        }
        return rv;
    }

    private static class SINumber {
        float value = 0.0f;
        float factor = 1.0f;

        private SINumber() {
        }
    }
}

