/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.util;

import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.framework.BundleContext;

public class UtilPlugin
extends Plugin {
    private static ColorRegistry cr = null;
    private static IOConsoleOutputStream fDefaultConsoleStream;
    private static IOConsoleOutputStream fErrorConsoleStream;
    private static MessageConsole fConsole;
    private static final String INFO_KEY = "com.atmel.avr32.console.color.info";
    private static final String ERROR_KEY = "com.atmel.avr32.console.color.error";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        cr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.initDebugStream();
    }

    private static MessageConsole getConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private void setColours() {
        fDefaultConsoleStream.setColor(cr.get(INFO_KEY));
        fErrorConsoleStream.setColor(cr.get(ERROR_KEY));
    }

    private void initDebugStream() {
        fConsole = UtilPlugin.getConsole("AVR32 Console");
        fDefaultConsoleStream = fConsole.newOutputStream();
        fErrorConsoleStream = fConsole.newOutputStream();
        this.setColours();
        cr.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                UtilPlugin.this.setColours();
            }
        });
    }

    public static void print(Object message) {
        if (fDefaultConsoleStream != null) {
            try {
                fDefaultConsoleStream.write(message.toString());
            }
            catch (IOException iOException) {}
        }
    }

    public static void println(Object message) {
        if (fDefaultConsoleStream != null) {
            try {
                fDefaultConsoleStream.write(message.toString());
                fDefaultConsoleStream.write(10);
            }
            catch (IOException iOException) {}
        }
    }

    public static void error(Object message) {
        if (fErrorConsoleStream != null) {
            try {
                fErrorConsoleStream.write(message.toString());
                fErrorConsoleStream.write(10);
            }
            catch (IOException iOException) {}
        }
        if (message instanceof Exception) {
            ((Exception)message).printStackTrace();
        }
    }

    public static void debug(Object message) {
        System.out.println(message);
    }
}

