/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Tools {
    public static void insertNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void addBuilder(IProjectDescription desc, String id) {
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(id)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(id);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 1, commands.length);
        nc[0] = command;
        desc.setBuildSpec(nc);
    }

    public static void unzip(IProject p, File f, IProgressMonitor monitor) {
        try {
            ZipFile zipFile = new ZipFile(f);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            monitor.beginTask("Uncompressing", zipFile.size() * 3);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                IFile file = p.getFile(entry.getName());
                Tools.createFolder(p, file, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (!entry.isDirectory() && file.exists()) {
                    file.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (!entry.isDirectory()) {
                    file.create(zipFile.getInputStream(entry), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                monitor.worked(1);
            }
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void extractProject(String name, File f, IProgressMonitor monitor) {
        try {
            ZipFile zipFile = new ZipFile(f);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            monitor.beginTask("Uncompressing", zipFile.size() * 3);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            project.create(monitor);
            project.open(monitor);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(entry.getName()));
                if (file.getProject().equals((Object)project)) {
                    Tools.createFolder(project, file, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!entry.isDirectory() && file.exists()) {
                        file.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.worked(1);
                    }
                    if (!entry.isDirectory()) {
                        file.create(zipFile.getInputStream(entry), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        continue;
                    }
                    monitor.worked(1);
                    continue;
                }
                monitor.worked(2);
            }
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void createFolder(IProject project, IFile to, IProgressMonitor monitor) {
        String[] segments = to.getProjectRelativePath().segments();
        monitor.beginTask("Creating folders", 1);
        try {
            if (segments.length > 1) {
                IFolder root = null;
                int x = 0;
                while (x < segments.length - 1) {
                    root = x == 0 ? project.getFolder(segments[x]) : root.getFolder(segments[x]);
                    if (!root.exists()) {
                        root.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        monitor.worked(1);
    }
}

