/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.intro;

import com.atmel.avr32.intro.IntroPlugin;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.framework.BundleContext;

public class P2Util {
    static IInstallableUnit[] gatherAvailableInstallableUnits(IInstallableUnit[] additionalSource, URI[] repositories, ProvisioningContext context, IProgressMonitor monitor) {
        HashMap<String, IInstallableUnit> resultsMap = new HashMap<String, IInstallableUnit>();
        if (additionalSource != null) {
            int i = 0;
            while (i < additionalSource.length) {
                String key = String.valueOf(additionalSource[i].getId()) + "_" + additionalSource[i].getVersion().toString();
                resultsMap.put(key, additionalSource[i]);
                ++i;
            }
        }
        if (context != null) {
            for (IInstallableUnit iu : context.getExtraIUs()) {
                String key = String.valueOf(iu.getId()) + '_' + iu.getVersion().toString();
                resultsMap.put(key, iu);
            }
        }
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)IMetadataRepositoryManager.class.getName());
        if (repositories == null) {
            repositories = repoMgr.getKnownRepositories(0);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 200));
        int i = 0;
        while (i < repositories.length) {
            try {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IMetadataRepository repository = repoMgr.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                Collector matches = repository.query((Query)new InstallableUnitQuery(null, VersionRange.emptyRange), new Collector(), (IProgressMonitor)sub.newChild(100));
                for (IInstallableUnit iu : matches) {
                    String key = String.valueOf(iu.getId()) + "_" + iu.getVersion().toString();
                    IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
                    if (currentIU != null && !P2Util.hasHigherFidelity(iu, currentIU)) continue;
                    resultsMap.put(key, iu);
                }
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        Collection results = resultsMap.values();
        return results.toArray(new IInstallableUnit[results.size()]);
    }

    private static boolean hasHigherFidelity(IInstallableUnit iu, IInstallableUnit currentIU) {
        return Boolean.valueOf(currentIU.getProperty("org.eclipse.equinox.p2.partial.iu")) != false && Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")) == false;
    }

    public static Dictionary createSelectionContext(Map properties) {
        Hashtable<String, String> result = new Hashtable<String, String>(properties);
        String environments = (String)properties.get("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            int i = entry.indexOf(61);
            String key = entry.substring(0, i).trim();
            String value = entry.substring(i + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    static boolean checkForUpdates() {
        IProfileRegistry profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IProfileRegistry.class.getName());
        if (profileRegistry == null) {
            System.err.println("No profile registry!");
            return false;
        }
        final IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            System.err.println("No profile!");
            return false;
        }
        final Collector collector = profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        if (collector.isEmpty()) {
            System.out.println("No features found in profile!");
            return false;
        }
        final IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IMetadataRepositoryManager.class.getName());
        if (manager == null) {
            return false;
        }
        final URI[] reposToSearch = manager.getKnownRepositories(0);
        if (reposToSearch.length == 0) {
            return false;
        }
        final IPlanner planner = (IPlanner)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IPlanner.class.getName());
        if (planner == null) {
            return false;
        }
        boolean[] didWeUpdate = new boolean[]{false};
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for application updates...", (int)400);
                SubMonitor loadMonitor = sub.newChild(100, 7);
                int i = 0;
                while (i < reposToSearch.length) {
                    try {
                        if (loadMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        manager.loadRepository(reposToSearch[i], (IProgressMonitor)loadMonitor.newChild(100 / reposToSearch.length));
                    }
                    catch (ProvisionException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                loadMonitor.done();
                ArrayList<IInstallableUnit> iusWithUpdates = new ArrayList<IInstallableUnit>();
                ArrayList<IInstallableUnit> replacementIUs = new ArrayList<IInstallableUnit>();
                Iterator iter = collector.iterator();
                ProvisioningContext pc = new ProvisioningContext(reposToSearch);
                SubMonitor updateSearchMonitor = sub.newChild(100, 7);
                while (iter.hasNext()) {
                    if (updateSearchMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IInstallableUnit iu = (IInstallableUnit)iter.next();
                    IInstallableUnit[] replacements = planner.updatesFor(iu, pc, (IProgressMonitor)updateSearchMonitor.newChild(100 / collector.size()));
                    if (replacements.length <= 0) continue;
                    iusWithUpdates.add(iu);
                    if (replacements.length == 1) {
                        replacementIUs.add(replacements[0]);
                        continue;
                    }
                    IInstallableUnit repl = replacements[0];
                    int i2 = 1;
                    while (i2 < replacements.length) {
                        if (replacements[i2].getVersion().compareTo((Object)repl.getVersion()) > 0) {
                            repl = replacements[i2];
                        }
                        ++i2;
                    }
                    replacementIUs.add(repl);
                }
                if (iusWithUpdates.size() == 0) {
                    sub.done();
                } else {
                    if (sub.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
                    changeRequest.removeInstallableUnits(iusWithUpdates.toArray(new IInstallableUnit[iusWithUpdates.size()]));
                    changeRequest.addInstallableUnits(replacementIUs.toArray(new IInstallableUnit[replacementIUs.size()]));
                    ProvisioningPlan plan = planner.getProvisioningPlan(changeRequest, pc, (IProgressMonitor)sub.newChild(100, 7));
                    if (plan.getStatus().getSeverity() == 8) {
                        throw new InterruptedException();
                    }
                    if (plan.getStatus().getSeverity() != 4) {
                        IEngine engine = (IEngine)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IEngine.class.getName());
                        IArtifactRepositoryManager artifactMgr = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IArtifactRepositoryManager.class.getName());
                        if (engine != null && artifactMgr != null) {
                            Operand[] ops;
                            pc.setArtifactRepositories(artifactMgr.getKnownRepositories(0));
                            Operand[] operandArray = ops = plan.getOperands();
                            int n = ops.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Operand o = operandArray[n2];
                                System.out.println(o);
                                ++n2;
                            }
                        }
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(null).run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return didWeUpdate[0];
    }

    static IStatus install(final String id) {
        IProfileRegistry profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IProfileRegistry.class.getName());
        if (profileRegistry == null) {
            return Status.CANCEL_STATUS;
        }
        final IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            return new Status(4, "com.atmel.avr32.intro", "There is no available p2 profile.");
        }
        final IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IMetadataRepositoryManager.class.getName());
        if (manager == null) {
            return new Status(4, "com.atmel.avr32.intro", "The repository manager is not available.");
        }
        final URI[] reposToSearch = manager.getKnownRepositories(0);
        if (reposToSearch.length == 0) {
            return new Status(4, "com.atmel.avr32.intro", "No available repositories.");
        }
        final IPlanner planner = (IPlanner)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IPlanner.class.getName());
        if (planner == null) {
            return new Status(4, "com.atmel.avr32.intro", "The planner service is not available.");
        }
        Collector installed = profile.query((Query)new InstallableUnitQuery(id), new Collector(), null);
        if (!installed.isEmpty()) {
            return new Status(8, "com.atmel.avr32.intro", "The requested software is already installed. Please use the update manager if you wish to upgrade to a newer version.");
        }
        final MultiStatus ms = new MultiStatus("com.atmel.avr32.intro", 0, "", null);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading repositories...", (int)400);
                SubMonitor loadMonitor = sub.newChild(100, 7);
                int i = 0;
                while (i < reposToSearch.length) {
                    try {
                        if (loadMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        manager.refreshRepository(reposToSearch[i], (IProgressMonitor)loadMonitor.newChild(100 / reposToSearch.length));
                    }
                    catch (ProvisionException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                loadMonitor.done();
                Collector collector = manager.query((Query)new InstallableUnitQuery(id), new Collector(), null);
                if (collector.isEmpty()) {
                    ms.add((IStatus)new Status(4, "com.atmel.avr32.intro", "The requested installable unit " + id + " is not available."));
                }
                SubMonitor installMonitor = sub.newChild(100, 7);
                ProvisioningContext pc = new ProvisioningContext(reposToSearch);
                ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
                changeRequest.addInstallableUnits(collector.toCollection().toArray(new IInstallableUnit[collector.toCollection().size()]));
                ProvisioningPlan plan = planner.getProvisioningPlan(changeRequest, pc, (IProgressMonitor)installMonitor.newChild(100, 7));
                if (plan.getStatus().getSeverity() == 8) {
                    throw new InterruptedException();
                }
                if (plan.getStatus().getSeverity() != 4) {
                    IEngine engine = (IEngine)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IEngine.class.getName());
                    IArtifactRepositoryManager artifactMgr = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IArtifactRepositoryManager.class.getName());
                    if (engine != null && artifactMgr != null) {
                        pc.setArtifactRepositories(artifactMgr.getKnownRepositories(0));
                        IStatus status = engine.perform(profile, (PhaseSet)new DefaultPhaseSet(), plan.getOperands(), pc, (IProgressMonitor)sub.newChild(100, 7));
                        ms.add(status);
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(null).run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            return new Status(4, "com.atmel.avr32.intro", "Error when installing.", (Throwable)e);
        }
        catch (InterruptedException e) {
            return new Status(4, "com.atmel.avr32.intro", "Error when installing.", (Throwable)e);
        }
        return ms;
    }

    public static URI[] getOptionalRepos() {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IMetadataRepositoryManager.class.getName());
        if (manager == null) {
            return new URI[0];
        }
        URI[] repos = manager.getKnownRepositories(0);
        ArrayList<URI> filtered = new ArrayList<URI>();
        URI[] uRIArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (uri.getHost().contains(".atmel.") && (uri.getPath().contains("/optionals/") || uri.getPath().contains("/releases/"))) {
                filtered.add(uri);
                System.out.println(uri);
            }
            ++n2;
        }
        return filtered.toArray(new URI[filtered.size()]);
    }
}

