/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.intro;

import com.atmel.avr32.intro.IntroPlugin;
import com.atmel.avr32.intro.Messages;
import com.atmel.avr32.intro.P2Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.IntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AVR32StudioIntroPart
extends IntroPart {
    private static final String DECORATOR_FONT = "com.atmel.avr32.intro.decoratorFont";
    private Action exampleAction;
    private static final int CARD_HEIGHT = 130;
    private static final int HEADING_HEIGHT = 22;
    private static final int CARD_WIDTH = 300;
    private int currentPage = 1;
    private static final String CARDS_EXTENSION_ID = "com.atmel.avr32.intro.cards";
    private static final int CORNER_SIZE = 8;
    private static final String DEFAULT_PERSPECTIVE = "com.atmel.avr32.AVR32Perspective";
    private static final String EMPTY = "";
    private static FontRegistry fr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
    static Color gradientBottom;
    static Color gradientTop;
    private static final String HREF_ATTRIBUTE = "href";
    private static final String IMAGE_ATTRIBUTE = "image";
    private static final int IMAGE_PADDING = 5;
    private static ArrayList<Image> images;
    private static final String LABEL_ATTRIBUTE = "label";
    private static final int LINE_OFFSET = 18;
    private static final int LINK_BOX_H_OFFSET = 160;
    private static final int LINK_BOX_V_OFFSET = 20;
    private static final int LINK_BOX_WIDTH = 160;
    private static final String LINK_ELEMENT = "link";
    private static final int LINK_TEXT_HEIGHT = 16;
    private static final String NAME_ATTRIBUTE = "name";
    private static final String NEWLINE = "\n";
    private static final String ORDER_ATTRIBUTE = "order";
    private static final String CATEGORY_ATTRIBUTE = "category";
    private static final String PAGE_1 = "1";
    private static final String PAGE_2 = "2";
    private static final String PAGE_3 = "3";
    private static final String PAGE_4 = "4";
    private static final String PAGE_5 = "5";
    private static final String PAGE_PROTOCOL = "page://";
    private static final String PROTOCOL_ACTION = "cheat://";
    private static final String PROTOCOL_HELP = "help://";
    private static final String PROTOCOL_HTTP = "http://";
    private static final String PROTOCOL_INSTALL = "install://";
    private static final RGB RGB_ATMEL;
    private static final RGB RGB_BORDER;
    private static final RGB RGB_BOTTOM;
    private static final RGB RGB_LINKS;
    private static final RGB RGB_TOP;
    private static final String UPDATE_PROTOCOL = "update://";
    private static final String WELCOME_HTML = "pages/welcome.html";
    private Image background;
    Color backgroundBottom;
    Color backgroundColor;
    Color pageSelectedColor;
    Color backgroundTop;
    Color borderColor;
    private HyperLinkListener fHyperLinkListener = null;
    ArrayList<ImageHyperlink> fHyperlinks;
    private FormToolkit formToolkit = null;
    private Composite header;
    private HyperlinkGroup hyperlinkGroup = null;
    private Composite introSection;
    Image menu_Workbench;
    private ScrolledPageBook pageBook;
    Image toolbg;
    private FormText optionalFeaturesWidget;
    int newFeaturesCount;
    private Composite quickLinkSection;

    static {
        RGB_ATMEL = new RGB(0, 116, 193);
        RGB_BORDER = new RGB(185, 181, 186);
        RGB_BOTTOM = new RGB(212, 208, 196);
        RGB_LINKS = new RGB(220, 217, 208);
        RGB_TOP = new RGB(240, 236, 232);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void addDebuggingPage(Composite parent) {
        this.createSection(parent, "Debugging", "pages/debugging_intro.form", false);
        Label ladybug = this.formToolkit.createLabel(parent, EMPTY);
        ladybug.setBackgroundImage(this.createImage("graphics/ladybug.png"));
        GridData gd2 = new GridData(131072, 128, true, false);
        gd2.widthHint = 189;
        gd2.heightHint = 120;
        ladybug.setLayoutData((Object)gd2);
        this.createSection(parent, "General", "pages/debugging_general.form", true);
        this.createSection(parent, "Breakpoints", "pages/debugging_breakpoints.form", true);
        this.createSection(parent, "Watchpoints", "pages/debugging_watchpoints.form", true);
        this.createSection(parent, "Tracepoints", "pages/debugging_tracepoints.form", true);
        parent.pack(true);
    }

    private void addEditorPage(Composite parent) {
        this.createSection(parent, "The C/C++ Editor", "pages/editing_intro.form", false);
        Label ladybug = this.formToolkit.createLabel(parent, EMPTY);
        ladybug.setBackgroundImage(this.createImage("graphics/ladybug.png"));
        GridData gd2 = new GridData(131072, 128, true, false);
        gd2.widthHint = 189;
        gd2.heightHint = 120;
        ladybug.setLayoutData((Object)gd2);
        this.createSection(parent, "Features", "pages/editing_summary.form", true);
        this.createSection(parent, "Templates", "pages/editing_templates.form", true);
        this.createSection(parent, "Macro expansion", "pages/editing_macro.form", true);
        this.createSection(parent, "Content Assist", "pages/editing_assist.form", true);
        parent.pack(true);
    }

    private void addIntroduction(Composite parent) {
        this.createSection(parent, "Introduction", "pages/introduction_intro.html", false);
        Label ladybug = this.formToolkit.createLabel(parent, EMPTY);
        ladybug.setBackgroundImage(this.createImage("graphics/ladybug.png"));
        GridData gd2 = new GridData(131072, 128, true, false);
        gd2.widthHint = 189;
        gd2.heightHint = 120;
        ladybug.setLayoutData((Object)gd2);
        this.createOptionalsSection(parent, "Optional features");
        this.createSection(parent, "Creating projects", "pages/introduction_creating.html", true);
        this.createSection(parent, "Updating projects", "pages/introduction_updating.html", true);
        this.createSection(parent, "Importing and exporting", "pages/introduction_importing.html", true);
        parent.pack(true);
    }

    private void addIntroSection(Composite parent) {
        this.introSection = this.formToolkit.createComposite(parent);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 480;
        this.introSection.setLayoutData((Object)gd);
        GridLayout introSectionLayout = new GridLayout();
        introSectionLayout.marginHeight = 0;
        this.introSection.setLayout((Layout)introSectionLayout);
        this.addPageHeader(this.introSection);
        this.pageBook = this.formToolkit.createPageBook(this.introSection, 512);
        this.pageBook.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addQuickLinks(this.introSection);
        this.addWelcome(this.createPage(PAGE_1));
        this.addIntroduction(this.createPage(PAGE_2));
        this.addEditorPage(this.createPage(PAGE_3));
        this.addTargetPage(this.createPage(PAGE_4));
        this.addDebuggingPage(this.createPage(PAGE_5));
        this.pageBook.showPage((Object)PAGE_1);
    }

    private void addPageHeader(Composite parent) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.intro", (String)"graphics/AVR32.png");
        final Image img = desc.createImage();
        images.add(img);
        this.header = new Composite(parent, 0);
        this.header.setBackground(this.backgroundColor);
        this.header.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setAdvanced(true);
                e.gc.setBackground(AVR32StudioIntroPart.this.backgroundTop);
                int width = ((AVR32StudioIntroPart)AVR32StudioIntroPart.this).header.getSize().x;
                int height = ((AVR32StudioIntroPart)AVR32StudioIntroPart.this).header.getSize().y;
                if (e.gc.getAdvanced()) {
                    e.gc.setAntialias(1);
                    org.eclipse.swt.graphics.Path path = new org.eclipse.swt.graphics.Path(e.gc.getDevice());
                    path.moveTo(0.0f, 0.0f);
                    path.lineTo((float)width, 0.0f);
                    path.lineTo((float)width, (float)(height - 8));
                    path.quadTo((float)width, (float)height, (float)(width - 8), (float)height);
                    path.lineTo(8.0f, (float)height);
                    path.quadTo(0.0f, (float)height, 0.0f, (float)(height - 8));
                    path.lineTo(0.0f, 0.0f);
                    path.close();
                    e.gc.setClipping(path);
                }
                e.gc.fillRectangle(0, 0, width, height);
                e.gc.drawImage(img, width / 2 - img.getBounds().width / 2, height - img.getBounds().height - 4);
            }
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 60;
        gd.verticalAlignment = 1;
        this.header.setLayoutData((Object)gd);
    }

    private void addQuickLinks(Composite parent) {
        this.quickLinkSection = this.formToolkit.createComposite(parent);
        GridData gd = new GridData(4, 0x1000008, true, false);
        GridLayout gl = new GridLayout(6, true);
        gl.marginHeight = 0;
        this.quickLinkSection.setLayout((Layout)gl);
        this.quickLinkSection.setLayoutData((Object)gd);
        this.quickLinkSection.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setAdvanced(true);
                e.gc.setBackground(AVR32StudioIntroPart.this.backgroundBottom);
                int width = ((AVR32StudioIntroPart)AVR32StudioIntroPart.this).quickLinkSection.getSize().x;
                int height = ((AVR32StudioIntroPart)AVR32StudioIntroPart.this).quickLinkSection.getSize().y;
                if (e.gc.getAdvanced()) {
                    e.gc.setAntialias(1);
                    org.eclipse.swt.graphics.Path path = new org.eclipse.swt.graphics.Path(e.gc.getDevice());
                    path.moveTo(0.0f, 8.0f);
                    path.quadTo(0.0f, 0.0f, 8.0f, 0.0f);
                    path.lineTo((float)(width - 8), 0.0f);
                    path.quadTo((float)width, 0.0f, (float)width, 8.0f);
                    path.lineTo((float)width, (float)height);
                    path.lineTo(0.0f, (float)height);
                    path.lineTo(0.0f, 8.0f);
                    path.close();
                    e.gc.setClipping(path);
                }
                e.gc.fillRectangle(0, 0, width, height);
            }
        });
        this.createQuickLink(this.quickLinkSection, "Welcome", "graphics/about_welcome.png", "page://1");
        this.createQuickLink(this.quickLinkSection, Messages.AVR32StudioIntroPart_Project, "graphics/about_projects.png", "page://2");
        this.createQuickLink(this.quickLinkSection, Messages.AVR32StudioIntroPart_Programming, "graphics/about_programming.png", "page://3");
        this.createQuickLink(this.quickLinkSection, Messages.AVR32StudioIntroPart_Target, "graphics/about_targets.png", "page://4");
        this.createQuickLink(this.quickLinkSection, Messages.AVR32StudioIntroPart_Debugging, "graphics/about_debugging.png", "page://5");
        this.createQuickLink(this.quickLinkSection, Messages.AVR32StudioIntroPart_Close, "graphics/exit_to_workbench.png", "exit");
    }

    private void addTargetPage(Composite parent) {
        this.createSection(parent, "Targets", "pages/target_intro.form", false);
        Label ladybug = this.formToolkit.createLabel(parent, EMPTY);
        ladybug.setBackgroundImage(this.createImage("graphics/ladybug.png"));
        GridData gd2 = new GridData(131072, 128, true, false);
        gd2.widthHint = 189;
        gd2.heightHint = 120;
        ladybug.setLayoutData((Object)gd2);
        this.createSection(parent, "Managing", "pages/target_managing.form", true);
        this.createSection(parent, "Operations", "pages/target_operations.form", true);
        this.createSection(parent, "Fuses", "pages/target_fuses.form", true);
    }

    private void addToolsSection(Composite parent) {
        ScrolledComposite scrollable = new ScrolledComposite(parent, 768);
        scrollable.setMinWidth(300);
        GridData hd = new GridData(4, 4, false, true);
        scrollable.setLayoutData((Object)hd);
        scrollable.setBackground(this.backgroundColor);
        scrollable.setExpandHorizontal(true);
        scrollable.setExpandVertical(true);
        Composite contents = new Composite((Composite)scrollable, 0);
        scrollable.setContent((Control)contents);
        RowLayout rl = new RowLayout(512);
        rl.wrap = false;
        contents.setLayout((Layout)rl);
        contents.setBackground(this.backgroundColor);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(CARDS_EXTENSION_ID);
        IConfigurationElement[] points = extensionPoint.getConfigurationElements();
        ArrayList<IConfigurationElement> sortedList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            sortedList.add(element);
            ++n2;
        }
        Collections.sort(sortedList, new PresentationCardSorter());
        int h = 0;
        String category = EMPTY;
        for (IConfigurationElement element : sortedList) {
            ImageDescriptor desc;
            if (!element.getAttribute(CATEGORY_ATTRIBUTE).equals(category)) {
                category = element.getAttribute(CATEGORY_ATTRIBUTE);
                this.addHeading(contents, category);
            }
            int card_height = 130;
            double scale = 1.0;
            if (element.getAttribute("size") != null && element.getAttribute("size").equals("half")) {
                card_height /= 2;
                scale = 0.5;
            }
            ++h;
            Image img = null;
            String name = element.getAttribute(NAME_ATTRIBUTE);
            String image = element.getAttribute(IMAGE_ATTRIBUTE);
            if (image != null && (desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)image)) != null) {
                ImageData id = desc.getImageData();
                int width = (int)((double)id.width * scale);
                int height = (int)((double)id.height * scale);
                id = id.scaledTo(width, height);
                img = new Image((Device)this.header.getDisplay(), id);
                images.add(img);
            }
            Composite toolComposite = new Composite(contents, 1);
            toolComposite.setBackground(this.backgroundColor);
            RowData rd = new RowData();
            rd.width = 300;
            rd.height = card_height;
            toolComposite.setLayoutData((Object)rd);
            toolComposite.addPaintListener((PaintListener)new PresentationCardPainter(img, name, card_height));
            this.createLinkGroup(element, toolComposite, name);
            toolComposite.computeSize(-1, -1);
        }
        scrollable.setMinSize(contents.computeSize(-1, -1));
    }

    private void addHeading(Composite contents, String label) {
        RowData rd = new RowData();
        rd.width = 300;
        rd.height = 22;
        Label heading = new Label(contents, 0);
        heading.setBackground(this.backgroundColor);
        heading.setForeground(this.borderColor);
        heading.addPaintListener((PaintListener)new HeadingPainter(label));
        heading.setLayoutData((Object)rd);
    }

    private void addWelcome(Composite parent) {
        Label ladybug = this.formToolkit.createLabel(parent, EMPTY);
        ladybug.setBackgroundImage(this.createImage("graphics/ladybug.png"));
        GridData gd2 = new GridData(131072, 128, true, false);
        gd2.horizontalSpan = 2;
        gd2.widthHint = 189;
        gd2.heightHint = 120;
        ladybug.setLayoutData((Object)gd2);
        FormText browser = this.formToolkit.createFormText(parent, false);
        browser.setBackground(this.backgroundColor);
        browser.addHyperlinkListener((IHyperlinkListener)new HyperLinkListener());
        browser.setParagraphsSeparated(true);
        browser.setHyperlinkSettings((HyperlinkSettings)this.hyperlinkGroup);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        browser.setLayoutData((Object)gd);
        Path path = new Path(WELCOME_HTML);
        this.loadHTML(browser, path);
        parent.pack(true);
    }

    private void createBackgroundImage() {
        Display d = AVR32StudioIntroPart.getStandardDisplay();
        this.background = new Image((Device)d, 300, 130);
        GC gc = new GC((Drawable)this.background);
        gc.setAdvanced(true);
        org.eclipse.swt.graphics.Path path = null;
        Rectangle oldClipping = null;
        if (gc.getAdvanced()) {
            gc.setAntialias(1);
            oldClipping = gc.getClipping();
            path = this.createClippingPath(gc, 130);
            gc.setClipping(path);
        }
        gc.setForeground(gradientTop);
        gc.setBackground(gradientBottom);
        gc.fillGradientRectangle(0, 0, 300, 130, true);
        gc.setForeground(this.borderColor);
        gc.drawLine(0, 18, 300, 18);
        gc.setForeground(AVR32StudioIntroPart.getStandardDisplay().getSystemColor(1));
        gc.drawLine(0, 19, 300, 19);
        if (gc.getAdvanced()) {
            gc.setClipping(oldClipping);
            path.dispose();
        }
        gc.copyArea(this.background, 0, 0);
        gc.dispose();
    }

    private org.eclipse.swt.graphics.Path createClippingPath(GC gc, int height) {
        if (!gc.getAdvanced()) {
            return null;
        }
        int adjustment = 1;
        org.eclipse.swt.graphics.Path path = new org.eclipse.swt.graphics.Path(gc.getDevice());
        path.moveTo(0.0f, 8.0f);
        path.quadTo(0.0f, 0.0f, 8.0f, 0.0f);
        path.lineTo((float)(292 - adjustment), 0.0f);
        path.quadTo((float)(300 - adjustment), 0.0f, (float)(300 - adjustment), 8.0f);
        path.lineTo((float)(300 - adjustment), (float)(height - 8 - adjustment));
        path.quadTo((float)(300 - adjustment), (float)(height - adjustment), (float)(292 - adjustment), (float)(height - adjustment));
        path.lineTo(8.0f, (float)(height - adjustment));
        path.quadTo(0.0f, (float)height, 0.0f, (float)(height - 8 - adjustment));
        path.lineTo(0.0f, 8.0f);
        path.close();
        return path;
    }

    private org.eclipse.swt.graphics.Path createHeadingClippingPath(GC gc) {
        if (!gc.getAdvanced()) {
            return null;
        }
        int adjustment = 1;
        org.eclipse.swt.graphics.Path path = new org.eclipse.swt.graphics.Path(gc.getDevice());
        path.moveTo(0.0f, 8.0f);
        path.quadTo(0.0f, 0.0f, 8.0f, 0.0f);
        path.lineTo((float)(292 - adjustment), 0.0f);
        path.quadTo((float)(300 - adjustment), 0.0f, (float)(300 - adjustment), 8.0f);
        path.lineTo((float)(300 - adjustment), (float)(14 - adjustment));
        path.quadTo((float)(300 - adjustment), (float)(22 - adjustment), (float)(292 - adjustment), (float)(22 - adjustment));
        path.lineTo(8.0f, (float)(22 - adjustment));
        path.quadTo(0.0f, 22.0f, 0.0f, (float)(14 - adjustment));
        path.lineTo(0.0f, 8.0f);
        path.close();
        return path;
    }

    private Image createImage(String image) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.intro", (String)image);
        Image img = desc.createImage();
        images.add(img);
        return img;
    }

    private void createLinkGroup(IConfigurationElement element, Composite toolComposite, String name) {
        IConfigurationElement[] links;
        int offset = 20;
        IConfigurationElement[] iConfigurationElementArray = links = element.getChildren(LINK_ELEMENT);
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement link = iConfigurationElementArray[n2];
            HyperLink hlink = new HyperLink(toolComposite, 0, offset);
            this.formToolkit.adapt((Control)hlink, true, true);
            this.formToolkit.getHyperlinkGroup().add((Hyperlink)hlink);
            hlink.setBounds(160, offset, 160, 16);
            hlink.setText(link.getAttribute(LABEL_ATTRIBUTE));
            hlink.setHref(link.getAttribute(HREF_ATTRIBUTE));
            hlink.addHyperlinkListener((IHyperlinkListener)this.fHyperLinkListener);
            hlink.pack(false);
            offset += 16;
            ++n2;
        }
    }

    private Composite createPage(String id) {
        Composite page = this.pageBook.createPage((Object)id);
        GridLayout gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        page.setLayout((Layout)gl);
        page.pack(false);
        return page;
    }

    public void createPartControl(Composite parent) {
        try {
            this.fHyperlinks = new ArrayList();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            this.fillIntroductionPage(parent);
            this.exampleAction = new NewExampleAction(window);
            this.listOptionals();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createQuickLink(Composite parent, String title, String icon, final String url) {
        GridData gd = new GridData(768);
        gd.minimumWidth = 64;
        gd.minimumHeight = 48;
        Image defaultImage = this.createImage(icon);
        ImageHyperlink ihl = this.formToolkit.createImageHyperlink(parent, 0);
        ihl.setLayoutData((Object)gd);
        ihl.setToolTipText(title);
        ihl.setImage(defaultImage);
        ihl.setHref((Object)url);
        ihl.addHyperlinkListener((IHyperlinkListener)this.fHyperLinkListener);
        ihl.setBackground(this.backgroundBottom);
        if (url.startsWith(PAGE_PROTOCOL)) {
            ihl.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    int thisPage = Integer.decode(url.substring(7));
                    if (AVR32StudioIntroPart.this.currentPage == thisPage) {
                        e.gc.setAdvanced(true);
                        e.gc.setAntialias(1);
                        e.gc.drawOval(26, 11, 40, 40);
                    }
                    if (AVR32StudioIntroPart.this.newFeaturesCount > 0 && thisPage == 2) {
                        e.gc.setAdvanced(true);
                        e.gc.setAntialias(1);
                        String label = Integer.toString(AVR32StudioIntroPart.this.newFeaturesCount);
                        Point p = e.gc.textExtent(label);
                        e.gc.setForeground(Display.getDefault().getSystemColor(15));
                        e.gc.setBackground(Display.getDefault().getSystemColor(15));
                        e.gc.fillOval(22, 7, 15, 15);
                        e.gc.setForeground(Display.getDefault().getSystemColor(1));
                        Font font = fr.get(AVR32StudioIntroPart.DECORATOR_FONT);
                        e.gc.setFont(font);
                        e.gc.drawText(Integer.toString(AVR32StudioIntroPart.this.newFeaturesCount), 29 - p.x / 2, 13 - p.y / 2, true);
                    }
                }
            });
        }
        this.fHyperlinks.add(ihl);
    }

    private void createSection(Composite parent, String title, String path, boolean header) {
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        int flags = 64;
        if (header) {
            flags |= 0x100;
        }
        Section section = this.formToolkit.createSection(parent, flags);
        section.setLayoutData((Object)gd);
        section.setText(title);
        FormText browser = this.formToolkit.createFormText((Composite)section, false);
        browser.setBackground(this.backgroundColor);
        browser.addHyperlinkListener((IHyperlinkListener)new HyperLinkListener());
        browser.setParagraphsSeparated(true);
        browser.setHyperlinkSettings((HyperlinkSettings)this.hyperlinkGroup);
        browser.setLayoutData((Object)gd);
        section.setClient((Control)browser);
        this.loadHTML(browser, new Path(path));
    }

    private void createOptionalsSection(Composite parent, String title) {
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        int flags = 64;
        Section section = this.formToolkit.createSection(parent, flags |= 0x100);
        section.setLayoutData((Object)gd);
        section.setText(title);
        this.optionalFeaturesWidget = this.formToolkit.createFormText((Composite)section, false);
        this.optionalFeaturesWidget.setBackground(this.backgroundColor);
        this.optionalFeaturesWidget.addHyperlinkListener((IHyperlinkListener)new HyperLinkListener());
        this.optionalFeaturesWidget.setParagraphsSeparated(true);
        this.optionalFeaturesWidget.setHyperlinkSettings((HyperlinkSettings)this.hyperlinkGroup);
        this.optionalFeaturesWidget.setLayoutData((Object)gd);
        section.setClient((Control)this.optionalFeaturesWidget);
        this.optionalFeaturesWidget.setWhitespaceNormalized(true);
        this.setBrowserImages(this.optionalFeaturesWidget);
        this.optionalFeaturesWidget.setText("<form><p><b>Please wait...</b></p></form>", true, false);
    }

    private void deregister() {
        if (this.fHyperlinks != null && this.fHyperLinkListener != null) {
            for (ImageHyperlink link : this.fHyperlinks) {
                link.removeHyperlinkListener((IHyperlinkListener)this.fHyperLinkListener);
            }
        }
    }

    private void displayHelpResource(String resource) {
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(resource);
    }

    public void dispose() {
        this.deregister();
        if (images != null) {
            for (Image image : images) {
                image.dispose();
            }
        }
        super.dispose();
    }

    private void fillIntroductionPage(Composite parent) {
        this.backgroundColor = AVR32StudioIntroPart.getStandardDisplay().getSystemColor(1);
        gradientTop = new Color((Device)AVR32StudioIntroPart.getStandardDisplay(), RGB_TOP);
        gradientBottom = new Color((Device)AVR32StudioIntroPart.getStandardDisplay(), RGB_BOTTOM);
        this.backgroundTop = new Color((Device)AVR32StudioIntroPart.getStandardDisplay(), RGB_ATMEL);
        this.backgroundBottom = new Color((Device)AVR32StudioIntroPart.getStandardDisplay(), RGB_LINKS);
        this.borderColor = new Color((Device)AVR32StudioIntroPart.getStandardDisplay(), RGB_BORDER);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        parent.setBackground(this.backgroundColor);
        images = new ArrayList();
        this.formToolkit = new FormToolkit(Display.getCurrent());
        this.hyperlinkGroup = this.formToolkit.getHyperlinkGroup();
        this.hyperlinkGroup.setHyperlinkUnderlineMode(2);
        this.fHyperLinkListener = new HyperLinkListener();
        this.createBackgroundImage();
        this.addIntroSection(parent);
        this.addToolsSection(parent);
    }

    private void loadHTML(FormText browser, Path path) {
        try {
            InputStream stream = FileLocator.openStream((Bundle)Platform.getBundle((String)"com.atmel.avr32.intro"), (IPath)path, (boolean)false);
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            StringBuffer welcome = new StringBuffer();
            String in = null;
            while ((in = br.readLine()) != null) {
                welcome.append(in);
                welcome.append(NEWLINE);
            }
            stream.close();
            browser.setWhitespaceNormalized(true);
            this.setBrowserImages(browser);
            browser.setText(welcome.toString(), true, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setBrowserImages(FormText browser) {
        browser.setImage("install", IntroPlugin.getDefault().getImageRegistry().get("install"));
        browser.setImage("projectWizard", IntroPlugin.getDefault().getImageRegistry().get("projectWizard"));
        browser.setImage("importWizard", IntroPlugin.getDefault().getImageRegistry().get("importWizard"));
        browser.setImage("exportWizardZip", IntroPlugin.getDefault().getImageRegistry().get("exportWizardZip"));
        browser.setImage("exportWizardFile", IntroPlugin.getDefault().getImageRegistry().get("exportWizardFile"));
        browser.setImage("macroExpansion", IntroPlugin.getDefault().getImageRegistry().get("macroExpansion"));
    }

    public void setFocus() {
    }

    public void standbyStateChanged(boolean standby) {
        this.introSection.setVisible(!standby);
        ((GridData)this.introSection.getLayoutData()).exclude = standby;
    }

    private void install(String iu) {
        IStatus status = P2Util.install(iu);
        if (status.getSeverity() == 8) {
            MessageDialog.openInformation((Shell)this.getIntroSite().getShell(), (String)"Installation cancelled", (String)status.getMessage());
        } else if (!status.isOK()) {
            StatusManager.getManager().handle(status, 2);
        }
    }

    private boolean listOptionals() {
        IProfileRegistry profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IProfileRegistry.class.getName());
        if (profileRegistry == null) {
            System.err.println("No profile registry!");
            return false;
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            System.err.println("No profile!");
            return false;
        }
        final Collector installedIUs = profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        if (installedIUs.isEmpty()) {
            System.out.println("No features found in profile!");
            return false;
        }
        final IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IMetadataRepositoryManager.class.getName());
        if (repoManager == null) {
            System.err.println("No repo manager");
            return false;
        }
        final URI[] reposToSearch = P2Util.getOptionalRepos();
        if (reposToSearch.length == 0) {
            System.err.println("No repos");
            return false;
        }
        IPlanner planner = (IPlanner)ServiceHelper.getService((BundleContext)IntroPlugin.bundleContext, (String)IPlanner.class.getName());
        if (planner == null) {
            System.err.println("No planner");
            return false;
        }
        Job j = new Job("Searching for optional features"){

            public IStatus run(IProgressMonitor monitor) {
                AVR32StudioIntroPart.this.newFeaturesCount = 0;
                Collector c = new Collector();
                int i = 0;
                while (i < reposToSearch.length) {
                    try {
                        IMetadataRepository repo = repoManager.loadRepository(reposToSearch[i], monitor);
                        repo.query((Query)InstallableUnitQuery.ANY, c, monitor);
                    }
                    catch (ProvisionException provisionException) {}
                    ++i;
                }
                Iterator iter = c.iterator();
                final StringBuilder sb = new StringBuilder();
                sb.append("<form>\n");
                while (iter.hasNext()) {
                    IInstallableUnit iu = (IInstallableUnit)iter.next();
                    if (!iu.getId().endsWith("feature.group")) continue;
                    boolean installed = false;
                    for (IInstallableUnit iu2 : installedIUs) {
                        if (!iu2.getId().equals(iu.getId())) continue;
                        installed = true;
                    }
                    if (installed) continue;
                    sb.append("<li style=\"image\" value=\"install\"><a href=\"install://");
                    sb.append(iu.getId());
                    sb.append("\" alt=\"Install " + iu.getId() + "\">");
                    sb.append("Install ");
                    sb.append(iu.getProperty("org.eclipse.equinox.p2.name"));
                    sb.append("</a></li>\n");
                    ++AVR32StudioIntroPart.this.newFeaturesCount;
                }
                if (AVR32StudioIntroPart.this.newFeaturesCount == 0) {
                    sb.append("<i>No optional features are available for installation</i>");
                }
                sb.append("</form>\n");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control[] children;
                        AVR32StudioIntroPart.this.optionalFeaturesWidget.setText(sb.toString(), true, false);
                        Control[] controlArray = children = AVR32StudioIntroPart.this.quickLinkSection.getChildren();
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control c = controlArray[n2];
                            c.redraw();
                            c.update();
                            ++n2;
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        return true;
    }

    private class HeadingPainter
    implements PaintListener {
        private static final String PRESENTATION_CARD_TITLE_FONT_ID = "com.atmel.avr32.intro.cardTitleFont";
        String name;

        public HeadingPainter(String text) {
            this.name = text;
        }

        public void paintControl(PaintEvent e) {
            e.gc.setAdvanced(true);
            e.gc.setAntialias(1);
            org.eclipse.swt.graphics.Path path = null;
            Rectangle oldClipping = null;
            if (e.gc.getAdvanced()) {
                oldClipping = e.gc.getClipping();
                path = AVR32StudioIntroPart.this.createHeadingClippingPath(e.gc);
                e.gc.setClipping(path);
                e.gc.setBackground(AVR32StudioIntroPart.this.borderColor);
                e.gc.fillPath(path);
            }
            Font font = fr.get(PRESENTATION_CARD_TITLE_FONT_ID);
            e.gc.setFont(font);
            e.gc.setForeground(AVR32StudioIntroPart.getStandardDisplay().getSystemColor(1));
            e.gc.drawString(this.name, 10, 2, true);
            if (e.gc.getAdvanced() && path != null) {
                e.gc.setClipping(oldClipping);
                e.gc.setForeground(AVR32StudioIntroPart.this.borderColor);
                e.gc.drawPath(path);
                path.dispose();
            }
        }
    }

    private class HyperLink
    extends ImageHyperlink {
        int offset;

        public HyperLink(Composite parent, int style, int offset) {
            super(parent, style);
            this.offset = 0;
            this.offset = offset;
        }

        protected void paint(PaintEvent e) {
            if (AVR32StudioIntroPart.this.background != null) {
                Rectangle r = this.getBounds();
                e.gc.setAdvanced(false);
                e.gc.drawImage(AVR32StudioIntroPart.this.background, 0, this.offset, r.width, r.height, 0, 0, r.width, r.height);
            }
            super.paint(e);
        }
    }

    private class HyperLinkListener
    extends HyperlinkAdapter {
        private static final String PREFERENCES_PROTOCOL = "prefs://";
        private static final String WIZARD_PROTOCOL = "wizard://";

        private HyperLinkListener() {
        }

        private void closePage() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IViewReference[] vr = window.getActivePage().getViewReferences();
                        PlatformUI.getWorkbench().showPerspective(AVR32StudioIntroPart.DEFAULT_PERSPECTIVE, window);
                        IViewReference[] iViewReferenceArray = vr;
                        int n = vr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IViewReference viewReference = iViewReferenceArray[n2];
                            if (viewReference.getId().equals("org.eclipse.ui.internal.introview")) {
                                window.getActivePage().hideView(viewReference);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public void linkActivated(HyperlinkEvent event) {
            String id;
            super.linkActivated(event);
            final String link = event.getHref().toString();
            if (link.startsWith(AVR32StudioIntroPart.PROTOCOL_HELP)) {
                AVR32StudioIntroPart.this.displayHelpResource(link.substring(6));
            }
            if (link.startsWith(AVR32StudioIntroPart.PROTOCOL_INSTALL)) {
                AVR32StudioIntroPart.this.install(link.substring(10));
            }
            if (link.startsWith(PREFERENCES_PROTOCOL)) {
                id = link.substring(8);
                PreferenceDialog d = PreferencesUtil.createPreferenceDialogOn((Shell)AVR32StudioIntroPart.getStandardDisplay().getActiveShell(), (String)id, null, (Object)new Object[0]);
                d.open();
            }
            if (link.startsWith(WIZARD_PROTOCOL)) {
                id = link.substring(9);
                IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
                if (descriptor == null) {
                    descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(id);
                }
                if (descriptor == null) {
                    descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(id);
                }
                try {
                    if (descriptor != null) {
                        IWorkbenchWizard wizard = descriptor.createWizard();
                        WizardDialog wd = new WizardDialog(AVR32StudioIntroPart.getStandardDisplay().getActiveShell(), (IWizard)wizard);
                        wd.setTitle(wizard.getWindowTitle());
                        if (wd.open() != 1) {
                            this.closePage();
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (link.startsWith(AVR32StudioIntroPart.PAGE_PROTOCOL)) {
                for (ImageHyperlink l : AVR32StudioIntroPart.this.fHyperlinks) {
                    l.redraw();
                }
                AVR32StudioIntroPart.this.currentPage = Integer.parseInt(link.substring(7));
                AVR32StudioIntroPart.this.pageBook.showPage((Object)link.substring(7));
            }
            if (link.startsWith(AVR32StudioIntroPart.PROTOCOL_HTTP)) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(link));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (link.startsWith(AVR32StudioIntroPart.PROTOCOL_ACTION)) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PlatformUI.getWorkbench().getIntroManager().setIntroStandby((IIntroPart)AVR32StudioIntroPart.this, true);
                            PlatformUI.getWorkbench().showPerspective(AVR32StudioIntroPart.DEFAULT_PERSPECTIVE, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        }
                        catch (WorkbenchException e) {
                            e.printStackTrace();
                        }
                        new OpenCheatSheetAction(link.substring(8)).run();
                    }
                });
            }
            if (link.equals("exit")) {
                this.closePage();
            }
            if (link.startsWith("action://") && (id = link.substring(9)).equals("newExampleAction")) {
                AVR32StudioIntroPart.this.exampleAction.run();
            }
        }
    }

    private class PresentationCardPainter
    implements PaintListener {
        private static final String PRESENTATION_CARD_TITLE_FONT_ID = "com.atmel.avr32.intro.cardTitleFont";
        Image image;
        int height;
        String name;

        public PresentationCardPainter(Image image, String name, int height) {
            this.image = image;
            this.name = name;
            this.height = height;
        }

        public void paintControl(PaintEvent e) {
            e.gc.setAdvanced(true);
            e.gc.setAntialias(1);
            e.gc.setInterpolation(2);
            org.eclipse.swt.graphics.Path path = null;
            Rectangle oldClipping = null;
            if (e.gc.getAdvanced()) {
                oldClipping = e.gc.getClipping();
                path = AVR32StudioIntroPart.this.createClippingPath(e.gc, this.height);
                e.gc.setClipping(path);
            }
            e.gc.drawImage(AVR32StudioIntroPart.this.background, 0, 0);
            if (this.image != null) {
                int verticalOffset = (this.height - this.image.getBounds().height) / 2;
                int horizontalOffset = (160 - this.image.getBounds().width) / 2;
                e.gc.drawImage(this.image, 0, 0, this.image.getBounds().width, this.image.getBounds().height, horizontalOffset, verticalOffset, this.image.getBounds().width, this.image.getBounds().height);
            }
            Font font = fr.get(PRESENTATION_CARD_TITLE_FONT_ID);
            e.gc.setFont(font);
            e.gc.setForeground(AVR32StudioIntroPart.getStandardDisplay().getSystemColor(2));
            e.gc.drawString(this.name, 132, 2, true);
            if (e.gc.getAdvanced() && path != null) {
                e.gc.setClipping(oldClipping);
                e.gc.setForeground(AVR32StudioIntroPart.this.borderColor);
                e.gc.drawPath(path);
                path.dispose();
            }
        }
    }

    private class PresentationCardSorter
    implements Comparator<IConfigurationElement> {
        private String[] sizes = new String[]{"full", "half"};

        private PresentationCardSorter() {
        }

        @Override
        public int compare(IConfigurationElement o1, IConfigurationElement o2) {
            String c2;
            int p1 = 99;
            int p2 = 99;
            if (o1.getAttribute(AVR32StudioIntroPart.ORDER_ATTRIBUTE) != null) {
                p1 = Integer.parseInt(o1.getAttribute(AVR32StudioIntroPart.ORDER_ATTRIBUTE));
            }
            if (o2.getAttribute(AVR32StudioIntroPart.ORDER_ATTRIBUTE) != null) {
                p2 = Integer.parseInt(o2.getAttribute(AVR32StudioIntroPart.ORDER_ATTRIBUTE));
            }
            if (p1 != p2) {
                return p1 - p2;
            }
            String c1 = o1.getAttribute(AVR32StudioIntroPart.CATEGORY_ATTRIBUTE);
            if (c1.compareTo(c2 = o2.getAttribute(AVR32StudioIntroPart.CATEGORY_ATTRIBUTE)) != 0) {
                return c1.compareTo(c2);
            }
            String s1 = o1.getAttribute("size");
            String s2 = o2.getAttribute("size");
            if (s1 == null) {
                p1 = 0;
            } else {
                p1 = 0;
                while (p1 < this.sizes.length) {
                    if (s1.equals(this.sizes[p1])) break;
                    ++p1;
                }
            }
            if (s2 == null) {
                p2 = 0;
            } else {
                p2 = 0;
                while (p2 < this.sizes.length) {
                    if (s2.equals(this.sizes[p2])) break;
                    ++p2;
                }
            }
            if (p1 != p2) {
                return p1 - p2;
            }
            String n1 = o1.getAttribute(AVR32StudioIntroPart.NAME_ATTRIBUTE);
            String n2 = o2.getAttribute(AVR32StudioIntroPart.NAME_ATTRIBUTE);
            return n1.compareTo(n2);
        }
    }
}

