/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;

public class CVSHistoryFilter
extends ViewerFilter {
    public String author;
    public Date fromDate;
    public Date toDate;
    public String comment;
    public boolean isOr;
    private int matchCounter;

    public CVSHistoryFilter(String author, String comment, Date fromDate, Date toDate, boolean isOr) {
        this.author = author;
        this.comment = comment;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.isOr = isOr;
        this.matchCounter = 0;
    }

    public boolean select(Viewer aviewer, Object parentElement, Object element) {
        if (element instanceof AbstractHistoryCategory) {
            return true;
        }
        if (element instanceof CVSFileRevision) {
            boolean andSearch;
            CVSFileRevision entry = (CVSFileRevision)element;
            if (this.isOr) {
                boolean orSearch;
                boolean bl = orSearch = this.hasAuthor() && this.authorMatch(entry) || this.hasDate() && this.dateMatch(entry) || this.hasComment() && this.commentMatch(entry);
                if (orSearch) {
                    ++this.matchCounter;
                }
                return orSearch;
            }
            boolean bl = andSearch = !(this.hasAuthor() && !this.authorMatch(entry) || this.hasDate() && !this.dateMatch(entry) || this.hasComment() && !this.commentMatch(entry));
            if (andSearch) {
                ++this.matchCounter;
            }
            return andSearch;
        }
        return false;
    }

    protected boolean authorMatch(CVSFileRevision revision) {
        return revision.getAuthor().equals(this.author);
    }

    protected boolean commentMatch(CVSFileRevision revision) {
        return revision.getComment().toLowerCase().indexOf(this.comment.toLowerCase()) != -1;
    }

    protected boolean dateMatch(CVSFileRevision revision) {
        return this.isAfterFromDate(revision) && this.isBeforeToDate(revision);
    }

    private boolean isBeforeToDate(CVSFileRevision revision) {
        if (this.toDate == null) {
            return true;
        }
        return this.toDate.after(new Date(revision.getTimestamp()));
    }

    private boolean isAfterFromDate(CVSFileRevision revision) {
        if (this.fromDate == null) {
            return true;
        }
        return this.fromDate.before(new Date(revision.getTimestamp()));
    }

    protected boolean hasAuthor() {
        return !this.author.equals("");
    }

    protected boolean hasComment() {
        return !this.comment.equals("");
    }

    protected boolean hasDate() {
        return this.fromDate != null || this.toDate != null;
    }

    public int getMatchCount() {
        return this.matchCounter;
    }
}

