/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.properties;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.target.TargetPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class FlashVaultPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Composite fFlashVaultGroup;
    private Button fEnableFlashVault;
    private Text fProtectedRAM;
    private Text fProtectedFlash;

    protected Control createContents(Composite parent) {
        this.fFlashVaultGroup = new Composite(parent, 0);
        GridData span = new GridData(4, 1, true, false);
        span.horizontalSpan = 2;
        this.fFlashVaultGroup.setLayoutData((Object)span);
        this.fFlashVaultGroup.setLayout((Layout)new GridLayout(2, false));
        this.fEnableFlashVault = new Button(this.fFlashVaultGroup, 32);
        this.fEnableFlashVault.setLayoutData((Object)span);
        this.fEnableFlashVault.setText("Enable FlashVault memory protection technology");
        final Label l1 = new Label(this.fFlashVaultGroup, 0);
        l1.setText("Size of protected area in RAM (kiB):");
        this.fProtectedRAM = new Text(this.fFlashVaultGroup, 2048);
        this.fProtectedRAM.setLayoutData((Object)new GridData(4, 1, true, false));
        final Label l2 = new Label(this.fFlashVaultGroup, 0);
        l2.setText("Size of protected area in flash memory (kiB):");
        this.fProtectedFlash = new Text(this.fFlashVaultGroup, 2048);
        this.fProtectedFlash.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fEnableFlashVault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlashVaultPage.this.updateFields(l1, l2);
            }
        });
        Object o = this.getElement().getAdapter(IProject.class);
        if (o != null) {
            IProject p = (IProject)o;
            String part = ManagedbuildPlugin.getProjectMCU((IProject)p);
            this.setEnabled(this.fFlashVaultGroup, TargetPlugin.getDefault().supportsCapability(part, TargetPlugin.CapabilityId.flashvault));
            this.fEnableFlashVault.setSelection(ManagedbuildPlugin.isSecured((IProject)p));
            this.fProtectedRAM.setText(Integer.toString(ManagedbuildPlugin.getSecuredRAMLength((IProject)p)));
            this.fProtectedFlash.setText(Integer.toString(ManagedbuildPlugin.getSecuredFlashLength((IProject)p)));
            this.updateFields(l1, l2);
        }
        return this.fFlashVaultGroup;
    }

    private void setEnabled(Composite group, boolean enabled) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
        group.setEnabled(enabled);
    }

    public boolean performOk() {
        Object o = this.getElement().getAdapter(IProject.class);
        if (o != null) {
            IProject p = (IProject)o;
            ManagedbuildPlugin.setFlashVaultOptions((IProject)p, (boolean)this.fEnableFlashVault.getSelection(), (int)Integer.decode(this.fProtectedRAM.getText()), (int)Integer.decode(this.fProtectedFlash.getText()));
        }
        return super.performOk();
    }

    private void updateFields(Label l1, Label l2) {
        this.fProtectedRAM.setEnabled(this.fEnableFlashVault.getSelection());
        this.fProtectedFlash.setEnabled(this.fEnableFlashVault.getSelection());
        l1.setEnabled(this.fEnableFlashVault.getSelection());
        l2.setEnabled(this.fEnableFlashVault.getSelection());
    }
}

