/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.wizards;

import com.atmel.avr32.managedbuilder.ui.wizards.Messages;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.tool.ui.DefaultPartSelectionProvider;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class MainProjectWizardPage
extends WizardNewProjectCreationPage {
    private static final String EMPTY_STRING = "";
    private Text fTargetCPU;
    private Combo fProjectType;
    private Group fFlashVaultGroup;
    private String helpId;
    private Button fEnableFlashVault;
    private Text fProtectedRAM;
    private Text fProtectedFlash;

    public MainProjectWizardPage(String pageName, String title, String description, String helpId) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
        this.helpId = helpId;
    }

    public Control getControl() {
        Control c = super.getControl();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, this.helpId);
        return c;
    }

    private void addTypeSection(Composite composite) {
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.MainProjectWizardPage_ProjectType);
        label2.setLayoutData((Object)new GridData());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fProjectType = new Combo(composite, 2060);
        this.fProjectType.setLayoutData((Object)gd);
        this.fProjectType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainProjectWizardPage.this.setPageComplete(MainProjectWizardPage.this.validatePage());
            }
        });
    }

    private void addFlashVaultGroup(Composite composite) {
        this.fFlashVaultGroup = new Group(composite, 0);
        GridData span = new GridData(4, 4, true, true);
        span.horizontalSpan = 2;
        this.fFlashVaultGroup.setLayoutData((Object)span);
        this.fFlashVaultGroup.setLayout((Layout)new GridLayout(2, false));
        this.fFlashVaultGroup.setText("FlashVault");
        this.fEnableFlashVault = new Button((Composite)this.fFlashVaultGroup, 32);
        this.fEnableFlashVault.setLayoutData((Object)span);
        this.fEnableFlashVault.setText("Enable FlashVault");
        final Label l1 = new Label((Composite)this.fFlashVaultGroup, 0);
        l1.setText("Size of protected area in RAM (kiB):");
        this.fProtectedRAM = new Text((Composite)this.fFlashVaultGroup, 2048);
        final Label l2 = new Label((Composite)this.fFlashVaultGroup, 0);
        l2.setText("Size of protected area in flash memory (kiB):");
        this.fProtectedFlash = new Text((Composite)this.fFlashVaultGroup, 2048);
        this.fEnableFlashVault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainProjectWizardPage.this.fProtectedRAM.setEnabled(MainProjectWizardPage.this.fEnableFlashVault.getSelection());
                MainProjectWizardPage.this.fProtectedFlash.setEnabled(MainProjectWizardPage.this.fEnableFlashVault.getSelection());
                l1.setEnabled(MainProjectWizardPage.this.fEnableFlashVault.getSelection());
                l2.setEnabled(MainProjectWizardPage.this.fEnableFlashVault.getSelection());
            }
        });
    }

    private void addMCUSection(Composite c) {
        Label label2 = new Label(c, 0);
        label2.setText(Messages.MainProjectWizardPage_TargetMCU);
        label2.setLayoutData((Object)new GridData());
        this.fTargetCPU = new Text(c, 2060);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.fTargetCPU.setLayoutData((Object)gd);
        this.fTargetCPU.setText(PartRegistry.getDefaultPart());
        Button browse = new Button(c, 0);
        browse.setText("...");
        browse.setLayoutData((Object)new GridData());
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DefaultPartSelectionProvider provider = DefaultPartSelectionProvider.getDefault();
                String part = provider.getPart(null);
                MainProjectWizardPage.this.fTargetCPU.setText(part);
                MainProjectWizardPage.this.updateProjectTypes();
                MainProjectWizardPage.this.updateFlashVaultGroup(part);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void updateProjectTypes() {
        String[] allowedTypes;
        this.fProjectType.removeAll();
        String[] stringArray = allowedTypes = PartRegistry.getProjectTypes((String)this.getSelectedMCU());
        int n = allowedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String projectType = stringArray[n2];
            this.fProjectType.add(ManagedBuildManager.getProjectType((String)projectType).getName());
            ++n2;
        }
        if (this.fProjectType.getItemCount() == 1) {
            this.fProjectType.select(0);
        } else {
            this.fProjectType.setText(EMPTY_STRING);
        }
        this.setMessage(Messages.MainProjectWizardPage_ProjectTypeMessage);
        this.setPageComplete(this.validatePage());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        Group group = new Group(composite, 0);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setText(Messages.MainProjectWizardPage_AVR32Group);
        group.setLayoutData((Object)new GridData(768));
        this.addMCUSection((Composite)group);
        this.addTypeSection((Composite)group);
        this.addFlashVaultGroup(composite);
        this.updateProjectTypes();
        this.updateFlashVaultGroup(PartRegistry.getDefaultPart());
    }

    protected IProjectType getSelectedProjectType() {
        IProjectType[] projectTypes;
        if (this.fProjectType == null) {
            return null;
        }
        String label = this.fProjectType.getText();
        IProjectType[] iProjectTypeArray = projectTypes = ManagedBuildManager.getDefinedProjectTypes();
        int n = projectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectType projectType = iProjectTypeArray[n2];
            if (projectType.getName().equals(label)) {
                return projectType;
            }
            ++n2;
        }
        return null;
    }

    public String getSelectedMCU() {
        if (this.fTargetCPU == null) {
            return null;
        }
        return this.fTargetCPU.getText();
    }

    public boolean isFlashVaultEnabled() {
        return this.fEnableFlashVault.getSelection() && TargetPlugin.getDefault().supportsCapability(this.getSelectedMCU(), TargetPlugin.CapabilityId.flashvault);
    }

    public int getSecuredFlashSize() {
        try {
            return Integer.decode(this.fProtectedFlash.getText());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getSecuredRAMSize() {
        try {
            return Integer.decode(this.fProtectedRAM.getText());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void setEnabled(Composite group, boolean enabled) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
        group.setEnabled(enabled);
    }

    protected boolean validatePage() {
        String[] types;
        if (PartRegistry.getPartNames().size() == 0) {
            this.setErrorMessage(Messages.MainProjectWizardPage_NoParts);
            return false;
        }
        String name = this.getProjectName();
        if (name != null) {
            int a = 0;
            while (a < name.length()) {
                char c = name.charAt(a);
                if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c != '-') {
                    this.setErrorMessage(Messages.MainProjectWizardPage_BadProjectName);
                    return false;
                }
                ++a;
            }
        }
        boolean found = false;
        IProjectType type = this.getSelectedProjectType();
        if (type == null) {
            return false;
        }
        String[] stringArray = types = PartRegistry.getProjectTypes((String)this.getSelectedMCU());
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (type.getId().equals(string)) {
                found = true;
            }
            ++n2;
        }
        if (!found) {
            this.setErrorMessage(Messages.MainProjectWizardPage_BadProjectType);
            return false;
        }
        return super.validatePage();
    }

    public boolean useDefaults() {
        return super.useDefaults();
    }

    private void updateFlashVaultGroup(String part) {
        this.setEnabled((Composite)this.fFlashVaultGroup, TargetPlugin.getDefault().supportsCapability(part, TargetPlugin.CapabilityId.flashvault));
    }
}

