/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.wizards;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.managedbuilder.ui.wizards.MainProjectWizardPage;
import com.atmel.avr32.managedbuilder.ui.wizards.Messages;
import com.atmel.avr32.ui.AVR32PluginImages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class AbstractProjectWizard
extends BasicNewProjectResourceWizard
implements IExecutableExtension {
    private static final String OP_ERROR = "CProjectWizard.op_error";
    private static final String OP_DESC = "CProjectWizard.op_description";
    MainProjectWizardPage page;
    protected IProject newProject;
    protected IConfigurationElement fConfigElement;

    public AbstractProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.AbstractProjectWizard_Title);
        this.setDefaultPageImageDescriptor(AVR32PluginImages.WIZBAN_AVR32);
    }

    protected IPath getLocationPath() throws UnsupportedOperationException {
        if (this.page == null) {
            throw new UnsupportedOperationException();
        }
        return this.page.getLocationPath();
    }

    protected IProject getProjectHandle() throws UnsupportedOperationException {
        if (this.page == null) {
            throw new UnsupportedOperationException();
        }
        return this.page.getProjectHandle();
    }

    public abstract String getProjectID();

    protected IProject createNewProject(IProgressMonitor monitor) throws CoreException {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = null;
        try {
            newProjectHandle = this.getProjectHandle();
        }
        catch (UnsupportedOperationException e) {
            throw new CoreException((IStatus)new Status(4, "com.atmel.avr32.core", 0, e.getMessage(), null));
        }
        this.newProject = this.createProject(monitor, newProjectHandle, this.page.getSelectedMCU(), this.page.isFlashVaultEnabled(), this.page.getSecuredRAMSize(), this.page.getSecuredFlashSize());
        return this.newProject;
    }

    public IProjectType getSelectedProjectType() {
        return this.page.getSelectedProjectType();
    }

    private IProject createProject(IProgressMonitor monitor, IProject handle, String mcu, boolean flashVault, int ram, int flash) throws CoreException {
        IPath newPath;
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.getLocationPath()))) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(handle.getName());
        description.setLocation(newPath);
        IProject p = CCorePlugin.getDefault().createCProject(description, handle, monitor, this.getProjectID());
        ManagedbuildPlugin.setProjectMCU((IProject)p, (String)mcu);
        ManagedbuildPlugin.setFlashVaultOptions((IProject)p, (boolean)flashVault, (int)ram, (int)flash);
        return p;
    }

    public IRunnableWithProgress getRunnable() {
        return new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor imonitor) throws InvocationTargetException, InterruptedException {
                final Exception[] except = new Exception[1];
                AbstractProjectWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Object fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
                                fMonitor.beginTask(CUIPlugin.getResourceString((String)AbstractProjectWizard.OP_DESC), 3);
                                AbstractProjectWizard.this.doRunPrologue((IProgressMonitor)new SubProgressMonitor(fMonitor, 1));
                                try {
                                    AbstractProjectWizard.this.doRun((IProgressMonitor)new SubProgressMonitor(fMonitor, 1));
                                }
                                catch (CoreException e) {
                                    except[0] = e;
                                }
                                AbstractProjectWizard.this.doRunEpilogue((IProgressMonitor)new SubProgressMonitor(fMonitor, 1));
                                fMonitor.done();
                            }
                        });
                        try {
                            AbstractProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)op);
                        }
                        catch (InvocationTargetException e) {
                            except[0] = e;
                        }
                        catch (InterruptedException e) {
                            except[0] = e;
                        }
                    }
                });
                if (except[0] != null) {
                    if (except[0] instanceof InvocationTargetException) {
                        throw (InvocationTargetException)except[0];
                    }
                    if (except[0] instanceof InterruptedException) {
                        throw (InterruptedException)except[0];
                    }
                    throw new InvocationTargetException(except[0]);
                }
            }
        });
    }

    protected abstract void doRunPrologue(IProgressMonitor var1);

    protected abstract void doRunEpilogue(IProgressMonitor var1);

    protected boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Shell shell = this.getShell();
            String title = CUIPlugin.getResourceString((String)"CProjectWizard.op_error.title");
            String message = CUIPlugin.getResourceString((String)"CProjectWizard.op_error.message");
            Throwable th = e.getTargetException();
            CUIPlugin.errorDialog((Shell)shell, (String)title, (String)message, (Throwable)th, (boolean)false);
            try {
                this.getProjectHandle().delete(false, false, null);
            }
            catch (CoreException coreException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        this.createNewProject(monitor);
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    protected IResource getSelectedResource() {
        return this.getNewProject();
    }

    public boolean performFinish() {
        block7: {
            if (!this.invokeRunnable(this.getRunnable())) {
                return false;
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            IResource resource = this.getSelectedResource();
            if (resource != null) {
                try {
                    this.selectAndReveal(resource);
                    if (resource.getType() != 1) break block7;
                    IFile file = (IFile)resource;
                    IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
                    if (dw == null) break block7;
                    try {
                        IWorkbenchPage page = dw.getActivePage();
                        if (page != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)dw.getShell(), (String)CUIPlugin.getResourceString((String)OP_ERROR), (String)e.getMessage());
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }
}

