/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.internal.update;

import com.atmel.avr32.managedbuilder.ui.internal.update.AbstractUpdater;
import com.atmel.avr32.managedbuilder.ui.internal.update.Messages;
import java.text.MessageFormat;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Update_0_0_0_to_2_0_1
extends AbstractUpdater {
    private static final String NEW_VERSION_SUFFIX = "_2.0.1";
    private static final String EMPTY_STRING = "";
    private static final String LINUX_PREFIX = "linux";
    private static final String GNU_PREFIX = "gnu";
    private static final String AVR32_PREFIX = "avr32";
    private final String[] KEEP_OPTIONS = new String[]{"avr32.c.compiler.option.gc-sections", "avr32.c.compiler.option.mcu", "avr32.cpp.compiler.option.gc-sections", "avr32.cpp.compiler.option.mcu", "avr32.c.linker.option.gc-sections", "avr32.c.linker.option.mcu", "avr32.cpp.linker.option.gc-sections", "avr32.cpp.linker.option.mcu", "avr32.both.asm.option.mcu", "avr32.both.asm.option.debugging.level", "avr32.both.preprocessor.option.mcu", "avr32.both.preprocessor.option.flags", "avr32.both.preprocessor.option.paths", "avr32.both.preprocessor.option.nowarn", "avr32.both.preprocessor.option.version", "avr32.both.preprocessor.option.debugging.level", "avr32linux.c.compiler.option.gc-sections", "avr32linux.c.compiler.option.mcu", "avr32linux.cpp.compiler.option.gc-sections", "avr32linux.cpp.compiler.option.mcu", "avr32linux.c.linker.option.gc-sections", "avr32linux.c.linker.option.mcu", "avr32linux.cpp.linker.option.gc-sections", "avr32linux.cpp.linker.option.mcu", "avr32linux.both.asm.option.mcu", "avr32linux.both.asm.option.debugging.level", "avr32linux.both.preprocessor.option.mcu", "avr32linux.both.preprocessor.option.flags", "avr32linux.both.preprocessor.option.paths", "avr32linux.both.preprocessor.option.nowarn", "avr32linux.both.preprocessor.option.version", "avr32linux.both.preprocessor.option.debugging.level"};

    @Override
    IManagedProject doUpdate(IManagedProject project) {
        IConfiguration[] configs = project.getConfigurations();
        String mcu = null;
        String prefix = null;
        IConfiguration[] iConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IOption[] avr32Options;
            IConfiguration configuration = iConfigurationArray[n2];
            IOption[] iOptionArray = avr32Options = this.getAVR32Options(configuration);
            int n3 = avr32Options.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption oldOption = iOptionArray[n4];
                boolean mustUpdate = true;
                String[] stringArray = this.KEEP_OPTIONS;
                int n5 = this.KEEP_OPTIONS.length;
                int n6 = 0;
                while (n6 < n5) {
                    String id = stringArray[n6];
                    if (this.getBaseId(oldOption.getId()).equals(id)) {
                        mustUpdate = false;
                        break;
                    }
                    ++n6;
                }
                String baseId = this.getBaseId(oldOption.getId());
                if (baseId.equals("avr32.both.asm.option.mcu") || baseId.equals("avr32linux.both.asm.option.mcu")) {
                    try {
                        mcu = oldOption.getStringValue();
                        prefix = baseId.substring(0, baseId.indexOf(46));
                    }
                    catch (BuildException e) {
                        e.printStackTrace();
                    }
                }
                if (mustUpdate) {
                    String newOptionName = this.getBaseId(oldOption.getId()).replace(AVR32_PREFIX, GNU_PREFIX).replace(LINUX_PREFIX, EMPTY_STRING);
                    if (baseId.equals("avr32linux.cpp.link.option.mcu") || baseId.equals("avr32linux.c.link.option.mcu")) {
                        newOptionName = baseId.replaceAll("link", "linker");
                    }
                    this.getStatus().add(this.renameOption(configuration, oldOption, newOptionName));
                }
                ++n4;
            }
            IFolderInfo folderInfo = configuration.getRootFolderInfo();
            Assert.isNotNull((Object)folderInfo);
            if (mcu != null) {
                ITool[] tools;
                ITool[] iToolArray = tools = folderInfo.getTools();
                int n7 = tools.length;
                int n8 = 0;
                while (n8 < n7) {
                    ITool tool = iToolArray[n8];
                    if (tool.getId().startsWith(String.valueOf(prefix) + ".managedbuild.tool.gnu.preprocessor")) {
                        IOption superClass = this.getOptions(configuration, String.valueOf(prefix) + ".both.preprocessor.option.mcu");
                        if (superClass != null) {
                            IOption current = tool.getOptionBySuperClassId(superClass.getId());
                            if (current == null || !current.getValue().toString().equals(mcu)) {
                                IOption newOption = tool.createOption(superClass, String.valueOf(prefix) + ".both.preprocessor.option.mcu." + ManagedBuildManager.getRandomNumber(), superClass.getName(), false);
                                ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)tool, (IOption)newOption, (String)mcu);
                                this.getStatus().add((IStatus)new Status(0, "com.atmel.avr32.managedbuilder.ui", MessageFormat.format(Messages.ConvertMessage_ChangedValue, newOption.getId(), mcu)));
                            }
                        } else {
                            this.getStatus().add((IStatus)new Status(2, "com.atmel.avr32.managedbuilder.ui", MessageFormat.format("Cannot find super class for option {0}.both.preprocessor.option.mcu", prefix)));
                        }
                    }
                    ++n8;
                }
            }
            ++n2;
        }
        return project;
    }

    @Override
    protected String getVersionSuffix() {
        return NEW_VERSION_SUFFIX;
    }
}

