/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.internal.update;

import com.atmel.avr32.managedbuilder.IProjectConverter;
import com.atmel.avr32.managedbuilder.ui.internal.update.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractUpdater
implements IProjectConverter {
    private static final String AVR_PREFIX = "avr32";
    private MultiStatus fStatus;

    public IBuildObject convert(IBuildObject buildObj, String fromId, String toId, boolean isConfirmed) {
        if (buildObj instanceof ManagedProject) {
            try {
                ManagedProject mProject = (ManagedProject)buildObj;
                this.createStatusObject((IManagedProject)mProject);
                IManagedProject project = this.doUpdate((IManagedProject)mProject);
                this.postProc((IManagedProject)mProject);
                if (project != null && isConfirmed) {
                    ManagedBuildManager.saveBuildInfo((IProject)project.getOwner().getProject(), (boolean)true);
                }
                return project;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    abstract IManagedProject doUpdate(IManagedProject var1);

    protected IOption[] getAVR32Options(IConfiguration configuration) {
        ITool[] tools;
        Assert.isNotNull((Object)configuration);
        ArrayList<IOption> list = new ArrayList<IOption>();
        IFolderInfo info = configuration.getRootFolderInfo();
        Assert.isNotNull((Object)info);
        ITool[] iToolArray = tools = info.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IOption[] options;
            ITool tool = iToolArray[n2];
            IOption[] iOptionArray = options = tool.getOptions();
            int n3 = options.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption option = iOptionArray[n4];
                if (option.getId().startsWith(AVR_PREFIX) && !option.isExtensionElement()) {
                    list.add(option);
                }
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new IOption[list.size()]);
    }

    protected String getBaseId(String id) {
        return id.substring(0, id.lastIndexOf("."));
    }

    protected IOption getOptions(IConfiguration configuration, String id) {
        ITool[] tools;
        ITool[] iToolArray = tools = configuration.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            ITool real = ManagedBuildManager.getRealTool((ITool)tool);
            IOption option = real.getOptionById(id);
            if (option != null) {
                return option;
            }
            ++n2;
        }
        return null;
    }

    protected abstract String getVersionSuffix();

    private void postProc(IManagedProject project) {
        ((BuildObject)project.getProjectType()).setId(String.valueOf(project.getProjectType().getBaseId()) + this.getVersionSuffix());
        StatusManager.getManager().handle((IStatus)this.fStatus);
    }

    protected IStatus renameOption(IConfiguration configuration, IOption oldOption, String newOptionName) {
        try {
            ITool parentTool = (ITool)oldOption.getParent();
            IOption superClass = this.getOptions(configuration, newOptionName);
            if (superClass != null) {
                IOption newOption = parentTool.createOption(superClass, String.valueOf(newOptionName) + "." + ManagedBuildManager.getRandomNumber(), superClass.getName(), false);
                switch (newOption.getBasicValueType()) {
                    case 0: {
                        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)parentTool, (IOption)newOption, (boolean)Boolean.parseBoolean(oldOption.getValue().toString()));
                        break;
                    }
                    case 2: {
                        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)parentTool, (IOption)newOption, (String)oldOption.getStringValue());
                        break;
                    }
                    case 3: {
                        String[] values = new String[]{};
                        Object value = oldOption.getValue();
                        if (value instanceof String) {
                            values = new String[]{(String)value};
                        } else if (value instanceof List) {
                            ArrayList<String> newValues = new ArrayList<String>();
                            for (Object newValue : (List)value) {
                                if (!(newValue instanceof String)) continue;
                                newValues.add((String)newValue);
                            }
                            values = newValues.toArray(new String[newValues.size()]);
                        }
                        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)newOption.getOptionHolder(), (IOption)newOption, (String[])values);
                        break;
                    }
                }
                parentTool.removeOption(oldOption);
                return new Status(0, "com.atmel.avr32.managedbuilder.ui", MessageFormat.format(Messages.ConvertMessage_Replaced, oldOption.getId(), newOption.getId()));
            }
            parentTool.removeOption(oldOption);
            return new Status(0, "com.atmel.avr32.managedbuilder.ui", MessageFormat.format(Messages.ConvertMessage_Removed, oldOption.getId()));
        }
        catch (Exception e) {
            return new Status(4, "com.atmel.avr32.managedbuilder.ui", MessageFormat.format(Messages.AbstractUpdater_ErrorRenaming, oldOption.getId()), (Throwable)e);
        }
    }

    public MultiStatus getStatus() {
        return this.fStatus;
    }

    private void createStatusObject(IManagedProject project) {
        this.fStatus = new MultiStatus("com.atmel.avr32.managedbuilder.ui", 0, MessageFormat.format(Messages.AbstractUpdater_Title, project.getOwner().getName(), this.getVersionSuffix().substring(1)), null);
    }
}

