/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.internal;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.managedbuilder.ui.internal.Messages;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.TargetPlugin;
import org.eclipse.cdt.build.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.ui.newui.ICPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PartSettingsTab
extends AbstractCBuildPropertyTab
implements ICPropertyTab {
    private Combo fTargetCPU;
    private Label description;
    private boolean managed;
    private Composite fFlashVaultGroup;
    private Button fEnableFlashVault;
    private Text fProtectedRAM;
    private Text fProtectedFlash;
    private Label l2;
    private Label l1;

    protected void performOK() {
        this.updateConfiguration(this.getCfg());
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        IConfiguration sourceCfg = PartSettingsTab.getCfg((ICConfigurationDescription)src.getConfiguration());
        if (sourceCfg instanceof MultiConfiguration) {
            IConfiguration[] cfs;
            IConfiguration[] iConfigurationArray = cfs = (IConfiguration[])((MultiConfiguration)sourceCfg).getItems();
            int n = cfs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                this.updateConfiguration(c);
                ScannerConfigBuilder.build((IConfiguration)c, (int)6, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
        } else {
            this.updateConfiguration(sourceCfg);
            ScannerConfigBuilder.build((IConfiguration)sourceCfg, (int)6, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private Composite createFlashVaultGroup(Composite parent) {
        this.fFlashVaultGroup = new Composite(parent, 0);
        GridData span = new GridData(4, 1, true, false);
        span.horizontalSpan = 2;
        this.fFlashVaultGroup.setLayoutData((Object)span);
        this.fFlashVaultGroup.setLayout((Layout)new GridLayout(2, false));
        this.fEnableFlashVault = new Button(this.fFlashVaultGroup, 32);
        this.fEnableFlashVault.setLayoutData((Object)span);
        this.fEnableFlashVault.setText("Enable FlashVault memory protection technology");
        this.l1 = new Label(this.fFlashVaultGroup, 0);
        this.l1.setText("Size of protected area in RAM (kiB):");
        this.fProtectedRAM = new Text(this.fFlashVaultGroup, 2048);
        this.fProtectedRAM.setLayoutData((Object)new GridData(4, 1, true, false));
        this.l2 = new Label(this.fFlashVaultGroup, 0);
        this.l2.setText("Size of protected area in flash memory (kiB):");
        this.fProtectedFlash = new Text(this.fFlashVaultGroup, 2048);
        this.fProtectedFlash.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fEnableFlashVault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSettingsTab.this.updateEnabledStates();
            }
        });
        return this.fFlashVaultGroup;
    }

    private void setEnabled(Composite group, boolean enabled) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
        group.setEnabled(enabled);
    }

    private void updateConfiguration(IConfiguration sourceCfg) {
        ITool[] tools;
        ITool[] iToolArray = tools = sourceCfg.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IOption[] options;
            ITool tool = iToolArray[n2];
            IOption[] iOptionArray = options = tool.getOptions();
            int n3 = options.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption setable;
                IOption option = iOptionArray[n4];
                if (option.getId().startsWith("avr32") && option.getId().indexOf(".option.mcu") > -1) {
                    try {
                        setable = tool.getOptionToSet(option, false);
                        String partOptions = PartRegistry.getToolchainOption((String)this.fTargetCPU.getText());
                        setable.setValue(partOptions);
                    }
                    catch (BuildException e) {
                        e.printStackTrace();
                    }
                }
                if (option.getId().startsWith("avr32") && option.getId().indexOf(".compiler.option.flashvault") > -1) {
                    try {
                        setable = tool.getOptionToSet(option, false);
                        setable.setValue(this.fEnableFlashVault.getSelection());
                    }
                    catch (BuildException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        ManagedbuildPlugin.setProjectMCU((IProject)this.page.getProject(), (String)this.fTargetCPU.getText());
        ManagedbuildPlugin.setFlashVaultOptions((IProject)this.page.getProject(), (boolean)this.fEnableFlashVault.getSelection(), (int)Integer.decode(this.fProtectedRAM.getText()), (int)Integer.decode(this.fProtectedFlash.getText()));
    }

    private void updateMCUList() {
        IProject project = this.page.getProject();
        this.fTargetCPU.removeAll();
        this.managed = ManagedBuildManager.canGetBuildInfo((IResource)project);
        if (this.managed) {
            this.description.setText(Messages.getString("PartSettingsTab.MCU_Description"));
            String type = ManagedbuildPlugin.getProjectTypeId((IProject)project);
            for (String name : PartRegistry.getPartNames()) {
                String[] types;
                String[] stringArray = types = PartRegistry.getProjectTypes((String)name);
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeName = stringArray[n2];
                    if (typeName.equals(type)) {
                        this.fTargetCPU.add(name);
                    }
                    ++n2;
                }
            }
        } else {
            for (String name : PartRegistry.getPartNames()) {
                this.fTargetCPU.add(name);
            }
        }
        String cpu = ManagedbuildPlugin.getProjectMCU((IProject)project);
        if (cpu != null) {
            this.fTargetCPU.setText(cpu);
        }
    }

    public boolean canBeVisible() {
        IProject project = this.page.getProject();
        return ManagedbuildPlugin.isAVR32Project((IProject)project);
    }

    protected void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        this.description = new Label(this.usercomp, 64);
        GridData gd = new GridData(4, 128, false, false, 2, 1);
        this.description.setLayoutData((Object)gd);
        Label label2 = new Label(this.usercomp, 0);
        label2.setLayoutData((Object)new GridData());
        label2.setText(Messages.getString("PartSettingsTab.MCU_Label"));
        this.fTargetCPU = new Combo(this.usercomp, 2060);
        this.fTargetCPU.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateMCUList();
        this.createFlashVaultGroup(this.usercomp);
        this.fTargetCPU.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSettingsTab.this.updateEnabledStates();
            }
        });
        this.updateFlashVaultSettings();
        this.updateEnabledStates();
    }

    protected void performDefaults() {
    }

    private void updateFlashVaultSettings() {
        this.fEnableFlashVault.setSelection(ManagedbuildPlugin.isSecured((IProject)this.page.getProject()));
        this.fProtectedRAM.setText(Integer.toString(ManagedbuildPlugin.getSecuredRAMLength((IProject)this.page.getProject())));
        this.fProtectedFlash.setText(Integer.toString(ManagedbuildPlugin.getSecuredFlashLength((IProject)this.page.getProject())));
    }

    private void updateEnabledStates() {
        this.setEnabled(this.fFlashVaultGroup, TargetPlugin.getDefault().supportsCapability(this.fTargetCPU.getText(), TargetPlugin.CapabilityId.flashvault));
        if (!TargetPlugin.getDefault().supportsCapability(this.fTargetCPU.getText(), TargetPlugin.CapabilityId.flashvault)) {
            this.fEnableFlashVault.setSelection(false);
        }
        this.fProtectedRAM.setEnabled(this.fEnableFlashVault.getSelection());
        this.fProtectedFlash.setEnabled(this.fEnableFlashVault.getSelection());
        this.l1.setEnabled(this.fEnableFlashVault.getSelection());
        this.l2.setEnabled(this.fEnableFlashVault.getSelection());
    }

    protected void updateButtons() {
    }

    protected void updateData(ICResourceDescription cfg) {
        this.updateConfiguration(this.getCfg());
        this.updateMCUList();
    }
}

