/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.environment;

import com.atmel.avr32.managedbuilder.WindowsBuildPathResolver;
import com.atmel.avr32.managedbuilder.ui.ManagedBuildUIPlugin;
import com.atmel.avr32.managedbuilder.ui.environment.ClipboardMessageDialog;
import com.atmel.avr32.managedbuilder.ui.environment.Messages;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;

public class EnvironmentChecker
implements IStartup {
    private static final String VERSION_PATTERN = "^(.)+[ ]((\\d+)\\.(\\d+)(.)*)$";
    private static final Pattern pattern = Pattern.compile("^(.)+[ ]((\\d+)\\.(\\d+)(.)*)$");

    private CheckState check(String command) {
        CheckState st = new CheckState();
        Runtime rt = Runtime.getRuntime();
        try {
            Process process = null;
            if (WindowsBuildPathResolver.isWindows()) {
                String path = WindowsBuildPathResolver.getBinPath();
                if (path == null) {
                    st.state = 3;
                    return st;
                }
                path = "PATH=" + path.replaceAll("/", "\\\\");
                String cmd = "cmd.exe /C " + command;
                process = rt.exec(cmd, new String[]{path});
            } else {
                process = rt.exec(command);
            }
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int exit = process.waitFor();
            if (exit == 0) {
                st.commandOutput = processOutput.readLine().trim();
                st.state = st.commandOutput == null || st.commandOutput.length() == 0 ? 1 : 0;
                processOutput.close();
            }
        }
        catch (Exception exception) {
            st.state = 2;
        }
        return st;
    }

    public boolean environmentCheck(boolean silent) {
        int errors = 0;
        StringBuffer message = new StringBuffer();
        errors += this.versionInfo("avr32program", message, 4, 1);
        errors += this.versionInfo("avr32gdbproxy", message, 4, 1);
        errors += this.versionInfo("avr32-gdb", message, 6, 7);
        errors += this.versionInfo("avr32-g++", message, 4, 3);
        errors += this.versionInfo("avr32-gcc", message, 4, 3);
        errors += this.versionInfo("avr32-as", message, 2, 19);
        errors += this.versionInfo("avr32-nm", message, 2, 19);
        errors += this.versionInfo("avrfwupgrade", message, 2, 0);
        String path = WindowsBuildPathResolver.getBinPath();
        if (path != null) {
            message.append(MessageFormat.format(Messages.EnvironmentChecker_MinGW, WindowsBuildPathResolver.getEnvironment().ordinal()));
        }
        if (errors > 0) {
            message.append(MessageFormat.format(Messages.EnvironmentChecker_Problems, new Integer(errors)));
            if (path == null) {
                message.append(MessageFormat.format(Messages.EnvironmentChecker_NoToolchain, new Object[0]));
                this.errorMessage(Messages.EnvironmentChecker_Results, message.toString());
            } else {
                if (WindowsBuildPathResolver.isWindows()) {
                    path = path.replaceAll("/", "\\\\");
                }
                this.errorMessage(Messages.EnvironmentChecker_Results, MessageFormat.format(Messages.EnvironmentChecker_Path, message.toString(), path));
            }
            return false;
        }
        if (!silent) {
            this.infoMessage(Messages.EnvironmentChecker_Results, MessageFormat.format(Messages.EnvironmentChecker_Message, message.toString()));
        }
        return true;
    }

    private int versionInfo(String program, StringBuffer message, int major, int minor) {
        message.append('\n');
        message.append(program);
        message.append(": ");
        CheckState state = this.check(String.valueOf(program) + " --version");
        if (state.state == 2 || state.state == 3) {
            message.append(MessageFormat.format(Messages.EnvironmentChecker_Not_Found, new Integer(major), new Integer(minor)));
            return 1;
        }
        if (state.state == 1) {
            message.append(MessageFormat.format(Messages.EnvironmentChecker_Unknown, new Integer(major), new Integer(minor)));
            return 1;
        }
        if (state.state == 0) {
            Matcher m = pattern.matcher(state.commandOutput);
            if (m.matches()) {
                int majorv = Integer.parseInt(m.group(3));
                int minorv = Integer.parseInt(m.group(4));
                message.append(MessageFormat.format(Messages.EnvironmentChecker_Found, m.group(2)));
                if (majorv == major && minorv < minor || majorv < major) {
                    message.append(MessageFormat.format(Messages.EnvironmentChecker_Need, new Integer(major), new Integer(minor)));
                    return 1;
                }
            } else {
                message.append(MessageFormat.format(Messages.EnvironmentChecker_Unknown, new Integer(major), new Integer(minor)));
                return 1;
            }
        }
        return 0;
    }

    void infoMessage(final String title, final String message) {
        final Display d = PlatformUI.getWorkbench().getDisplay();
        d.syncExec(new Runnable(){

            @Override
            public void run() {
                ClipboardMessageDialog.openInformation(d.getActiveShell(), title, message);
            }
        });
    }

    void errorMessage(final String title, final String message) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ClipboardMessageDialog.openError(display.getActiveShell(), title, message);
            }
        });
    }

    public void earlyStartup() {
        if (System.getProperty("no-environment-check") != null) {
            System.out.println("\"no-environment-check\" specified, not running environment check");
            return;
        }
        IPreferenceStore store = ManagedBuildUIPlugin.getDefault().getPreferenceStore();
        boolean ok = this.environmentCheck(store.getBoolean("ENVIRONMENT_CHECK"));
        store.setValue("ENVIRONMENT_CHECK", ok);
    }

    private class CheckState {
        String commandOutput = null;
        int state = 2;

        private CheckState() {
        }
    }
}

