/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.environment;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ClipboardMessageDialog
extends MessageDialog {
    private static final String COPY_TO_CLIPBOARD = "Copy to clipboard";

    public ClipboardMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public static void openError(Shell parent, String title, String message) {
        ClipboardMessageDialog dialog = new ClipboardMessageDialog(parent, title, null, message, 1, new String[]{COPY_TO_CLIPBOARD, IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static void openInformation(Shell parent, String title, String message) {
        ClipboardMessageDialog dialog = new ClipboardMessageDialog(parent, title, null, message, 2, new String[]{COPY_TO_CLIPBOARD, IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId != 0) {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button copyToClipboardButton = this.getButton(0);
        copyToClipboardButton.setLayoutData((Object)new GridData(3, 3, false, false));
        copyToClipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                Transfer[] transfers = new Transfer[]{textTransfer};
                Object[] data = new Object[]{ClipboardMessageDialog.this.message.replaceAll("\\n", System.getProperty("line.separator"))};
                clipboard.setContents(data, transfers);
                clipboard.dispose();
            }
        });
    }
}

